/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.PublicClonable;
import com.sas.collection.OrderedCollection;
import com.sas.io.File;
import com.sas.io.FileSystemPeer;
import com.sas.io.RB;
import com.sas.util.Strings;

class WindowsFileSystemPeer
extends FileSystemPeer
implements PublicClonable {
    protected String nodeText;
    protected File rootDirectory;
    private static String RB_KEY = "WindowsFileSystemPeer.";

    public WindowsFileSystemPeer(String driveName) {
        WindowsFileSystemPeer.setErrorMode();
        this._setRootDirectory(driveName);
        this._setNodeText();
    }

    public WindowsFileSystemPeer() {
    }

    private String validateRootDirectory(String driveName) {
        if (driveName.length() == 1 && !driveName.endsWith(":")) {
            driveName = driveName + ":";
        }
        if (driveName.endsWith(File.separator)) {
            driveName = driveName.substring(0, driveName.lastIndexOf(File.separator));
        }
        return driveName;
    }

    public Object clone() throws CloneNotSupportedException {
        WindowsFileSystemPeer newData = (WindowsFileSystemPeer)super.clone();
        newData.rootDirectory = (File)this.rootDirectory.clone();
        return newData;
    }

    @Override
    public OrderedCollection getChildren() {
        OrderedCollection oc = new OrderedCollection();
        oc.addItems(this.rootDirectory.getItems());
        return oc;
    }

    @Override
    public String getNodeText() {
        return this.nodeText;
    }

    @Override
    public String getNodeType() {
        return "Drive";
    }

    private synchronized void _setRootDirectory(String driveName) {
        driveName = this.validateRootDirectory(driveName);
        this.rootDirectory = new File(this.validateRootDirectory(driveName));
    }

    @Override
    public File getRootDirectory() {
        return this.rootDirectory;
    }

    protected synchronized void _setNodeText() {
        this.nodeText = this.rootDirectory.getPath();
    }

    public String getDriveType() {
        return this.getDeviceType();
    }

    @Override
    public String getDeviceType() {
        return this.init();
    }

    @Override
    public boolean isValid() {
        return this.rootDirectory.exists();
    }

    @Override
    public boolean canRead() {
        return this.rootDirectory.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.rootDirectory.canWrite();
    }

    private native String init();

    @Override
    public native String getFileSystemType();

    public static native void setErrorMode();

    @Override
    public native boolean chmod(File var1, int var2);

    static {
        String vendor = Strings.removeWhitespace((String)System.getProperty("java.vendor"));
        System.loadLibrary(RB.getStringResource((String)RB_KEY, (String)vendor));
    }
}

