/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.io.Printer;
import com.sas.io.RB;
import com.sas.io.WindowsPrinterListPeer;
import com.sas.models.Node;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.util.ApplyInterface;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;

public class PrinterList
extends Component
implements TreeInterface,
NodeIconInterface,
StaticOrderedCollectionInterface {
    static final long serialVersionUID = -2476245897331522952L;
    private static WindowsPrinterListPeer peer;
    private OrderedCollection oc;
    private static final String RB_KEY = "PrinterList.";
    private static String NODENAME;
    private transient ContentsChangedListenerList allContentsChangedListeners;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public PrinterList() {
        this.commonInit();
    }

    protected void commonInit() {
        String osName = System.getProperty(RB.getStringResource((String)"osName.txt"));
        if ((osName = osName.toLowerCase()).indexOf(RB.getStringResource((String)"win.txt")) >= 0) {
            peer = new WindowsPrinterListPeer();
        } else if (osName.indexOf(RB.getStringResource((String)"unix.txt")) >= 0) {
            // empty if block
        }
        this.oc = new OrderedCollection();
    }

    public void initialize() {
        if (peer == null) {
            this.commonInit();
        }
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public Object clone() throws CloneNotSupportedException {
        PrinterList newData = (PrinterList)((Object)super.clone());
        newData.allContentsChangedListeners = null;
        return newData;
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    public void fireContentsChanged(CollectionChangedInfo event) {
        if (this.allContentsChangedListeners != null) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged((ContentsChangedEvent)event);
            }
        }
    }

    public synchronized NodeInterface getRoot() {
        if (this.isDesignTime()) {
            return new Node(NODENAME, NODENAME);
        }
        return this;
    }

    private synchronized void fillList() {
        if (peer != null) {
            String[] list = peer.fillList();
            for (int i = 0; i < list.length; ++i) {
                this.oc.add((Object)new Printer(list[i]));
            }
        }
    }

    public synchronized Enumeration getItems() {
        if (this.isDesignTime()) {
            return this.oc.getItems();
        }
        if (this.oc.count() == 0) {
            this.fillList();
        }
        return this.oc.getItems();
    }

    public boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        return this.oc.equals(orderedCollection);
    }

    public Object get(int index) {
        return this.oc.get(index);
    }

    public int getIndex(Object element, int startIndex) {
        return this.oc.getIndex(element, startIndex);
    }

    public Enumeration getItems(int start, int end) {
        return this.getItems(start, end);
    }

    public int getLastIndex(Object element, int startIndex) {
        return this.getLastIndex(element, startIndex);
    }

    public boolean contains(Object element) {
        return this.oc.contains(element);
    }

    public int count() {
        return this.oc.count();
    }

    public void apply(ApplyInterface action) {
        this.oc.apply(action);
    }

    public String getNodeExpandedText() {
        return NODENAME;
    }

    public String getNodeText() {
        return NODENAME;
    }

    public String getNodeType() {
        return NODENAME;
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public int getNodeChildCount() {
        if (this.oc.count() == 0) {
            this.fillList();
        }
        return this.oc.count();
    }

    public boolean isLeafNode() {
        if (this.oc.count() == 0) {
            this.fillList();
        }
        return this.oc.count() == 0;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        if (this.oc.count() == 0) {
            this.fillList();
        }
        return (NodeInterface)this.oc.get(index);
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        if (this.oc.count() == 0) {
            this.fillList();
        }
        if (this.oc.count() > 0) {
            if (startIndex < 0 || startIndex >= this.oc.count()) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + startIndex);
            }
            if (startIndex + count > this.oc.count()) {
                throw new IndexOutOfBoundsException("Count exceeded bounds:  startIndex + count > nodeChildCount");
            }
            SimpleNodeInterface[] sni = new SimpleNodeInterface[count];
            int cnt = startIndex + count;
            for (int i = startIndex; i < cnt; ++i) {
                sni[i - startIndex] = (SimpleNodeInterface)this.oc.get(i);
            }
            return sni;
        }
        return null;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            if (peer != null) {
                this.commonInit();
            }
        }
        catch (Exception e) {
            peer = null;
        }
        stream.defaultReadObject();
    }

    public IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"Printer"));
    }

    public IconInterface getExpandedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getSelectedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getExpandedSelectedIcon() {
        return this.getDefaultIcon();
    }

    static {
        NODENAME = RB.getStringResource((String)RB_KEY, (String)"name.txt");
    }
}

