/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.io.FileSystem;
import com.sas.io.RB;
import com.sas.io.WindowsFileSystemListPeer;
import com.sas.models.Node;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.text.Message;
import com.sas.util.ApplyInterface;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;

public class FileSystemList
extends Component
implements StaticOrderedCollectionInterface,
TreeInterface,
NodeIconInterface {
    static final long serialVersionUID = -5096981374817109611L;
    private static transient WindowsFileSystemListPeer peer;
    protected transient OrderedCollection oc;
    protected transient boolean needRefresh;
    protected static String NODENAME;
    private transient ContentsChangedListenerList allContentsChangedListeners;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public FileSystemList() {
        FileSystem.setErrorMode();
        this.commonInit();
    }

    public Object clone() throws CloneNotSupportedException {
        FileSystemList newData = (FileSystemList)((Object)super.clone());
        newData.allContentsChangedListeners = null;
        newData.oc = (OrderedCollection)this.oc.clone();
        return newData;
    }

    private void commonInit() {
        String osName = System.getProperty(RB.getStringResource((String)"osName.txt"));
        if ((osName = osName.toLowerCase()).indexOf(RB.getStringResource((String)"win.txt")) >= 0) {
            peer = new WindowsFileSystemListPeer();
        } else if (osName.indexOf(RB.getStringResource((String)"unix.txt")) >= 0) {
            // empty if block
        }
        this.oc = new OrderedCollection();
        this.needRefresh = true;
    }

    public void initialize() {
        if (peer == null) {
            this.commonInit();
        }
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    public void fireContentsChanged(CollectionChangedInfo event) {
        if (this.allContentsChangedListeners != null) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged((ContentsChangedEvent)event);
            }
        }
    }

    private synchronized void fillList() {
        if (this.needRefresh) {
            this.oc = peer.fillList();
            this.needRefresh = false;
        }
    }

    public synchronized Enumeration getItems() {
        if (this.isDesignTime()) {
            return this.oc.getItems();
        }
        this.fillList();
        return this.oc.getItems();
    }

    public boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        this.fillList();
        return this.oc.equals(orderedCollection);
    }

    public Object get(int index) {
        this.fillList();
        return this.oc.get(index);
    }

    public int getIndex(Object element, int startIndex) {
        this.fillList();
        return this.oc.getIndex(element, startIndex);
    }

    public Enumeration getItems(int start, int end) {
        this.fillList();
        return this.getItems(start, end);
    }

    public int getLastIndex(Object element, int startIndex) {
        this.fillList();
        return this.getLastIndex(element, startIndex);
    }

    public boolean contains(Object element) {
        this.fillList();
        return this.oc.contains(element);
    }

    public int count() {
        this.fillList();
        return this.oc.count();
    }

    public void apply(ApplyInterface action) {
        this.fillList();
        this.oc.apply(action);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.commonInit();
        }
        catch (Exception e) {
            peer = null;
        }
        stream.defaultReadObject();
    }

    public synchronized NodeInterface getRoot() {
        if (this.isDesignTime()) {
            return new Node("FileSystemList");
        }
        return this;
    }

    public String getNodeExpandedText() {
        return NODENAME;
    }

    public String getNodeText() {
        return NODENAME;
    }

    public String getNodeType() {
        return NODENAME;
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public int getNodeChildCount() {
        return this.count();
    }

    public boolean isLeafNode() {
        int count = this.count();
        return count == 0;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        if (this.oc.count() > 0) {
            return new FileSystem((String)this.oc.get(index));
        }
        return null;
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        this.fillList();
        if (this.oc != null) {
            if (startIndex < 0 || startIndex >= this.oc.count()) {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)"indexOutOfBounds.ex.txt"), (Object)new Integer(startIndex)));
            }
            if (startIndex + count > this.oc.count()) {
                throw new IllegalArgumentException(RB.getStringResource((String)"indexExceded.ex.txt"));
            }
            SimpleNodeInterface[] sni = new SimpleNodeInterface[count];
            int cnt = startIndex + count;
            for (int i = startIndex; i < cnt; ++i) {
                FileSystem fs = new FileSystem((String)this.oc.get(i));
                sni[i - startIndex] = fs;
            }
            return sni;
        }
        return null;
    }

    public String toString() {
        this.fillList();
        System.out.println("oc:" + this.oc);
        return this.oc.toString();
    }

    public IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"MyComputer"));
    }

    public IconInterface getExpandedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getSelectedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getExpandedSelectedIcon() {
        return this.getDefaultIcon();
    }

    static {
        NODENAME = "FileSystemList";
    }
}

