/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.Component;
import com.sas.GlobalInfoTable;
import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.io.File;
import com.sas.io.FileSystemPeer;
import com.sas.io.RB;
import com.sas.io.WindowsFileSystemPeer;
import com.sas.models.NodeIconInterface;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.util.Strings;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;

public class FileSystem
extends Component
implements NodeIconInterface,
PublicClonable {
    static final long serialVersionUID = -4605053290811929354L;
    protected transient String nodeText;
    protected transient String nodeExpandedText;
    protected transient String nodeType;
    protected transient boolean leafNode;
    private transient boolean need_refresh;
    private transient OrderedCollection children;
    private FileSystemPeer peer;
    private static String RB_KEY = "FileSystem.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "fileSystemName"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"fsName.pd.txt")}}, {{"Name", "leafNode"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"leafNode.pd.txt")}}, {{"Name", "nodeText"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"nodeText.pd.txt")}}, {{"Name", "nodeExpandedText"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"nodeExpandedText.pd.txt")}}, {{"Name", "nodeType"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"nodeType.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public FileSystem(String fileSystemName) {
        FileSystem.setErrorMode();
        this.commonInit(fileSystemName);
    }

    public static FileSystemPeer getFileSystem() {
        String osName = Strings.removeWhitespace((String)System.getProperty("os.name").toLowerCase());
        try {
            Class peerClass = GlobalInfoTable.loadClass((String)RB.getStringResource((String)RB_KEY, (String)osName));
            FileSystemPeer fs = (FileSystemPeer)peerClass.newInstance();
            return fs;
        }
        catch (Exception e) {
            System.out.println("Unable to create FileSystem");
            System.exit(1);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FileSystem newData = (FileSystem)((Object)super.clone());
        newData.children = (OrderedCollection)this.children.clone();
        return newData;
    }

    protected void commonInit(String fileSystemName) {
        String osName = Strings.removeWhitespace((String)System.getProperty("os.name").toLowerCase());
        try {
            Class peerClass = GlobalInfoTable.loadClass((String)RB.getStringResource((String)RB_KEY, (String)osName));
            Class[] paramTypes = new Class[]{String.class};
            Constructor constructor = peerClass.getConstructor(paramTypes);
            Object[] initArgs = new String[]{fileSystemName};
            this.peer = (FileSystemPeer)constructor.newInstance(initArgs);
            this.children = new OrderedCollection();
            this._setNodeText(fileSystemName);
            this._setNodeExpandedText(fileSystemName);
            this._setNodeType();
            this.need_refresh = true;
        }
        catch (Exception e) {
            System.out.println("Unable to create FileSystem");
            System.exit(1);
        }
    }

    public boolean canRead() {
        return this.peer == null ? false : this.peer.canRead();
    }

    public boolean canWrite() {
        return this.peer == null ? false : this.peer.canWrite();
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int numCount) {
        this.initializeChildren();
        int cnt = this.children.count();
        if (this.children != null && cnt > 0) {
            SimpleNodeInterface[] sni = new SimpleNodeInterface[numCount];
            int index = startIndex;
            int i = 0;
            while (index < cnt && index < numCount) {
                sni[i++] = (SimpleNodeInterface)this.children.get(index++);
            }
            return sni;
        }
        return null;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        this.initializeChildren();
        return this.children.count() == 0 ? null : (NodeInterface)this.children.get(index);
    }

    public int getNodeChildCount() {
        this.initializeChildren();
        return this.children.count() == 0 ? 0 : this.children.count();
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public String getDriveType() {
        return this.getDeviceType();
    }

    public String getDeviceType() {
        return this.peer == null ? null : this.peer.getDeviceType();
    }

    public String getNodeExpandedText() {
        return this.nodeExpandedText;
    }

    public String getFileSystemName() {
        return this.nodeText;
    }

    public String getFileSystemType() {
        return this.peer == null ? null : this.peer.getFileSystemType();
    }

    public String getNodeType() {
        return this.peer == null ? null : this.peer.getNodeType();
    }

    public File getRootDirectory() {
        return this.peer == null ? null : this.peer.getRootDirectory();
    }

    public String getNodeText() {
        return this.peer == null ? null : this.peer.getNodeText();
    }

    public static void setErrorMode() {
        WindowsFileSystemPeer.setErrorMode();
    }

    public boolean isLeafNode() {
        this.initializeChildren();
        return this.children.count() == 0;
    }

    private synchronized void initializeChildren() {
        if (this.peer != null && this.need_refresh) {
            this.children = this.peer.getChildren();
            this.need_refresh = false;
        }
    }

    public boolean isValid() {
        return this.peer == null ? false : this.peer.isValid();
    }

    public synchronized void _setNodeExpandedText(String expandedText) {
        this.nodeExpandedText = expandedText;
    }

    public synchronized void _setNodeType() {
        if (this.peer != null) {
            this.nodeType = this.peer.getNodeType();
        }
    }

    public synchronized void _setNodeText(String driveName) {
        this.nodeText = driveName;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            if (this.peer != null) {
                this.commonInit(this.peer.getNodeText());
            }
        }
        catch (Exception e) {
            this.peer = null;
        }
        stream.defaultReadObject();
    }

    public IconInterface getDefaultIcon() {
        return new ImageView(Resources.getImage((String)"Drive"));
    }

    public IconInterface getExpandedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getSelectedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getExpandedSelectedIcon() {
        return this.getDefaultIcon();
    }
}

