/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedListenerList;
import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.io.FileComponent;
import com.sas.io.FileSystem;
import com.sas.io.FileSystemPeer;
import com.sas.io.RB;
import com.sas.models.NodeIconInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.util.ApplyInterface;
import com.sas.util.Comparator;
import com.sas.visuals.IconInterface;
import com.sas.visuals.ImageView;
import com.sas.visuals.Resources;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class File
extends FileComponent
implements StaticOrderedCollectionInterface,
NodeIconInterface {
    static final long serialVersionUID = -2032478753213074760L;
    protected OrderedCollection children;
    private boolean leafNode;
    protected String nodeText;
    protected String nodeType;
    protected String nodeExpandedText;
    protected transient boolean need_refresh;
    protected static IconInterface FOLDER_ICON;
    protected static IconInterface FILE_ICON;
    protected static IconInterface DRIVE_ICON;
    protected static IconInterface FOLDER_OPEN_ICON;
    public static final String RB_KEY = "File.";
    private transient ContentsChangedListenerList allContentsChangedListeners;
    private int r = 0;
    private int f = 0;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "children"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)"children.pd.txt")}}, {{"Name", "text"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "nodeExpandedText"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"nodeExpandedText.pd.txt")}}, {{"Name", "nodeType"}, {"Hidden", "true"}, {"Description", RB.getStringResource((String)"nodeType.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public File() {
        this.need_refresh = true;
        this.children = new OrderedCollection();
    }

    public File(File directory, String name) {
        super(directory, name);
        this.init();
    }

    public File(FileSystem fs, File dir, String name) {
        super(fs.getRootDirectory().getName().concat(dir.getName()), name);
        this.init();
    }

    public File(String path) {
        super(path);
        this.init();
    }

    public File(String path, String file) {
        super(path, file);
        this.init();
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.init();
    }

    private void init() {
        this.children = new OrderedCollection();
        this._setNodeText();
        this._setNodeExpandedText();
        this._setNodeType();
        this._setLeafNode();
        this.need_refresh = true;
    }

    public static boolean delete(String path, String flag) {
        File d = new File(path);
        return d.delete(flag);
    }

    public void addContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners == null) {
            this.allContentsChangedListeners = new ContentsChangedListenerList();
        }
        this.allContentsChangedListeners.add(listener);
    }

    public void removeContentsChangedListener(ContentsChangedListener listener) {
        if (this.allContentsChangedListeners != null) {
            this.allContentsChangedListeners.remove(listener);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        File newData = (File)super.clone();
        newData.allContentsChangedListeners = null;
        return newData;
    }

    public void fireContentsChanged(ContentsChangedEvent event) {
        if (this.allContentsChangedListeners != null) {
            for (ContentsChangedListener listener : this.allContentsChangedListeners.getListeners()) {
                listener.contentsChanged(event);
            }
        }
    }

    public synchronized boolean copyTo(File dir) {
        if (this.isDirectory() && !dir.exists()) {
            dir.mkdirs();
        }
        if (this.isDirectory() && dir.isDirectory()) {
            return this.copyDirectory(dir);
        }
        if (this.isFile()) {
            return this.copyFile(dir);
        }
        return false;
    }

    private synchronized boolean copyDirectory(File directory) {
        if (!this.exists()) {
            return false;
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Enumeration enumer = this.getItems();
        while (enumer.hasMoreElements()) {
            File nf;
            File f = (File)enumer.nextElement();
            if (f.copyTo(nf = new File(directory.getPath() + separator + f.getName()))) continue;
            return false;
        }
        return true;
    }

    private synchronized boolean copyFile(File file) {
        try {
            FileInputStream fi = new FileInputStream(this);
            FileOutputStream fo = new FileOutputStream(file);
            int len = new Long(this.length()).intValue();
            byte[] b = new byte[len];
            fi.read(b, 0, len);
            fo.write(b, 0, len);
            fi.close();
            fo.close();
        }
        catch (IOException ie) {
            return false;
        }
        return true;
    }

    public boolean copyTo(String path) {
        return this.copyTo(new File(path));
    }

    public synchronized int count() {
        String[] a = this.list();
        return a != null ? a.length : -1;
    }

    public synchronized boolean delete(String flag) {
        int deleteFlag = 0;
        StringTokenizer st = new StringTokenizer(flag, ",; ");
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (s.equalsIgnoreCase("r")) {
                deleteFlag |= 1;
                continue;
            }
            if (!s.equalsIgnoreCase("f")) continue;
            deleteFlag |= 2;
        }
        if (deleteFlag == 3) {
            return this.rfDelete(deleteFlag);
        }
        if (deleteFlag == 1) {
            return this.recursiveDelete(deleteFlag);
        }
        if (deleteFlag == 2) {
            return this.forceDelete(deleteFlag);
        }
        return false;
    }

    private boolean recursiveDelete(int deleteFlag) {
        boolean rc = true;
        if (this.isDirectory() && this.exists()) {
            String[] files = this.list();
            if (files == null) {
                return false;
            }
            for (int i = 0; i < files.length; ++i) {
                File f = new File(this.getPath(), files[i]);
                rc = deleteFlag == 2 ? f.forceDelete(deleteFlag) : f.recursiveDelete(deleteFlag);
                if (rc) continue;
                return rc;
            }
            return this.delete();
        }
        return this.delete();
    }

    public boolean chmod(int flag) {
        FileSystemPeer fsp = FileSystem.getFileSystem();
        return fsp.chmod(this, flag);
    }

    private boolean forceDelete(int deleteFlag) {
        if (!this.delete()) {
            boolean read = this.canRead();
            boolean write = this.canWrite();
            boolean rc = false;
            if (!read || !write) {
                this.chmod(3);
            }
            if (!(rc = deleteFlag == 1 ? this.recursiveDelete(deleteFlag) : this.delete())) {
                if (!read && this.canRead()) {
                    this.chmod(1);
                }
                if (!write && this.canWrite()) {
                    this.chmod(2);
                }
                return false;
            }
            return rc;
        }
        return true;
    }

    private boolean rfDelete(int deleteFlag) {
        if (this.isFile() && this.exists()) {
            return this.forceDelete(deleteFlag);
        }
        if (this.isDirectory() && this.exists()) {
            String[] files = this.list();
            if (files == null) {
                return false;
            }
            for (int i = 0; i < files.length; ++i) {
                File f = new File(this.getPath(), files[i]);
                f.rfDelete(deleteFlag);
            }
        }
        return this.forceDelete(deleteFlag);
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        this.initializeChildren();
        int cnt = this.getNodeChildCount();
        if (count > 0) {
            SimpleNodeInterface[] sni = new SimpleNodeInterface[count];
            int index = startIndex;
            int i = 0;
            while (index < cnt && i < count) {
                sni[i++] = (SimpleNodeInterface)this.children.get(index++);
            }
            return sni;
        }
        return null;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        this.initializeChildren();
        return this.getNodeChildren(index, 1)[0];
    }

    public int getNodeChildCount() {
        this.initializeChildren();
        return this.children.count();
    }

    public int countNodeChildren(int maximumChildCount) {
        this.initializeChildren();
        return this.children.count();
    }

    public String getNodeExpandedText() {
        return this.nodeExpandedText;
    }

    public boolean isLeafNode() {
        return this.leafNode;
    }

    public String getNodeText() {
        return this.nodeText;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public synchronized Enumeration getItems() {
        if (this.isDesignTime()) {
            return this.children.getItems();
        }
        this.initializeChildren();
        return this.children.getItems();
    }

    protected void initializeChildren() {
        if (this.need_refresh) {
            File t = this;
            if (!this.getPath().endsWith(separator)) {
                t = new File(this.getPath() + separator);
            }
            this.children.removeAll();
            String[] a = t.list();
            if (a != null) {
                for (int i = 0; i < a.length; ++i) {
                    this.children.add((Object)new File(this.getPath(), a[i]));
                }
            }
            this.need_refresh = false;
        }
    }

    public File getParentDir() {
        String name = this.getParent();
        return name == null ? null : new File(name);
    }

    public synchronized boolean mkdir(String subdirectoryName) throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException();
        }
        File d = new File(this.getPath() + separator + subdirectoryName);
        return d.mkdir();
    }

    public synchronized boolean mkdirs(String subdirectoryPath) throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException();
        }
        File d = new File(this.getPath() + separator + subdirectoryPath);
        return d.mkdirs();
    }

    public synchronized boolean moveTo(java.io.File parentdir) {
        boolean rc;
        String t;
        if (!parentdir.exists()) {
            return false;
        }
        String s = this.getName();
        if (s.endsWith(separator)) {
            s = s.substring(0, s.length() - 1);
        }
        if (!(t = parentdir.getPath()).endsWith(separator)) {
            t = t + separator;
        }
        if (rc = this.copyTo(t + s)) {
            File.delete(this.getPath(), "r");
        }
        return rc;
    }

    public boolean moveTo(String parentpath) {
        return this.moveTo(new File(parentpath));
    }

    public synchronized boolean renameTo(String newName) {
        return this.renameTo(new File(newName));
    }

    private synchronized void _setNodeExpandedText() {
        this.nodeExpandedText = this.getPath();
    }

    private synchronized void _setLeafNode() {
        this.leafNode = this.count() <= 0;
    }

    protected synchronized void _setNodeType() {
        this.nodeType = this.isDirectory() ? "Directory" : (this.isFile() ? "File" : "Drive");
    }

    private synchronized void _setNodeText() {
        String p = this.getPath();
        this.nodeText = p.endsWith(separator) ? p : this.getName();
    }

    protected synchronized void setNodeText(String name) {
        this.nodeText = name;
    }

    public synchronized void setHasChildren(boolean hasChildren) {
        this.supressChildren(hasChildren);
    }

    public synchronized void supressChildren(boolean hasChildren) {
        this.leafNode = !hasChildren;
    }

    public boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        this.initializeChildren();
        return this.children.equals(orderedCollection);
    }

    public Object get(int index) {
        this.initializeChildren();
        return this.children.get(index);
    }

    public int getIndex(Object element, int startIndex) {
        this.initializeChildren();
        return this.children.getIndex(element, startIndex);
    }

    public Enumeration getItems(int start, int end) {
        this.initializeChildren();
        return this.children.getItems(start, end);
    }

    public int getLastIndex(Object element, int startIndex) {
        this.initializeChildren();
        return this.children.getLastIndex(element, startIndex);
    }

    public boolean contains(Object element) {
        this.initializeChildren();
        return this.children.contains(element);
    }

    public void apply(ApplyInterface action) {
        this.initializeChildren();
        this.children.apply(action);
    }

    public void sort(Comparator comparator, int start, int end) {
        this.initializeChildren();
        this.children.sort(comparator, start, end);
    }

    public void sort(Comparator comparator) {
        this.initializeChildren();
        this.children.sort(comparator);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.init();
    }

    public IconInterface getDefaultIcon() {
        if (this.isDirectory()) {
            if (FOLDER_ICON == null) {
                FOLDER_ICON = new ImageView(Resources.getImage((String)"Folder"));
            }
            return FOLDER_ICON;
        }
        if (this.isFile()) {
            if (FILE_ICON == null) {
                FILE_ICON = new ImageView(Resources.getImage((String)"Chapter"));
            }
            return FILE_ICON;
        }
        if (DRIVE_ICON == null) {
            DRIVE_ICON = new ImageView(Resources.getImage((String)"Drive"));
        }
        return DRIVE_ICON;
    }

    public IconInterface getExpandedIcon() {
        if (this.isDirectory()) {
            if (FOLDER_OPEN_ICON == null) {
                FOLDER_OPEN_ICON = new ImageView(Resources.getImage((String)"FolderOpen"));
            }
            return FOLDER_OPEN_ICON;
        }
        return this.getDefaultIcon();
    }

    public IconInterface getSelectedIcon() {
        return this.getDefaultIcon();
    }

    public IconInterface getExpandedSelectedIcon() {
        return null;
    }
}

