/*
 * Decompiled with CFR 0.152.
 */
package com.sas.idesupport;

import com.sas.GlobalInfoTable;
import com.sas.text.Message;
import com.sas.util.validators.Validator;

public class ClassNameValidator
extends Validator {
    protected static final String invalidClass = "ClassNameValidator.invalidClass";
    protected static final String onlyString = "ClassNameValidator.onlyString";
    protected static final int INVALID_CLASS = 0;
    protected static final int ONLY_STRING = 1;

    public boolean validateValue(Object component, Object value) {
        if (value instanceof String) {
            String valueString = (String)value;
            if ((valueString = valueString.trim()).equals("")) {
                return true;
            }
            try {
                Class cls = GlobalInfoTable.loadClass((String)((String)value));
                return true;
            }
            catch (ClassNotFoundException e) {
                this.setValidationMessage((Message)this.messages.get(0));
                this.setValidationMessageCode(invalidClass);
            }
        } else {
            this.setValidationMessage((Message)this.messages.get(1));
            this.setValidationMessageCode(onlyString);
        }
        return false;
    }

    public void createValidationMessages() {
        this.messages.add(this.newValidationMessage("Invalid Java class or package name"));
        this.messages.add(this.newValidationMessage("ClassNameValidator can only validate Strings"));
    }
}

