/*
 * Decompiled with CFR 0.152.
 */
package com.sas.idesupport;

import com.sas.idesupport.PainterInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class BackgroundPainter
extends JLabel
implements ComponentListener {
    Icon image;
    String imageName;
    private Component owner;
    PainterInterface painter;

    public BackgroundPainter() {
        this.setImage(null);
        this.imageName = "";
        this.painter = null;
        this.setOwner(null);
    }

    void setImage(Icon image) {
        this.image = image;
    }

    public Icon getImage() {
        return this.image;
    }

    public void setOwner(Component own) {
        if (this.owner != null) {
            this.owner.removeComponentListener(this);
        }
        this.owner = own;
        if (this.owner != null) {
            this.owner.addComponentListener(this);
        }
    }

    public Component getOwner() {
        return this.owner;
    }

    public PainterInterface getPainter() {
        return this.painter;
    }

    public void setPainter(PainterInterface p) {
        this.painter = p;
    }

    public void setImageName(String name) {
        if (name != null && name.length() > 0) {
            this.imageName = name;
            try {
                this.setImage(new ImageIcon(this.getOwner().getClass().getResource(this.imageName)));
            }
            catch (Exception e) {
                this.setImage(new ImageIcon(this.imageName));
            }
        } else {
            this.setImage(null);
            this.imageName = "";
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void paintComponent(Graphics g) {
        PainterInterface p = this.getPainter();
        if (p != null) {
            p.paintComponent(this.getImage(), this.getOwner(), g, this.getOwner().getWidth(), this.getOwner().getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setSize(e.getComponent().getSize());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

