/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AWedge3D;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Wedge3D
extends AWedge3D {
    public static void drawWedge(Channel channel, double angle, double startAngle, double height, double innerRadius, double outerRadius, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int precision) {
        Vec3d cross;
        int count;
        if ((innerRadius = Math.abs(innerRadius)) > (outerRadius = Math.abs(outerRadius))) {
            double temp = innerRadius;
            innerRadius = outerRadius;
            outerRadius = temp;
        }
        double incrementAngle = Math.PI * 2 / (double)precision;
        int numValues = 3;
        if (Math.abs(angle) > incrementAngle) {
            numValues = (int)Math.round(Math.abs(angle) / incrementAngle) + 2;
        }
        incrementAngle = angle > 0.0 ? incrementAngle : -incrementAngle;
        double[] xor = new double[numValues];
        double[] zor = new double[numValues];
        double[] zir = new double[numValues];
        double[] xir = new double[numValues];
        xor[0] = 0.0;
        double yOrigin = 0.0;
        zor[0] = 0.0;
        double angleSum = startAngle;
        for (count = 1; count <= numValues - 2; ++count) {
            xor[count] = xor[0] + Math.cos(angleSum) * outerRadius;
            zor[count] = zor[0] - Math.sin(angleSum) * outerRadius;
            angleSum += incrementAngle;
        }
        xor[count] = xor[0] + Math.cos(startAngle + angle) * outerRadius;
        zor[count] = zor[0] - Math.sin(startAngle + angle) * outerRadius;
        xir[0] = 0.0;
        zir[0] = 0.0;
        angleSum = startAngle;
        for (count = 1; count <= numValues - 2; ++count) {
            xir[count] = xir[0] + Math.cos(angleSum) * innerRadius;
            zir[count] = zir[0] - Math.sin(angleSum) * innerRadius;
            angleSum += incrementAngle;
        }
        xir[count] = xir[0] + Math.cos(startAngle + angle) * innerRadius;
        zir[count] = zir[0] - Math.sin(startAngle + angle) * innerRadius;
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getJXDFillStyle(fillOn, edgeOn));
        yOrigin = height < 0.0 ? height : 0.0;
        height = Math.abs(height);
        Vec3d v = new Vec3d(0.0, height, 0.0);
        Vec3d w = new Vec3d(0.0, 0.0, 0.0);
        Vec3d ov = new Vec3d(v);
        if (edgeOn) {
            if (fillOn) {
                channel.glPolygonMode(3);
            } else {
                channel.glPolygonMode(5);
            }
        }
        for (count = 1; count <= numValues - 2; ++count) {
            channel.glBegin(2);
            v.set(ov);
            w.set(xor[count] - xor[count + 1], 0.0, zor[count] - zor[count + 1]);
            cross = v.cross(w);
            if (incrementAngle < 0.0) {
                cross.scale(-1.0);
            }
            channel.glNormal(cross.x, cross.y, cross.z);
            channel.glVertex(xor[count], yOrigin, zor[count]);
            channel.glVertex(xor[count + 1], yOrigin, zor[count + 1]);
            channel.glVertex(xor[count + 1], yOrigin + height, zor[count + 1]);
            channel.glVertex(xor[count], yOrigin + height, zor[count]);
            channel.glEnd();
        }
        if (innerRadius > 0.0) {
            for (count = 1; count <= numValues - 2; ++count) {
                channel.glBegin(2);
                v.set(ov);
                w.set(xir[count + 1] - xir[count], 0.0, zir[count + 1] - zir[count]);
                cross = v.cross(w);
                if (incrementAngle < 0.0) {
                    cross.scale(-1.0);
                }
                channel.glNormal(cross.x, cross.y, cross.z);
                channel.glVertex(xir[count], yOrigin, zir[count]);
                channel.glVertex(xir[count + 1], yOrigin, zir[count + 1]);
                channel.glVertex(xir[count + 1], yOrigin + height, zir[count + 1]);
                channel.glVertex(xir[count], yOrigin + height, zir[count]);
                channel.glEnd();
            }
        }
        if (edgeOn) {
            if (fillOn) {
                channel.glPolygonMode(4);
            } else {
                channel.glPolygonMode(2);
            }
        }
        channel.glBegin(2);
        channel.glNormal(0.0, 1.0, 0.0);
        if (innerRadius > 0.0) {
            for (count = numValues - 1; count >= 1; --count) {
                channel.glVertex(xir[count], yOrigin + height, zir[count]);
            }
        } else {
            channel.glVertex(xor[0], yOrigin + height, zor[0]);
        }
        for (count = 1; count < numValues; ++count) {
            channel.glVertex(xor[count], yOrigin + height, zor[count]);
        }
        channel.glEnd();
        channel.glBegin(2);
        channel.glNormal(0.0, -1.0, 0.0);
        if (innerRadius > 0.0) {
            for (count = 1; count < numValues; ++count) {
                channel.glVertex(xir[count], yOrigin, zir[count]);
            }
        } else {
            channel.glVertex(xor[0], yOrigin, zor[0]);
        }
        for (count = numValues - 1; count >= 1; --count) {
            channel.glVertex(xor[count], yOrigin, zor[count]);
        }
        channel.glEnd();
        channel.glBegin(2);
        v.set(ov);
        w.set(xor[1] - xor[0], 0.0, zor[1] - zor[0]);
        cross = w.cross(v);
        if (incrementAngle < 0.0) {
            cross.scale(-1.0);
        }
        channel.glNormal(cross.x, cross.y, cross.z);
        channel.glVertex(xor[1], yOrigin + height, zor[1]);
        channel.glVertex(xor[1], yOrigin, zor[1]);
        if (innerRadius > 0.0) {
            channel.glVertex(xir[1], yOrigin, zir[1]);
            channel.glVertex(xir[1], yOrigin + height, zir[1]);
        } else {
            channel.glVertex(xor[0], yOrigin, zor[0]);
            channel.glVertex(xor[0], yOrigin + height, zor[0]);
        }
        channel.glEnd();
        channel.glBegin(2);
        v.set(ov);
        w.set(xor[numValues - 1] - xor[0], 0.0, zor[numValues - 1] - zor[0]);
        cross = v.cross(w);
        if (incrementAngle < 0.0) {
            cross.scale(-1.0);
        }
        channel.glNormal(cross.x, cross.y, cross.z);
        channel.glVertex(xor[numValues - 1], yOrigin + height, zor[numValues - 1]);
        channel.glVertex(xor[numValues - 1], yOrigin, zor[numValues - 1]);
        if (innerRadius > 0.0) {
            channel.glVertex(xir[numValues - 1], yOrigin, zir[numValues - 1]);
            channel.glVertex(xir[numValues - 1], yOrigin + height, zir[numValues - 1]);
        } else {
            channel.glVertex(xor[0], yOrigin, zor[0]);
            channel.glVertex(xor[0], yOrigin + height, zor[0]);
        }
        channel.glEnd();
        channel.glPopAttrib();
    }

    public Wedge3D() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Wedge3D.drawWedge(ba.getChannel(), this.angle.getValue(index), this.startAngle.getValue(index), this.height.getValue(index), this.innerRadius.getValue(index), this.outerRadius.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.precision.getValue(index));
    }
}

