/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AWedge;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Wedge
extends AWedge {
    public static void drawWedge(Channel channel, double angle, double startAngle, double innerRadius, double outerRadius, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int precision) {
        double y;
        double x;
        int i;
        double a;
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getJXDFillStyle(fillOn, edgeOn));
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        double increment = Math.PI * 2 / (double)precision;
        int segments = 1;
        if (Math.abs(angle) > increment) {
            segments = (int)Math.round(Math.abs(angle) / increment);
        }
        increment = angle > 0.0 ? increment : -increment;
        double stopX = Math.cos(startAngle) * innerRadius;
        double stopY = Math.sin(startAngle) * innerRadius;
        if (innerRadius > 0.0) {
            a = startAngle + angle;
            for (i = segments; i > 0; --i) {
                x = Math.cos(a) * innerRadius;
                y = Math.sin(a) * innerRadius;
                channel.glVertex((float)x, (float)y);
                a -= increment;
            }
            if (angle == Math.PI * 2) {
                channel.glEdgeFlag(false);
            }
            channel.glVertex((float)stopX, (float)stopY);
            if (angle == Math.PI * 2) {
                channel.glEdgeFlag(true);
            }
        } else if (angle < Math.PI * 2) {
            channel.glVertex(0.0, 0.0);
        }
        a = startAngle;
        for (i = 0; i < segments; ++i) {
            x = Math.cos(a) * outerRadius;
            y = Math.sin(a) * outerRadius;
            channel.glVertex((float)x, (float)y);
            a += increment;
        }
        x = Math.cos(startAngle + angle) * outerRadius;
        y = Math.sin(startAngle + angle) * outerRadius;
        if (angle == Math.PI * 2) {
            channel.glEdgeFlag(false);
        }
        channel.glVertex((float)x, (float)y);
        if (angle == Math.PI * 2) {
            channel.glEdgeFlag(true);
        }
        if (innerRadius > 0.0 && angle == Math.PI * 2) {
            channel.glVertex((float)stopX, (float)stopY);
        }
        channel.glEnd();
        channel.glPopAttrib();
    }

    public Wedge() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Wedge.drawWedge(ba.getChannel(), this.angle.getValue(index), this.startAngle.getValue(index), this.innerRadius.getValue(index), this.outerRadius.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.precision.getValue(index));
    }
}

