/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATukeyBox;
import com.sas.graphics.util.vtk.MismatchedValueCountException;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.ComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.jxd.Transform;

public class TukeyBox
extends ATukeyBox {
    int nIndices;
    int nValues;

    public TukeyBox() {
        super(new Transform());
    }

    private int getFirst(int index) {
        int i;
        int j = -1;
        String value0 = "";
        String value1 = "";
        for (i = 0; i < this.nValues && j < index; ++i) {
            try {
                value1 = this.x.getValue(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!value0.equals(value1)) {
                ++j;
            }
            value0 = value1;
        }
        return i - 1;
    }

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        this.nIndices = ia.getValueCount();
        ia.pushValueCount();
        this.x.init(ia);
        this.y.init(ia);
        this.nValues = ia.getValueCount();
        ia.popValueCount();
        int j = 0;
        String value0 = "";
        String value1 = "";
        for (int i = 0; i < this.nValues; ++i) {
            try {
                value1 = this.x.getValue(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!value0.equals(value1)) {
                ++j;
            }
            value0 = value1;
        }
        if (j != this.nIndices) {
            throw new MismatchedValueCountException(j + " != " + this.nIndices);
        }
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction action = BuildAction.castBuildAction(buildAction);
        Channel channel = action.getChannel();
        int index = action.getValueIndex();
        int i = this.getFirst(index);
        double minX = 0.0;
        double maxX = this.boxWidth.getValue(index);
        double halfX = (maxX - minX) / 2.0;
        double minY = this.y.getValue(i);
        double q1 = this.y.getValue(++i);
        double median = this.y.getValue(++i);
        double q3 = this.y.getValue(++i);
        double maxY = this.y.getValue(++i);
        double mean = this.y.getValue(++i);
        double n = this.y.getValue(++i);
        ++i;
        channel.glColor(this.fillColor.getValue(index));
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        channel.glPolygonMode(3);
        channel.glVertex(minX, q1);
        channel.glVertex(minX, q3);
        channel.glVertex(maxX, q3);
        channel.glVertex(maxX, q1);
        channel.glEnd();
        channel.glColor(this.outlineColor.getValue(index));
        channel.glLineWidth((float)this.outlineWidth.getValue(index));
        channel.glBegin(1);
        channel.glVertex(minX, q1);
        channel.glVertex(minX, q3);
        channel.glVertex(maxX, q3);
        channel.glVertex(maxX, q1);
        channel.glVertex(minX, q1);
        channel.glEnd();
        channel.glColor(this.whiskerColor.getValue(index));
        channel.glLineWidth((float)this.whiskerWidth.getValue(index));
        channel.glBegin(1);
        channel.glVertex(halfX, q1);
        channel.glVertex(halfX, minY);
        channel.glEnd();
        channel.glBegin(1);
        channel.glVertex(halfX, q3);
        channel.glVertex(halfX, maxY);
        channel.glEnd();
        int cap = this.capShape.getValue(index);
        if (cap == 1 || cap == 2 || cap == 3) {
            double quarterX = (maxX - minX) / 4.0;
            if (cap == 1) {
                channel.glBegin(1);
                channel.glVertex(minX + quarterX, minY);
                channel.glVertex(maxX - quarterX, minY);
                channel.glEnd();
                channel.glBegin(1);
                channel.glVertex(minX + quarterX, maxY);
                channel.glVertex(maxX - quarterX, maxY);
                channel.glEnd();
            } else if (cap == 2) {
                channel.glBegin(1);
                channel.glVertex(minX, minY);
                channel.glVertex(maxX, minY);
                channel.glEnd();
                channel.glBegin(1);
                channel.glVertex(minX, maxY);
                channel.glVertex(maxX, maxY);
                channel.glEnd();
            } else if (cap == 3) {
                channel.glBegin(1);
                channel.glVertex(minX, minY + quarterX);
                channel.glVertex(minX, minY);
                channel.glVertex(maxX, minY);
                channel.glVertex(maxX, minY + quarterX);
                channel.glEnd();
                channel.glBegin(1);
                channel.glVertex(minX, maxY - quarterX);
                channel.glVertex(minX, maxY);
                channel.glVertex(maxX, maxY);
                channel.glVertex(maxX, maxY - quarterX);
                channel.glEnd();
            }
        }
        channel.glColor(this.medianColor.getValue(index));
        if (this.medianShape.getValue(index) >= 0) {
            channel.glEdgeColor(this.medianColor.getValue(index));
            channel.setMarkerSize((int)this.medianWidth.getValue(index));
            channel.setMarkerType(this.medianShape.getValue(index));
            channel.glBegin(4);
            channel.glVertex(halfX, median);
            channel.glEnd();
        } else {
            channel.glLineWidth((float)this.medianWidth.getValue(index));
            channel.glBegin(1);
            channel.glVertex(minX, median);
            channel.glVertex(maxX, median);
            channel.glEnd();
        }
        channel.glColor(this.meanColor.getValue(index));
        if (this.meanShape.getValue(index) >= 0) {
            channel.glEdgeColor(this.meanColor.getValue(index));
            channel.setMarkerSize((int)this.meanWidth.getValue(index));
            channel.setMarkerType(this.meanShape.getValue(index));
            channel.glBegin(4);
            channel.glVertex(halfX, mean);
            channel.glEnd();
        } else {
            channel.glLineWidth((float)this.meanWidth.getValue(index));
            channel.glBegin(1);
            channel.glVertex(minX, mean);
            channel.glVertex(maxX, mean);
            channel.glEnd();
        }
        channel.glColor(this.markerColor.getValue(index));
        channel.glEdgeColor(this.markerColor.getValue(index));
        channel.setMarkerSize((int)this.markerWidth.getValue(index));
        channel.setMarkerType(this.markerShape.getValue(index));
        channel.glBegin(4);
        int j = this.nValues;
        if (index + 1 < this.nIndices) {
            j = this.getFirst(index + 1);
        }
        while (i < j) {
            channel.glVertex(halfX, this.y.getValue(i));
            ++i;
        }
        channel.glEnd();
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        ComputeBoundingBoxAction bba = ComputeBoundingBoxAction.castComputeBoundingBoxAction(bBoxAction);
        int index = bba.getValueIndex();
        BoundingBox box = bba.getElementBoundingBox();
        int i = this.getFirst(index);
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        try {
            maxX = this.boxWidth.getValue(index);
            minY = this.y.getValue(i);
            maxY = this.y.getValue(i += 4);
            i += 3;
            int j = this.nValues;
            if (index + 1 < this.nIndices) {
                j = this.getFirst(index + 1);
            }
            while (i < j) {
                double outY = this.y.getValue(i);
                if (minY > outY) {
                    minY = outY;
                }
                if (maxY < outY) {
                    maxY = outY;
                }
                ++i;
            }
        }
        catch (MissingValueException j) {
            // empty catch block
        }
        Vec3d center = new Vec3d((maxX - minX) / 2.0, (maxY - minY) / 2.0, 0.0);
        Vec3d size = new Vec3d(maxX - minX, maxY - minY, 0.0);
        box.union(center, size);
    }
}

