/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.ASplineConnector;
import com.sas.graphics.util.vtk.Action;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.ComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.jxd.LineSegment;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class SplineConnector
extends ASplineConnector {
    protected Color myColor = ColorProperty.getDefaultColor();
    protected Color myFillColor = ColorProperty.getDefaultColor();
    protected boolean fill = false;
    protected float myLineWidth;

    public SplineConnector() {
        super(new Transform());
        this.controlPointX = new double[4];
        this.controlPointY = new double[4];
        this.controlPointZ = new double[4];
        this.observations = new int[4];
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        int index;
        Channel channel;
        BuildAction ba;
        block15: {
            ba = BuildAction.castBuildAction(buildAction);
            channel = ba.getChannel();
            index = ba.getValueIndex();
            try {
                this.controlPointX[this.cPtCount] = this.pointX.getValue(index);
                this.controlPointY[this.cPtCount] = this.pointY.getValue(index);
                this.controlPointZ[this.cPtCount] = this.pointZ.getValue(index);
                this.observations[this.cPtCount] = index;
            }
            catch (MissingValueException mve) {
                if (!this.skipMissing) break block15;
                this.controlPointX[this.cPtCount] = Double.POSITIVE_INFINITY;
                this.controlPointY[this.cPtCount] = Double.POSITIVE_INFINITY;
                this.controlPointZ[this.cPtCount] = Double.POSITIVE_INFINITY;
            }
        }
        switch (this.cPtCount) {
            case 1: {
                this.controlPointX[0] = this.controlPointX[1];
                this.controlPointY[0] = this.controlPointY[1];
                this.controlPointZ[0] = this.controlPointZ[1];
                ++this.cPtCount;
                break;
            }
            case 2: {
                ++this.cPtCount;
                break;
            }
            default: {
                channel.glPushAttrib(0);
                channel.lineCapStyle(1);
                try {
                    this.myLineWidth = (float)this.lineWidth.getValue(this.observations[1]);
                }
                catch (MissingValueException mve) {
                    // empty catch block
                }
                channel.glLineWidth(this.myLineWidth);
                try {
                    this.myColor = this.color.getValue(this.observations[1]);
                }
                catch (MissingValueException mve) {
                    // empty catch block
                }
                try {
                    this.myFillColor = this.fillColor.getValue(this.observations[1]);
                }
                catch (MissingValueException mve) {
                    // empty catch block
                }
                try {
                    this.fill = this.fillOn.getValue(this.observations[1]);
                }
                catch (MissingValueException mve) {
                    // empty catch block
                }
                BuildAction.popName(channel, this);
                BuildAction.pushName(channel, index - 1, this);
                this.drawSplineSegments(ba, this.fill);
                for (int i = 0; i < 3; ++i) {
                    this.controlPointX[i] = this.controlPointX[i + 1];
                    this.controlPointY[i] = this.controlPointY[i + 1];
                    this.controlPointZ[i] = this.controlPointZ[i + 1];
                    this.observations[i] = this.observations[i + 1];
                }
                channel.glPopAttrib();
            }
        }
    }

    @Override
    public void reset(AResetAction anAction) {
        super.reset(anAction);
        Action companion = anAction.getCompanionAction();
        if (companion instanceof BuildAction) {
            this.buildOne((BuildAction)companion);
        } else if (companion instanceof ComputeBoundingBoxAction) {
            this.computeBoundingBoxOne((ComputeBoundingBoxAction)companion);
        }
        this.cPtCount = 1;
    }

    private void drawSplineSegments(Action action, boolean filled) {
        if (!(Double.isInfinite(this.controlPointX[0]) || Double.isInfinite(this.controlPointX[1]) || Double.isInfinite(this.controlPointX[2]) || Double.isInfinite(this.controlPointX[3]))) {
            Channel channel = (Channel)action.getGraphicsContext();
            channel.glColor(this.myColor);
            for (int i = 0; i < this.precision; ++i) {
                this.endPointX = this.controlPointX[0] * this.cardinalBasis[i][0] + this.controlPointX[1] * this.cardinalBasis[i][1] + this.controlPointX[2] * this.cardinalBasis[i][2] + this.controlPointX[3] * this.cardinalBasis[i][3];
                this.endPointY = this.controlPointY[0] * this.cardinalBasis[i][0] + this.controlPointY[1] * this.cardinalBasis[i][1] + this.controlPointY[2] * this.cardinalBasis[i][2] + this.controlPointY[3] * this.cardinalBasis[i][3];
                this.endPointZ = this.controlPointZ[0] * this.cardinalBasis[i][0] + this.controlPointZ[1] * this.cardinalBasis[i][1] + this.controlPointZ[2] * this.cardinalBasis[i][2] + this.controlPointZ[3] * this.cardinalBasis[i][3];
                if (i > 0) {
                    if (filled) {
                        channel.glColor(this.myFillColor);
                        this.drawFillUnder(action);
                    }
                    LineSegment.drawLineSegment(channel, this.beginPointX, this.beginPointY, this.beginPointZ, this.endPointX, this.endPointY, this.endPointZ, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
                }
                this.beginPointX = this.endPointX;
                this.beginPointY = this.endPointY;
                this.beginPointZ = this.endPointZ;
            }
            this.endPointX = this.controlPointX[2];
            this.endPointY = this.controlPointY[2];
            this.endPointZ = this.controlPointZ[2];
            if (filled) {
                channel.glColor(this.myFillColor);
                this.drawFillUnder(action);
            }
            LineSegment.drawLineSegment(channel, this.beginPointX, this.beginPointY, this.beginPointZ, this.endPointX, this.endPointY, this.endPointZ, this.myColor, this.myLineWidth, this.stipplePattern, this.stippleFactor);
        }
    }

    @Override
    protected void drawTrapezoid(Action action, int drawMode, Vec3d normal, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        Channel channel = (Channel)action.getGraphicsContext();
        if (channel != null) {
            if (drawMode == 3) {
                channel.setExtrusionVector(this.depth.x, this.depth.y, this.depth.z);
            }
            channel.glBegin(drawMode);
            channel.glNormal(normal.x, normal.y, normal.z);
            channel.glVertex(v1.x, v1.y, v1.z);
            channel.glVertex(v2.x, v2.y, v2.z);
            channel.glVertex(v3.x, v3.y, v3.z);
            channel.glVertex(v4.x, v4.y, v4.z);
            channel.glVertex(v1.x, v1.y, v1.z);
            channel.glEnd();
        }
    }
}

