/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ALabel;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.ComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.jxd.InitAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;
import java.awt.Font;

public class RasterLabel
extends ALabel {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRasterLabel(Channel channel, String label, Color color, double angle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, Color bgColor) {
        try {
            double xLocation = 0.0;
            double yLocation = 0.0;
            boolean clipped = false;
            channel.glPushAttrib(0);
            channel.glSelect2DFont(font);
            if (fit || truncate) {
                if (maxWidth < 0.0 || maxHeight < 0.0) {
                    return;
                }
                double textWidth = channel.glGetTextWidth(label);
                double textHeight = channel.glGetTextHeight(label);
                double minTextHeight = 0.0;
                double scale = 1.0;
                if (fit) {
                    int newSize;
                    int size = font.getSize();
                    if (textWidth > maxWidth) {
                        scale = maxWidth / textWidth;
                        newSize = (int)Math.floor((double)size * scale);
                        if (newSize < size / 2) {
                            newSize = size / 2;
                        }
                        font = FontManager.getFont((String)font.getName(), (int)font.getStyle(), (int)newSize);
                        channel.glSelect2DFont(font);
                        textWidth = channel.glGetTextWidth(label);
                        textHeight = channel.glGetTextHeight(label);
                    }
                    if (textHeight > maxHeight) {
                        scale = maxHeight / textHeight;
                        newSize = (int)Math.floor((double)font.getSize() * scale);
                        font = FontManager.getFont((String)font.getName(), (int)font.getStyle(), (int)(newSize < size / 2 ? size / 2 : newSize));
                        channel.glSelect2DFont(font);
                        textWidth = channel.glGetTextWidth(label);
                        textHeight = channel.glGetTextHeight(label);
                    }
                }
                if (truncate) {
                    double xClipLocation = 0.0;
                    double yClipLocation = 0.0;
                    if (maxHeight > minTextHeight) {
                        double descent;
                        if (textWidth > maxWidth) {
                            switch (horizontalJustification) {
                                case 1: {
                                    xClipLocation = -maxWidth / 2.0;
                                    xLocation = (textWidth - maxWidth) / 2.0;
                                    break;
                                }
                                case 2: {
                                    xClipLocation = -maxWidth;
                                    xLocation = textWidth - maxWidth;
                                    break;
                                }
                                default: {
                                    xClipLocation = 0.0;
                                    xLocation = 0.0;
                                    break;
                                }
                            }
                        } else if (textHeight > maxHeight) {
                            xLocation = 0.0;
                            switch (horizontalJustification) {
                                case 1: {
                                    xClipLocation = -maxWidth / 2.0;
                                    break;
                                }
                                case 2: {
                                    xClipLocation = -maxWidth;
                                    break;
                                }
                                default: {
                                    xClipLocation = 0.0;
                                }
                            }
                        }
                        if (textHeight > maxHeight) {
                            switch (verticalJustification) {
                                case 1: {
                                    yClipLocation = maxHeight / 2.0;
                                    yLocation = (maxHeight - textHeight) / 2.0;
                                    break;
                                }
                                default: {
                                    descent = textHeight - channel.glGetTextAscent();
                                    yClipLocation = maxHeight - descent;
                                    yLocation = maxHeight - textHeight;
                                    break;
                                }
                                case 3: {
                                    yClipLocation = maxHeight;
                                    yLocation = maxHeight - textHeight;
                                    break;
                                }
                                case 0: {
                                    yClipLocation = 0.0;
                                    yLocation = 0.0;
                                    break;
                                }
                            }
                        } else if (textWidth > maxWidth) {
                            yLocation = 0.0;
                            switch (verticalJustification) {
                                case 1: {
                                    yClipLocation = maxHeight / 2.0;
                                    break;
                                }
                                default: {
                                    descent = textHeight - channel.glGetTextAscent();
                                    yClipLocation = maxHeight - descent;
                                    break;
                                }
                                case 3: {
                                    yClipLocation = maxHeight;
                                    break;
                                }
                                case 0: {
                                    yClipLocation = 0.0;
                                }
                            }
                        }
                        if (textHeight > maxHeight || textWidth > maxWidth) {
                            Bbox box = new Bbox((float)xClipLocation, (float)(yClipLocation - maxHeight), 0.0f, (float)(xClipLocation + maxWidth), (float)yClipLocation, 0.0f);
                            channel.setClipBounds(box);
                            clipped = true;
                        }
                    } else {
                        return;
                    }
                }
            }
            channel.glColor(color);
            channel.glAlignment(horizontalJustification, verticalJustification);
            Color rasterBackground = channel.getRasterBackgroundColor();
            channel.setRasterBackgroundColor(bgColor);
            channel.gl2DText(label, xLocation, yLocation, 0.0, RasterLabel.angleChoice(angle));
            channel.setRasterBackgroundColor(rasterBackground);
            if (clipped) {
                channel.setClipBounds(null);
            }
        }
        finally {
            channel.glPopAttrib();
        }
    }

    public RasterLabel() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Color background = this.backgroundColorOn.getValue(index) ? this.backgroundColor.getValue(index) : null;
        RasterLabel.drawRasterLabel(ba.getChannel(), this.string.getValue(index), this.color.getValue(index), this.angle.getValue(index), this.horizontalJustification.getValue(index), this.verticalJustification.getValue(index), this.fit.getValue(index), this.truncate.getValue(index), this.maxWidth.getValue(index), this.maxHeight.getValue(index), FontManager.getFont((String)this.fontName.getValue(index), (int)this.fontStyle.getValue(index), (int)this.fontSize.getValue(index)), background);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        ComputeBoundingBoxAction bba = ComputeBoundingBoxAction.castComputeBoundingBoxAction(bBoxAction);
        int index = bba.getValueIndex();
        Font font = FontManager.getFont((String)this.fontName.getValue(index), (int)this.fontStyle.getValue(index), (int)this.fontSize.getValue(index));
        int horizontalJustification = this.horizontalJustification.getValue(index);
        int verticalJustification = this.verticalJustification.getValue(index);
        RasterLabel.computeBoundingBox(bba.getElementBoundingBox(), bba.getChannel(), this.string.getValue(index), this.angle.getValue(index), horizontalJustification, verticalJustification, this.fit.getValue(index), this.truncate.getValue(index), this.maxWidth.getValue(index), this.maxHeight.getValue(index), font);
    }

    public static void computeBoundingBox(BoundingBox box, Channel channel, String label, double textAngle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font) {
        Vec3d center = new Vec3d();
        center.z = 0.0;
        Vec3d size = new Vec3d();
        channel.glSelect2DFont(font);
        channel.glAlignment(horizontalJustification, verticalJustification);
        Bbox b = new Bbox();
        channel.glGetText2DBbox(label, 0.0, 0.0, 0.0, RasterLabel.angleChoice(textAngle), b);
        size.set(Math.abs(b.xmax - b.xmin), Math.abs(b.ymax - b.ymin), Math.abs(b.zmax - b.zmin));
        center.set(b.xmin + size.x / 2.0, b.ymin + size.y / 2.0, b.zmin + size.z / 2.0);
        box.union(center, size);
    }

    public static double getMaxLength(Channel channel, Font font, StringPipe pipe) {
        InitAction initAction = new InitAction(channel);
        pipe.init(initAction);
        int n = initAction.getValueCount();
        return RasterLabel.getMaxLength(channel, font, pipe, n);
    }

    public static double getMaxLength(Channel channel, Font font, StringPipe string, int valueCount) {
        double maxLength = Double.NEGATIVE_INFINITY;
        channel.glSelect2DFont(font);
        for (int i = 0; i < valueCount; ++i) {
            try {
                maxLength = Math.max(channel.glGetTextWidth(string.getValue(i)), maxLength);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return maxLength;
    }

    public static String wordBreak(Channel channel, Font font, String aLabel, double aspectRatio) {
        String newString = aLabel.replace(' ', '\n');
        return newString;
    }

    private static int angleChoice(double angle) {
        switch ((int)angle) {
            default: {
                return 0;
            }
            case 90: {
                return 90;
            }
            case -90: {
                return 270;
            }
            case 270: 
        }
        return 270;
    }
}

