/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ANetworkRoot;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.SelectEntry;
import com.sas.graphics.util.vtk.jxd.Box;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Composite;
import com.sas.graphics.util.vtk.jxd.ComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.jxd.InitAction;
import com.sas.graphics.util.vtk.jxd.SelectResult;
import com.sas.graphics.util.vtk.jxd.SelectableShape;
import java.awt.Color;
import java.awt.Polygon;
import java.util.Stack;
import java.util.Vector;

public class NetworkRoot
extends ANetworkRoot {
    private Channel channel;
    private long rootListName;
    private long bboxListName;
    private Stack nameStack = new Stack();
    private InitAction initAction;
    private BuildAction buildAction;
    private ComputeBoundingBoxAction bboxAction;
    private boolean showBoundingBox = false;
    private Vector selectResultVector = new Vector();
    private NameStackIterator nameStackIterator = new NameStackIterator();

    public NetworkRoot() {
    }

    public NetworkRoot(Channel aChannel) {
        this.channel = aChannel;
        this.rootListName = this.channel.glGenLists(1L);
        this.bboxListName = this.channel.glGenLists(1L);
        this.initAction = new InitAction(this.channel);
        this.buildAction = new BuildAction(this.channel);
        this.bboxAction = new ComputeBoundingBoxAction(this.channel);
        this.buildAction.setDisplayListName(this.rootListName);
    }

    public long getRootListName() {
        return this.rootListName;
    }

    public void setRootListName(long rootListName) {
        this.rootListName = rootListName;
    }

    public boolean getBoundingBoxVisible() {
        return this.showBoundingBox;
    }

    public void setBoundingBoxVisible(boolean trueOrFalse) {
        this.showBoundingBox = trueOrFalse;
    }

    @Override
    public void build() {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.build(): No associated channel.");
            return;
        }
        this.build(this.channel, this.rootListName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void build(Channel ch, long listName, Element anElement) {
        InitAction ia = new InitAction(ch);
        BuildAction ba = new BuildAction(ch);
        ba.setDisplayListName(listName);
        ia.apply(anElement);
        try {
            ch.glNewList(listName);
            ba.apply(anElement);
        }
        finally {
            ch.glEndList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void build(Channel ch, long listName) {
        Element e;
        int i;
        BuildAction ba;
        InitAction ia;
        if (this.channel == null) {
            ia = new InitAction(ch);
            ba = new BuildAction(ch);
            ba.setDisplayListName(listName);
        } else {
            ia = this.initAction;
            ba = this.buildAction;
        }
        int n = this.getElementCount();
        for (i = 0; i < n; ++i) {
            e = this.getElement(i);
            ia.apply(e);
        }
        if (this.showBoundingBox) {
            this.addBoundingBox();
        }
        ch.glNewList(listName);
        try {
            for (i = 0; i < n; ++i) {
                e = this.getElement(i);
                ba.apply(e);
            }
            if (this.showBoundingBox) {
                ch.glCallList(this.bboxListName);
            }
        }
        finally {
            ch.glEndList();
        }
    }

    public Vector computeSelectableShapes() {
        Vector feedback = new Vector();
        this.channel.glFeedbackBuffer(3, feedback);
        this.channel.glRenderMode(2);
        this.draw();
        this.channel.glRenderMode(0);
        Vector selectableShapes = new Vector();
        NetworkRoot.addFeedbackToSelectableShape(feedback, selectableShapes);
        return selectableShapes;
    }

    public static void addFeedbackToSelectableShape(Vector feedback, Vector selectableShapes) {
        NameStackIterator nameStackIterator = new NameStackIterator();
        int n = feedback.size();
        for (int i = 0; i < n; i += 2) {
            Stack nameStack = (Stack)feedback.elementAt(i);
            Polygon polygon = (Polygon)feedback.elementAt(i + 1);
            nameStackIterator.setNameStack(nameStack);
            SelectResult sr = nameStackIterator.next();
            if (sr == null) continue;
            selectableShapes.addElement(new SelectableShape(sr, polygon));
        }
    }

    public void draw() {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.draw(): No associated channel.");
            return;
        }
        this.draw(this.channel);
    }

    public synchronized void draw(Channel ch) {
        BuildAction ba;
        InitAction ia;
        if (this.channel == null) {
            ia = new InitAction(ch);
            ba = new BuildAction(ch);
        } else {
            ia = this.initAction;
            ba = this.buildAction;
        }
        int n = this.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element e = this.getElement(i);
            ia.apply(e);
            ba.apply(e);
        }
    }

    private void addBoundingBox() {
        BoundingBox bb = this.computeBoundingBox(this.channel);
        Vec3d center = bb.getCenter();
        Vec3d size = bb.getSize();
        this.channel.glNewList(this.bboxListName);
        this.channel.glTranslate(center.x, center.y, center.z);
        Box.drawBox(this.channel, size.x, size.y, size.z, Color.orange, Color.orange, 0, true, false);
        this.channel.glTranslate(-center.x, -center.y, -center.z);
        this.channel.glEndList();
    }

    @Override
    public BoundingBox computeBoundingBox() {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.computeBoundingBox(): No associated channel.");
            return null;
        }
        return this.computeBoundingBox(this.channel);
    }

    public BoundingBox computeBoundingBox(Channel ch) {
        ComputeBoundingBoxAction bba;
        InitAction ia;
        if (this.channel == null) {
            ia = new InitAction(ch);
            bba = new ComputeBoundingBoxAction(ch);
        } else {
            ia = this.initAction;
            bba = this.bboxAction;
        }
        BoundingBox box = bba.getElementBoundingBox();
        box.makeEmpty();
        box = bba.getNetworkBoundingBox();
        box.makeEmpty();
        int n = this.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element e = this.getElement(i);
            ia.apply(e);
            bba.apply(e);
        }
        return bba.getNetworkBoundingBox();
    }

    public synchronized void refresh() {
        this.channel.clearBGC();
        this.channel.glCallList(this.rootListName);
        this.channel.glRefresh();
    }

    public synchronized SelectResult selectClosest(int x, int y, int apertureWidth, int apertureHeight) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.select(): No associated channel.");
            return null;
        }
        return this.doSelectClosest(x, y, apertureWidth, apertureHeight, this.channel, -1L, false, true);
    }

    public synchronized SelectResult selectClosest(int x, int y, int apertureWidth, int apertureHeight, boolean doTransformations) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.select(): No associated channel.");
            return null;
        }
        return this.doSelectClosest(x, y, apertureWidth, apertureHeight, this.channel, this.rootListName, doTransformations, false);
    }

    public synchronized SelectResult selectClosest(int x, int y, int apertureWidth, int apertureHeight, Channel ch, long listName, boolean doTransformations) {
        return this.doSelectClosest(x, y, apertureWidth, apertureHeight, ch, listName, doTransformations, false);
    }

    private SelectResult doSelectClosest(int x, int y, int apertureWidth, int apertureHeight, Channel ch, long listName, boolean doTransformations, boolean immediateMode) {
        SelectResult selectResult = null;
        this.doSelect(x, y, apertureWidth, apertureHeight, ch, listName, doTransformations, immediateMode);
        int size = this.selectResultVector.size();
        if (size > 0) {
            selectResult = (SelectResult)this.selectResultVector.elementAt(size - 1);
        }
        return selectResult;
    }

    public synchronized Vector select(int x, int y, int apertureWidth, int apertureHeight, boolean doTransformations) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.select(): No associated channel.");
            return null;
        }
        return this.doSelect(x, y, apertureWidth, apertureHeight, this.channel, this.rootListName, doTransformations, false);
    }

    public synchronized Vector select(int x, int y, int apertureWidth, int apertureHeight, Channel channel, long rootListName, boolean doTransformations) {
        return this.doSelect(x, y, apertureWidth, apertureHeight, channel, rootListName, doTransformations, false);
    }

    private Vector doSelect(int x, int y, int apertureWidth, int apertureHeight, Channel ch, long listName, boolean doTransformations, boolean immediateMode) {
        Object selectResult = null;
        ch.glRenderMode(1);
        ch.gluPickMatrix(x, y, apertureWidth, apertureHeight);
        this.nameStack.removeAllElements();
        ch.glSelectBuffer(this.nameStack);
        if (immediateMode) {
            this.draw();
        } else {
            ch.glCallList(listName, doTransformations);
        }
        this.selectResultVector.removeAllElements();
        if (ch.glRenderMode(0)) {
            this.nameStackIterator.setNameStack(this.nameStack);
            while (this.nameStackIterator.hasNext()) {
                SelectResult sr = this.nameStackIterator.next();
                if (sr == null) continue;
                this.selectResultVector.addElement(sr);
            }
        }
        return this.selectResultVector;
    }

    private static boolean isSelectable(SelectEntry se) {
        Element element = se.getElement();
        int i = se.getValueIndex();
        boolean rc = false;
        try {
            rc = element.selectEnabled.getValue(i);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return rc;
    }

    public static NetworkRoot castNetworkRoot(ANetworkRoot anANetworkRoot) {
        return (NetworkRoot)anANetworkRoot;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public double setObliqueView(BoundingBox bbox, double fieldOfView, double azimuth, double incline) {
        double obliqueFactor = 0.5656;
        double distance = 1.0;
        azimuth = 0.0;
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.setglObliqueView(): No associated channel.");
            return distance;
        }
        double[] viewport = this.channel.glGetDoublev(0);
        double aspectRatio = viewport[3] / viewport[2];
        Vec3d boxSize = bbox.getSize();
        Vec3d center = bbox.getCenter();
        distance = boxSize.z * 0.5;
        double skew = boxSize.z * obliqueFactor * 0.5;
        double height = boxSize.y * 0.5 + skew;
        double width = boxSize.x * 0.5 + skew;
        if (height / width < aspectRatio) {
            this.channel.glOblique(center.x - width, center.x + width, center.y - width * aspectRatio, center.y + width * aspectRatio, -10.0, 10.0, obliqueFactor, 45.0);
        } else {
            this.channel.glOblique(center.x - height / aspectRatio, center.x + height / aspectRatio, center.y - height, center.y + height, -10.0, 10.0, obliqueFactor, 45.0);
        }
        this.channel.gluLookAt(0.0, 0.0, 0.0, distance, azimuth, incline, 0.0);
        return distance;
    }

    @Override
    public double setPerspectiveView(BoundingBox bbox, double fieldOfView, double azimuth, double incline) {
        double distance = 3.0;
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.setPerspectiveView(): No associated channel.");
            return distance;
        }
        double degrees2radians = Math.PI / 180;
        double[] viewport = this.channel.glGetDoublev(0);
        double aspectRatio = viewport[2] / viewport[3];
        double fov = fieldOfView * 0.5 * degrees2radians;
        Vec3d boxSize = bbox.getSize();
        Vec3d center = bbox.getCenter();
        distance = boxSize.x / boxSize.y >= aspectRatio ? boxSize.z + boxSize.x / Math.tan(aspectRatio * fov) : boxSize.z + boxSize.y / Math.tan(fov);
        distance *= 0.5 / Math.cos(azimuth * degrees2radians) / Math.cos(incline * degrees2radians);
        if (aspectRatio > 1.0) {
            aspectRatio = 1.0 / aspectRatio;
        }
        this.channel.gluPerspective(fieldOfView, 1.0 / aspectRatio, 0.1, 2.0 * distance);
        this.channel.gluLookAt(center.x, center.y, center.z, distance, azimuth, incline, 0.0);
        return distance;
    }

    private static class NameStackIterator {
        private Stack nameStack;
        private int entryCurrent;
        private int nameStackSize = -1;

        private NameStackIterator() {
        }

        public void setNameStack(Stack nameStack) {
            this.nameStack = nameStack;
            this.entryCurrent = 0;
            this.nameStackSize = nameStack != null ? nameStack.size() : -1;
        }

        public boolean hasNext() {
            return this.entryCurrent < this.nameStackSize;
        }

        public SelectResult next() {
            SelectEntry se;
            int e = 0;
            SelectResult selectResult = null;
            e = this.entryCurrent;
            int entryLength = (Integer)this.nameStack.elementAt(this.entryCurrent);
            boolean compositeSelectable = true;
            boolean isComposite = true;
            do {
                if ((se = (SelectEntry)this.nameStack.elementAt(++e)).getElement() instanceof Composite) {
                    compositeSelectable &= NetworkRoot.isSelectable(se);
                    continue;
                }
                isComposite = false;
            } while (isComposite);
            if (compositeSelectable && NetworkRoot.isSelectable(se)) {
                selectResult = new SelectResult(this.nameStack, this.entryCurrent);
            }
            this.entryCurrent += entryLength;
            return selectResult;
        }
    }
}

