/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Marker
extends Element {
    public final NumericProperty coordX = new NumericProperty(this, true);
    public final NumericProperty coordY = new NumericProperty(this, true);
    public final NumericProperty coordZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final IntegerProperty type = new IntegerProperty(this, true);
    public final IntegerProperty size = new IntegerProperty(this, true);

    public Marker() {
        super(new Transform());
        this.size.setValue(6);
        this.type.setValue(18);
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        try {
            channel.setMarkerSize(this.size.getValue(index));
            channel.setMarkerType(this.type.getValue(index));
            double x = this.coordX.getValue(index);
            double y = this.coordY.getValue(index);
            double z = this.coordZ.getValue(index);
            Color c = this.color.getValue(index);
            channel.glColor(c);
            c = this.edgeColor.getValue(index);
            channel.glEdgeColor(c);
            channel.glBegin(4);
            channel.glVertex(x, y, z);
            channel.glEnd();
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d pt = bBoxAction.pt1;
        BoundingBox box = bBoxAction.getElementBoundingBox();
        int i = bBoxAction.getValueIndex();
        try {
            pt.x = this.coordX.getValue(i);
            pt.y = this.coordY.getValue(i);
            pt.z = this.coordZ.getValue(i);
            box.union(pt);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }
}

