/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.LegendStyle;
import com.sas.graphics.util.vtk.jxd.Composite;
import com.sas.graphics.util.vtk.jxd.Legend;
import com.sas.graphics.util.vtk.jxd.NetworkRoot;
import com.sas.graphics.util.vtk.jxd.SelectResult;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LegendScroller
extends Container
implements MouseListener,
MouseMotionListener {
    private static final int TITLE_WIDTH = 0;
    private static final int TITLE_HEIGHT = 1;
    private static final int TITLE_ASCENT = 2;
    protected NetworkRoot networkRoot;
    protected Composite composite;
    protected Legend legend;
    protected boolean scrollable = false;
    protected long listname;
    public Channel channel;
    protected double nearValue = -100.0;
    protected double farValue = 100.0;
    ScrollRange xRange;
    ScrollRange yRange;
    protected boolean transparent = false;
    private int lookAtOriginX = 0;
    private int lookAtOriginY = 0;
    private Dimension psize;
    private Dimension visibleArea = new Dimension();
    int startX = 0;
    int startY = 0;
    private Cursor defaultCursor;
    private Cursor moveCursor = new Cursor(13);
    private Dimension preferredSize = new Dimension();
    private LegendStyle tmpStyle = new LegendStyle();
    private static final long serialVersionUID = 1L;

    public LegendScroller() {
        this.xRange = new ScrollRange();
        this.yRange = new ScrollRange();
        this.composite = new Composite();
        this.channel = new Channel(this);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.channel.glViewport(0, 0, 1, 1);
        this.channel.glOrtho(0.0, 1.0, 0.0, 1.0, -100.0, 100.0);
        this.channel.gluLookAt(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
        this.listname = this.channel.glGenLists(1L);
        this.networkRoot = new NetworkRoot(this.channel);
        this.networkRoot.addElement(this.composite);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Dimension size = this.getSize();
        this.legend.setWidth(-1.0);
        this.legend.setHeight(-1.0);
        this.psize = this.getLegendPreferredSize();
        double[] insets = this.legend.getTitleBorderInsets(this.channel, this.legend.title.getValue(), this.legend.getStyle());
        insets[0] = insets[0] + this.legend.labelMargin;
        insets[1] = insets[1] + this.legend.labelMargin;
        insets[2] = insets[2] + this.legend.labelMargin;
        insets[3] = insets[3] + this.legend.labelMargin;
        this.visibleArea.width = size.width - (int)(insets[2] + insets[3]);
        this.visibleArea.height = size.height - (int)(insets[0] + insets[1]);
        if (this.visibleArea.width >= this.psize.width) {
            this.legend.setWidth(this.visibleArea.width);
            this.psize.width = this.visibleArea.width;
        } else {
            this.legend.setWidth(this.psize.width);
        }
        if (this.visibleArea.height >= this.psize.height) {
            this.legend.setHeight(this.visibleArea.height);
            this.psize.height = this.visibleArea.height;
            this.lookAtOriginY = 0;
        } else {
            this.legend.setHeight(this.psize.height);
            this.lookAtOriginY = this.psize.height - this.visibleArea.height;
        }
        this.scrollable = this.visibleArea.width < this.psize.width || this.visibleArea.height < this.psize.height;
        this.yRange.setMaximum(this.psize.height);
        this.xRange.setMaximum(this.psize.width);
        this.yRange.setVisibleAmount(this.visibleArea.height);
        this.xRange.setVisibleAmount(this.visibleArea.width);
        this.yRange.setValue(0);
        this.xRange.setValue(0);
        this.rebuild();
    }

    public void setTransparent(boolean trueOrFalse) {
        this.transparent = trueOrFalse;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public Legend getLegend() {
        return this.legend;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startX = e.getX();
        this.startY = e.getY();
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (this.scrollable) {
            int x = e.getX();
            int y = e.getY();
            int diff = x - this.startX;
            int ydiff = y - this.startY;
            this.startX = x;
            this.startY = y;
            this.xRange.setValue(this.xRange.getValue() - diff);
            this.yRange.setValue(this.yRange.getValue() - ydiff);
            if (this.transparent) {
                this.getParent().repaint();
            } else {
                this.channel.gluLookAt(this.lookAtOriginX + this.xRange.getValue(), this.lookAtOriginY - this.yRange.getValue(), 0.0, 1.0, 0.0, 0.0, 0.0);
                this.networkRoot.refresh();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.scrollable) {
            if (this.getCursor() != this.moveCursor) {
                this.defaultCursor = this.getCursor();
                this.setCursor(this.moveCursor);
            }
        } else if (this.getCursor() == this.moveCursor) {
            this.setCursor(this.defaultCursor);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.getCursor() == this.moveCursor) {
            this.setCursor(this.defaultCursor);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.transparent) {
            this.getParent().repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            double oldWidth = this.legend.getWidth();
            double oldHeight = this.legend.getHeight();
            this.legend.setWidth(-1.0);
            this.legend.setHeight(-1.0);
            Dimension size = new Dimension(this.getLegendPreferredSize());
            Vec3d bounds = this.legend.addTitleDimensions(this.channel, this.legend.title.getValue(), 0.0, 0.0, this.legend.getStyle());
            bounds = this.legend.addBorderDimensions(bounds.x, bounds.y, this.legend.getStyle());
            size.width = (int)((double)size.width + bounds.x);
            size.height = (int)((double)size.height + bounds.y);
            this.legend.setWidth(oldWidth);
            this.legend.setHeight(oldHeight);
            return size;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setLegend(Legend legend) {
        if (legend != null) {
            this.composite.removeAllElements();
            this.composite.addElement(legend);
            this.legend = legend;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public synchronized void paint(Graphics g) {
        Dimension size = this.getSize();
        LegendStyle style = this.legend.getStyle();
        if (!this.transparent && style.isBackgroundOn()) {
            g.setColor(style.getBackgroundColor());
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(this.getForeground());
        }
        if (this.networkRoot != null) {
            this.channel.glViewport(0, 0, size.width, size.height);
            this.channel.glOrtho(0.0, size.width + 1, -1.0, size.height, this.nearValue, this.farValue);
            this.channel.gluLookAt(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
            this.channel.glNewList(this.listname);
            double[] insets = this.legend.drawTitleBorder(this.channel, size.width, size.height, this.legend.title.getValue(), this.legend.borderColor.getValue(), this.legend.borderLineColor.getValue(), style);
            this.channel.glEndList();
            if (this.transparent) {
                this.channel.glCallList(g, this.listname);
            } else {
                if (style.isBackgroundOn()) {
                    this.channel.setBackgroundColor(style.getBackgroundColor());
                } else {
                    this.channel.setBackgroundColor(this.getBackground());
                }
                this.channel.clearBGC();
                this.channel.glCallList(this.listname);
                this.channel.glRefresh(g);
            }
            insets[0] = insets[0] + this.legend.labelMargin;
            insets[1] = insets[1] + this.legend.labelMargin;
            insets[2] = insets[2] + this.legend.labelMargin;
            insets[3] = insets[3] + this.legend.labelMargin;
            this.visibleArea.width = size.width - (int)(insets[2] + insets[3]);
            this.visibleArea.height = size.height - (int)(insets[0] + insets[1]);
            this.channel.glViewport((int)insets[2], (int)insets[0], this.visibleArea.width, this.visibleArea.height);
            this.channel.glOrtho(0.0, this.visibleArea.width, 0.0, this.visibleArea.height, this.nearValue, this.farValue);
            this.channel.gluLookAt(this.lookAtOriginX + this.xRange.getValue(), this.lookAtOriginY - this.yRange.getValue(), 0.0, 1.0, 0.0, 0.0, 0.0);
            if (this.transparent) {
                this.channel.glCallList(g, this.networkRoot.getRootListName());
            } else {
                this.channel.clearBGC();
                this.channel.glCallList(this.networkRoot.getRootListName());
                this.channel.glRefresh(g);
            }
        }
        super.paint(g);
    }

    public synchronized void rebuild() {
        if (this.networkRoot != null) {
            this.pushStyle();
            this.networkRoot.build();
            this.popStyle();
        }
    }

    private void pushStyle() {
        LegendStyle style = this.legend.getStyle();
        this.tmpStyle.setBorderOn(style.isBorderOn());
        this.tmpStyle.setTitleOn(style.isTitleOn());
        this.tmpStyle.setBackgroundOn(style.isBackgroundOn());
        this.tmpStyle.setLabelsOn(style.isLabelsOn());
        style.setBorderOn(false);
        style.setTitleOn(false);
        style.setBackgroundOn(false);
        style.setLabelsOn(true);
    }

    private void popStyle() {
        LegendStyle style = this.legend.getStyle();
        style.setBorderOn(this.tmpStyle.isBorderOn());
        style.setTitleOn(this.tmpStyle.isTitleOn());
        style.setBackgroundOn(this.tmpStyle.isBackgroundOn());
        style.setLabelsOn(this.tmpStyle.isLabelsOn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getLegendPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.networkRoot != null) {
                this.pushStyle();
                BoundingBox bbox = this.networkRoot.computeBoundingBox();
                this.popStyle();
                Vec3d bboxSize = bbox.getSize();
                Vec3d bboxCenter = bbox.getCenter();
                this.preferredSize.width = (int)Math.round(bboxSize.x);
                this.preferredSize.height = (int)Math.round(bboxSize.y);
                this.nearValue = bboxCenter.z - bboxSize.z / 2.0 - 1.0;
                this.farValue = bboxCenter.z + bboxSize.z / 2.0 + 1.0;
            }
            return this.preferredSize;
        }
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public SelectResult select(int x, int y, int apertureWidth, int apertureHeight) {
        return this.networkRoot.selectClosest(x, y, apertureWidth, apertureHeight, true);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private class ScrollRange {
        int value;
        int maximum;
        int minimum;
        int visibleAmount;

        public ScrollRange() {
            this.setValues(0, 10, 0, 100);
        }

        public int getMaximum() {
            return this.maximum;
        }

        public synchronized void setMaximum(int newMaximum) {
            this.setValues(this.value, this.visibleAmount, this.minimum, newMaximum);
        }

        public int getValue() {
            return this.value;
        }

        public synchronized void setValue(int newValue) {
            this.setValues(newValue, this.visibleAmount, this.minimum, this.maximum);
        }

        public int getMinimum() {
            return this.minimum;
        }

        public synchronized void setMinimum(int newMinimum) {
            this.setValues(this.value, this.visibleAmount, newMinimum, this.maximum);
        }

        public int getVisibleAmount() {
            return this.visibleAmount;
        }

        public synchronized void setVisibleAmount(int newAmount) {
            this.setValues(this.value, newAmount, this.minimum, this.maximum);
        }

        public synchronized void setValues(int value, int visible, int minimum, int maximum) {
            if (maximum <= minimum) {
                maximum = minimum + 1;
            }
            if (visible > maximum - minimum) {
                visible = maximum - minimum;
            }
            if (visible < 1) {
                visible = 1;
            }
            if (value < minimum) {
                value = minimum;
            }
            if (value > maximum - visible) {
                value = maximum - visible;
            }
            this.value = value;
            this.visibleAmount = visible;
            this.minimum = minimum;
            this.maximum = maximum;
        }
    }
}

