/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AIndexedFaceSet;
import com.sas.graphics.util.vtk.IndexedFaceSetDetail;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.SelectDetail;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;
import java.util.Stack;

public class IndexedFaceSet
extends AIndexedFaceSet {
    public IndexedFaceSet() {
        super(new Transform());
        this.colorScope = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        int coordCount;
        Color perSetColor = null;
        Vec3d thickness = new Vec3d();
        if (this.colorScope == 0) {
            throw new VTKRuntimeException("JXD does not support Colors per vertex");
        }
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        boolean selectDetailsOn = this.selectDetailEnabled.getValue(index);
        if (this.colorScope == 2) {
            perSetColor = this.color.getValue(index);
        }
        channel.glPushAttrib(0);
        if (this.edgeScope == 2) {
            if (this.edgeOn.getValue(index)) {
                channel.glEdgeColor(this.edgeColor.getValue(index));
                channel.glPolygonMode(BuildAction.getJXDFillStyle(this.fillOn.getValue(index), true));
            } else {
                channel.glPolygonMode(BuildAction.getJXDFillStyle(this.fillOn.getValue(index), false));
            }
        }
        if (!this.solid) {
            channel.glDisable(1);
        }
        if (!this.ccw) {
            channel.glFrontFace(1);
        }
        int coordI = 0;
        int colorI = 0;
        int normalI = 0;
        int edgeIndex = 0;
        int extrudeIndex = 0;
        int extrudeCount = 0;
        int faceIndex = 0;
        int i = 0;
        double extThickness = 0.0;
        Vec3d extrudeAlongVector = new Vec3d();
        Vec3d normalVector = new Vec3d();
        int n = coordCount = this.numCoordIndexes == -1 ? this.numCoords : this.numCoordIndexes;
        if (this.colorScope == 2) {
            channel.glColor(perSetColor);
        }
        while (i < coordCount) {
            try {
                int stopIndex;
                int startIndex = i;
                coordI = i;
                if (this.numCoordIndexes != -1) {
                    coordI = (int)this.coordIndex.getValue(i);
                    while (coordI != -1 && i < this.numCoordIndexes - 1) {
                        coordI = (int)this.coordIndex.getValue(++i);
                    }
                    stopIndex = coordI == -1 ? i - 1 : i;
                } else {
                    i = stopIndex = this.numCoords - 1;
                }
                if (selectDetailsOn) {
                    channel.glLoadName(new Integer(faceIndex));
                    ++faceIndex;
                }
                if (this.colorScope == 1) {
                    if (this.numColorIndexes != -1) {
                        int ci;
                        if ((ci = (int)this.colorIndex.getValue(colorI++)) == -1) {
                            ci = (int)this.colorIndex.getValue(colorI++);
                        }
                        channel.glColor(this.color.getValue(ci));
                    } else {
                        channel.glColor(this.color.getValue(colorI++));
                    }
                }
                if (this.numNormals != -1 && !this.normalPerVertex) {
                    int ni;
                    if (this.numNormalIndexes > 0) {
                        if ((ni = (int)this.normalIndex.getValue(normalI++)) == -1) {
                            ni = (int)this.normalIndex.getValue(normalI++);
                        }
                    } else {
                        ni = normalI++;
                    }
                    normalVector.set(this.normalX.getValue(ni), this.normalY.getValue(ni), this.normalZ.getValue(ni));
                    channel.glNormal(normalVector.x, normalVector.y, normalVector.z);
                }
                if (this.edgeScope == 1) {
                    if (this.edgeOn.getValue(edgeIndex)) {
                        channel.glEdgeColor(this.edgeColor.getValue(edgeIndex));
                        channel.glPolygonMode(BuildAction.getJXDFillStyle(this.fillOn.getValue(edgeIndex), true));
                    } else {
                        channel.glPolygonMode(BuildAction.getJXDFillStyle(this.fillOn.getValue(edgeIndex), false));
                    }
                    ++edgeIndex;
                }
                if (this.numNormals == -1) {
                    double nx = 0.0;
                    double ny = 0.0;
                    double nz = 0.0;
                    try {
                        nx = this.normalX.getValue(0);
                        ny = this.normalY.getValue(0);
                        nz = this.normalZ.getValue(0);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    if (nx == 0.0 && ny == 0.0 && nz == 0.0) {
                        channel.glEnable(0);
                    } else {
                        channel.glNormal(nx, ny, nz);
                    }
                }
                if (this.extrudeScope == 1) {
                    if (this.numExtrudeVectorIndexes != -1) {
                        if ((extrudeIndex = (int)this.extrudeVectorIndex.getValue(extrudeCount++)) == -1) {
                            extrudeIndex = (int)this.extrudeVectorIndex.getValue(extrudeCount++);
                        }
                    } else {
                        extrudeIndex = extrudeCount++;
                    }
                } else if (this.extrudeScope == 2) {
                    extrudeIndex = index;
                }
                if (!this.extrudeOn.getValue(extrudeIndex)) {
                    this.drawIFSFace(channel, startIndex, stopIndex, false);
                    continue;
                }
                extrudeAlongVector.x = this.extrudeVectorX.getValue(extrudeIndex);
                extrudeAlongVector.y = this.extrudeVectorY.getValue(extrudeIndex);
                extrudeAlongVector.z = this.extrudeVectorZ.getValue(extrudeIndex);
                extThickness = this.extrudeThickness.getValue(extrudeIndex);
                extrudeAlongVector.scale(extThickness);
                channel.setExtrusionVector(extrudeAlongVector.x, extrudeAlongVector.y, extrudeAlongVector.z);
                this.drawIFSFace(channel, startIndex, stopIndex, true);
            }
            catch (MissingValueException missingValueException) {}
            continue;
            finally {
                ++i;
            }
        }
        channel.glPopAttrib();
    }

    private void drawIFSFace(Channel channel, int startI, int stopI, boolean extrude) throws MissingValueException {
        boolean edgeFlag = true;
        int index = startI;
        if (extrude) {
            channel.glBegin(3);
        } else {
            channel.glBegin(2);
        }
        while (index != stopI + 1) {
            int coordI = index;
            if (this.numCoordIndexes != -1) {
                coordI = (int)this.coordIndex.getValue(index);
            }
            if (coordI != -2) {
                int nextIndex;
                if (!edgeFlag) {
                    edgeFlag = true;
                    channel.glEdgeFlag(edgeFlag);
                }
                if ((nextIndex = index + 1) != stopI + 1) {
                    int coordII = nextIndex;
                    if (this.numCoordIndexes != -1) {
                        coordII = (int)this.coordIndex.getValue(nextIndex);
                    }
                    if (coordII == -2) {
                        edgeFlag = false;
                        channel.glEdgeFlag(edgeFlag);
                    }
                }
                double x = this.coordX.getValue(coordI);
                double y = this.coordY.getValue(coordI);
                double z = this.coordZ.getValue(coordI);
                channel.glVertex(x, y, z);
            }
            ++index;
        }
        channel.glEnd();
    }

    @Override
    public SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int detailIndex = startIndex + entryLength - 1;
        Integer faceIndex = (Integer)nameStack.elementAt(detailIndex);
        if (faceIndex == null) {
            return null;
        }
        IndexedFaceSetDetail ifsDetail = new IndexedFaceSetDetail(this, faceIndex);
        ifsDetail.computeDetails();
        return ifsDetail;
    }
}

