/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AImage;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Image
extends AImage {
    public static void drawImage(Channel channel, java.awt.Image image, int horizontalJustification, int verticalJustification, int scaleType, boolean scaleOn, double width, double height, Color bgColor) {
        java.awt.Image scaledImage = image;
        channel.glPushAttrib(0);
        channel.glAlignment(horizontalJustification, verticalJustification);
        channel.ImageWaitImage(waitImage);
        if (width < 0.0) {
            width = 0.0;
        }
        if (height < 0.0) {
            height = 0.0;
        }
        double[] startWC = new double[]{0.0, 0.0, 0.0};
        double[] endWC = new double[]{width, height, 0.0};
        double[] startSC = new double[3];
        double[] endSC = new double[3];
        channel.gluProject(startWC, startSC);
        channel.gluProject(endWC, endSC);
        int imageWidth = (int)(endSC[0] - startSC[0]);
        int imageHeight = (int)(startSC[1] - endSC[1]);
        if (scaleOn) {
            scaledImage = image.getScaledInstance(imageWidth, imageHeight, scaleType);
        }
        Color rasterBackground = channel.getRasterBackgroundColor();
        channel.setRasterBackgroundColor(bgColor);
        channel.Image2D(scaledImage, 0.0, 0.0, 0.0, imageWidth, imageHeight);
        channel.setRasterBackgroundColor(rasterBackground);
        channel.glPopAttrib();
    }

    public Image() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        java.awt.Image image = null;
        try {
            int imageIndex = (int)this.whichImage.getValue(buildAction.getValueIndex());
            image = this.getImage(imageIndex);
            if (image != null) {
                Color background = this.backgroundColorOn.getValue(index) ? this.backgroundColor.getValue(index) : null;
                Image.drawImage(ba.getChannel(), image, this.horizontalJustification.getValue(index), this.verticalJustification.getValue(index), this.imageScaleType.getValue(index), this.imageScaleOn.getValue(index), this.width.getValue(index), this.height.getValue(index), background);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }
}

