/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AGrid;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.LineSegment;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Grid
extends AGrid {
    protected Channel channel;

    public Grid() {
        super(new Transform());
    }

    public Grid(Vec3d normal) {
        this();
        this.setNormal(normal);
    }

    @Override
    public void render(ABuildAction buildAction) {
        int i;
        double minTicDelta;
        double zNormalComponent;
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        this.channel = ba.getChannel();
        this.channel.glPushMatrix();
        if (!ATransform.isZero(this.normal.x)) {
            zNormalComponent = this.normal.x;
            this.channel.glTranslate(0.0, this.verticalOrigin, this.horizontalOrigin + this.width);
            this.channel.glRotate(90.0, 0.0, 1.0, 0.0);
            this.channel.glTranslate(-this.horizontalOrigin, -this.verticalOrigin, 0.0);
        } else if (!ATransform.isZero(this.normal.y)) {
            zNormalComponent = this.normal.y;
            this.channel.glTranslate(this.horizontalOrigin, 0.0, this.height + this.verticalOrigin);
            this.channel.glRotate(-90.0, 1.0, 0.0, 0.0);
            this.channel.glTranslate(-this.horizontalOrigin, -this.verticalOrigin, 0.0);
        } else {
            zNormalComponent = this.normal.z;
        }
        if (this.style.isBackgroundOn()) {
            this.drawBackground(this.backgroundHorizontalOrigin, this.backgroundVerticalOrigin, 0.0, this.backgroundHorizontalOrigin + this.width, this.backgroundVerticalOrigin + this.height, 0.0, 0.0, 0.0, zNormalComponent, this.style.getBackgroundColor());
            this.channel.glTranslate(0.0, 0.0, zNormalComponent * this.width / 10000.0);
        }
        int index = 0;
        double prevOffset = this.horizontalOrigin;
        int numOfMinGrids = this.style.getMinorGridLineCount();
        boolean connected = this.verticalLineOffset.isConnected();
        double offset = this.verticalLineOffset.getValue();
        if (!connected && offset > 0.0) {
            this.verticalLineCount = (int)(this.width / offset) - 1;
        }
        offset += prevOffset;
        for (index = 0; index < this.verticalLineCount; ++index) {
            try {
                if (connected) {
                    offset = this.verticalLineOffset.getValue(index);
                }
                this.drawVerticalMajorLine(offset, this.verticalOrigin, offset, this.height + this.verticalOrigin, this.style.getLineWidth(), this.style.getMajorLineColor(), this.style.getStipplePattern(), this.style.getStippleFactor());
                if (this.style.isVerticalMinorLinesOn() && (minTicDelta = (offset - prevOffset) / (double)(numOfMinGrids + 1)) != 0.0) {
                    for (i = 1; i <= numOfMinGrids; ++i) {
                        this.drawVerticalMinorLine(prevOffset + minTicDelta * (double)i, this.verticalOrigin, prevOffset + minTicDelta * (double)i, this.height + this.verticalOrigin, this.style.getMinorLineWidth(), this.style.getMinorLineColor(), this.style.getMinorStipplePattern(), this.style.getMinorStippleFactor());
                    }
                }
                prevOffset = offset;
                if (connected) continue;
                offset += this.verticalLineOffset.getValue();
                continue;
            }
            catch (MissingValueException minTicDelta2) {
                // empty catch block
            }
        }
        if (this.style.isVerticalMinorLinesOn() && this.horizontalOrigin + this.width > prevOffset) {
            minTicDelta = (this.horizontalOrigin + this.width - prevOffset) / (double)(numOfMinGrids + 1);
            for (i = 1; i <= numOfMinGrids; ++i) {
                this.drawVerticalMinorLine(prevOffset + minTicDelta * (double)i, this.verticalOrigin, prevOffset + minTicDelta * (double)i, this.height + this.verticalOrigin, this.style.getMinorLineWidth(), this.style.getMinorLineColor(), this.style.getMinorStipplePattern(), this.style.getMinorStippleFactor());
            }
        }
        prevOffset = this.verticalOrigin;
        connected = this.horizontalLineOffset.isConnected();
        offset = this.horizontalLineOffset.getValue();
        if (!connected && offset > 0.0) {
            this.horizontalLineCount = (int)(this.height / offset) - 1;
        }
        offset += prevOffset;
        for (index = 0; index < this.horizontalLineCount; ++index) {
            try {
                double minTicDelta3;
                if (connected) {
                    offset = this.horizontalLineOffset.getValue(index);
                }
                this.drawHorizontalMajorLine(this.horizontalOrigin, offset, this.horizontalOrigin + this.width, offset, this.style.getLineWidth(), this.style.getMajorLineColor(), this.style.getStipplePattern(), this.style.getStippleFactor());
                if (this.style.isHorizontalMinorLinesOn() && (minTicDelta3 = (offset - prevOffset) / (double)(numOfMinGrids + 1)) != 0.0) {
                    for (i = 1; i <= numOfMinGrids; ++i) {
                        this.drawHorizontalMinorLine(this.horizontalOrigin, prevOffset + minTicDelta3 * (double)i, this.horizontalOrigin + this.width, prevOffset + minTicDelta3 * (double)i, this.style.getMinorLineWidth(), this.style.getMinorLineColor(), this.style.getMinorStipplePattern(), this.style.getMinorStippleFactor());
                    }
                }
                prevOffset = offset;
                if (connected) continue;
                offset += this.horizontalLineOffset.getValue();
                continue;
            }
            catch (MissingValueException minTicDelta3) {
                // empty catch block
            }
        }
        if (this.style.isHorizontalMinorLinesOn() && this.verticalOrigin + this.height > prevOffset) {
            double minTicDelta4 = (this.height - prevOffset) / (double)(numOfMinGrids + 1);
            for (i = 1; i <= numOfMinGrids; ++i) {
                this.drawHorizontalMinorLine(this.horizontalOrigin, prevOffset + minTicDelta4 * (double)i, this.horizontalOrigin + this.width, prevOffset + minTicDelta4 * (double)i, this.style.getMinorLineWidth(), this.style.getMinorLineColor(), this.style.getMinorStipplePattern(), this.style.getMinorStippleFactor());
            }
        }
        if (this.style.isBorderOn()) {
            this.drawBorder(this.backgroundHorizontalOrigin, this.backgroundVerticalOrigin, this.backgroundHorizontalOrigin + this.width, this.backgroundVerticalOrigin + this.height, this.style.getMajorLineColor());
        }
        this.channel.glPopMatrix();
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        size.x = this.width;
        size.y = this.height;
        size.z = 0.0;
        center.x = this.horizontalOrigin + this.width / 2.0;
        center.y = this.height / 2.0;
        center.z = 0.0;
        if (!ATransform.isZero(this.normal.x)) {
            center.z = center.x;
            center.x = 0.0;
            size.z = size.x;
            size.x = 0.0;
        } else if (!ATransform.isZero(this.normal.y)) {
            center.z = center.y;
            center.y = 0.0;
            size.z = size.y;
            size.y = 0.0;
        }
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    @Override
    protected void drawVerticalMajorLine(double beginX, double beginY, double endX, double endY, int width, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, width, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawVerticalMinorLine(double beginX, double beginY, double endX, double endY, int width, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, width, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawHorizontalMajorLine(double beginX, double beginY, double endX, double endY, int width, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, width, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawHorizontalMinorLine(double beginX, double beginY, double endX, double endY, int width, Color color, int stipplePattern, int stippleFactor) {
        LineSegment.drawLineSegment(this.channel, beginX, beginY, 0.0, endX, endY, 0.0, color, width, stipplePattern, stippleFactor);
    }

    @Override
    protected void drawBackground(double llx, double lly, double llz, double urx, double ury, double urz, double normalx, double normaly, double normalz, Color color) {
        this.channel.glPushAttrib(0);
        this.channel.glColor(color);
        this.channel.glPolygonMode(3);
        this.channel.glBegin(2);
        this.channel.glNormal(normalx, normaly, normalz);
        if (normalz > 0.0) {
            this.channel.glVertex(llx, lly, llz);
            this.channel.glVertex(urx, lly, urz);
            this.channel.glVertex(urx, ury, urz);
            this.channel.glVertex(llx, ury, llz);
        } else {
            this.channel.glVertex(llx, lly, llz);
            this.channel.glVertex(llx, ury, llz);
            this.channel.glVertex(urx, ury, urz);
            this.channel.glVertex(urx, lly, urz);
        }
        this.channel.glEnd();
        this.channel.glPopAttrib();
    }

    @Override
    protected void drawBorder(double llx, double lly, double urx, double ury, Color color) {
        this.channel.glColor(color);
        this.channel.glBegin(1);
        this.channel.glVertex(llx, lly);
        this.channel.glVertex(urx, lly);
        this.channel.glVertex(urx, ury);
        this.channel.glVertex(llx, ury);
        this.channel.glVertex(llx, lly);
        this.channel.glEnd();
    }
}

