/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AGanttBox;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class GanttBox
extends AGanttBox {
    private static final int BAR_TYPE_CRYTICAL = 0;
    private static final int BAR_TYPE_NORMAL = 1;
    private static final int BAR_TYPE_EXTENDED = 2;
    static Vec3d[] earlyArray = new Vec3d[]{new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d()};
    static Vec3d[] interumArray = new Vec3d[]{new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d()};
    static Vec3d[] lateArray = new Vec3d[]{new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d(), new Vec3d()};

    public GanttBox() {
        super(new Transform());
    }

    public static void drawElement(Channel channel, double earlyStart, double earlyFinish, double lateStart, double lateFinish, int boxStyle, int boxConnectionStyle, double orientation, double boxThickness, double fangThickness, boolean fangWidthAdjust, boolean fangThicknessAdjust, Color earlyColor, Color lateColor, Color criticalColor, Color outlineColor, int criticalFillStyle, int earlyFillStyle, int lateFillStyle) {
        double midw;
        double midh;
        Vec3d[][] geometry = null;
        int[] fillStyle = null;
        Color[] fillColor = null;
        if (boxStyle != 2) {
            double s2;
            double s1;
            midh = boxThickness;
            midw = 0.0;
            double fangSize = 0.0;
            if (boxStyle == 1) {
                fangSize = fangThicknessAdjust ? fangThickness : boxThickness / 2.0;
                midh -= fangSize;
                midw = Math.abs(fangSize);
            }
            if (fangWidthAdjust) {
                s1 = Math.min(earlyStart + midw, earlyFinish);
                s2 = Math.max(lateFinish - midw, earlyFinish == lateFinish ? lateStart : Math.max(earlyFinish, lateStart));
            } else {
                s1 = earlyStart + midw;
                s2 = lateFinish - midw;
            }
            int barType = earlyFinish == lateFinish ? 0 : (lateFinish > earlyFinish && lateStart > earlyFinish || lateFinish < earlyFinish && lateStart < earlyFinish ? 2 : 1);
            Vec3d[] a = null;
            Vec3d[] boxGeometryEarly = null;
            Vec3d[] boxGeometryInterum = null;
            Vec3d[] boxGeometryLate = null;
            switch (barType) {
                case 0: {
                    boxGeometryEarly = earlyArray;
                    a = earlyArray;
                    a[0].x = earlyStart;
                    a[0].y = 0.0;
                    a[1].x = earlyStart;
                    a[1].y = boxThickness;
                    a[2].x = s1;
                    a[2].y = midh;
                    a[3].x = s2;
                    a[3].y = midh;
                    a[4].x = earlyFinish;
                    a[4].y = boxThickness;
                    a[5].x = earlyFinish;
                    a[5].y = 0.0;
                    earlyFillStyle = criticalFillStyle;
                    earlyColor = criticalColor;
                    break;
                }
                case 1: {
                    boxGeometryEarly = earlyArray;
                    a = earlyArray;
                    a[0].x = earlyStart;
                    a[0].y = 0.0;
                    a[1].x = earlyStart;
                    a[1].y = boxThickness;
                    a[2].x = s1;
                    a[2].y = midh;
                    a[3].x = earlyFinish;
                    a[3].y = midh;
                    a[4].x = earlyFinish;
                    a[4].y = 0.0;
                    a[5].x = earlyFinish;
                    a[5].y = 0.0;
                    boxGeometryLate = lateArray;
                    a = lateArray;
                    a[0].x = earlyFinish;
                    a[0].y = 0.0;
                    a[1].x = earlyFinish;
                    a[1].y = midh;
                    a[2].x = s2;
                    a[2].y = midh;
                    a[3].x = lateFinish;
                    a[3].y = boxThickness;
                    a[4].x = lateFinish;
                    a[4].y = 0.0;
                    break;
                }
                case 2: {
                    double indent;
                    boxGeometryEarly = earlyArray;
                    a = earlyArray;
                    a[0].x = earlyStart;
                    a[0].y = 0.0;
                    a[1].x = earlyStart;
                    a[1].y = boxThickness;
                    a[2].x = s1;
                    a[2].y = midh;
                    a[3].x = earlyFinish;
                    a[3].y = midh;
                    a[4].x = earlyFinish;
                    a[4].y = 0.0;
                    a[5].x = earlyFinish;
                    a[5].y = 0.0;
                    switch (boxConnectionStyle) {
                        default: {
                            indent = 0.0;
                            break;
                        }
                        case 2: {
                            indent = midh / 2.0;
                            break;
                        }
                        case 1: {
                            indent = midh / 4.0;
                        }
                    }
                    boxGeometryInterum = interumArray;
                    a = interumArray;
                    a[0].x = earlyFinish;
                    a[0].y = indent;
                    a[1].x = earlyFinish;
                    a[1].y = midh - indent;
                    a[2].x = lateStart;
                    a[2].y = midh - indent;
                    a[3].x = lateStart;
                    a[3].y = indent;
                    boxGeometryLate = lateArray;
                    a = lateArray;
                    a[0].x = lateStart;
                    a[0].y = 0.0;
                    a[1].x = lateStart;
                    a[1].y = midh;
                    a[2].x = s2;
                    a[2].y = midh;
                    a[3].x = lateFinish;
                    a[3].y = boxThickness;
                    a[4].x = lateFinish;
                    a[4].y = 0.0;
                }
            }
            geometry = new Vec3d[][]{boxGeometryEarly, boxGeometryInterum, boxGeometryLate};
            fillStyle = new int[]{earlyFillStyle, lateFillStyle, lateFillStyle};
            fillColor = new Color[]{earlyColor, lateColor, lateColor};
        } else {
            double s2a;
            double s1b;
            midh = boxThickness - boxThickness / 2.0;
            midw = Math.abs(boxThickness / 2.0);
            double s1a = earlyStart - midw;
            double s2b = lateFinish + midw;
            if (fangWidthAdjust) {
                s1b = Math.min(earlyStart + midw, earlyFinish);
                s2a = Math.max(lateFinish - midw, earlyFinish == lateFinish ? lateStart : Math.max(earlyFinish, lateStart));
            } else {
                s1b = earlyStart + midw;
                s2a = lateFinish - midw;
            }
            Vec3d[] symbol1 = new Vec3d[]{new Vec3d(earlyStart, 0.0, 0.0), new Vec3d(s1a, midh, 0.0), new Vec3d(earlyStart, boxThickness, 0.0), new Vec3d(s1b, midh, 0.0)};
            Vec3d[] symbol2 = new Vec3d[]{new Vec3d(lateFinish, 0.0, 0.0), new Vec3d(s2a, midh, 0.0), new Vec3d(lateFinish, boxThickness, 0.0), new Vec3d(s2b, midh, 0.0)};
            Vec3d[] boxGeometry = new Vec3d[]{new Vec3d(earlyStart, 0.0, 0.0), new Vec3d(earlyStart, boxThickness, 0.0), new Vec3d(lateFinish, boxThickness, 0.0), new Vec3d(lateFinish, 0.0, 0.0)};
            geometry = new Vec3d[][]{boxGeometry, symbol1, symbol2};
            fillStyle = new int[]{0, criticalFillStyle, criticalFillStyle};
            fillColor = new Color[]{criticalColor, criticalColor, criticalColor};
        }
        boolean horizontal = orientation != 1.0;
        for (int ii = 0; ii < geometry.length; ++ii) {
            if (geometry[ii] == null) continue;
            channel.glColor(fillColor[ii]);
            channel.glEdgeColor(outlineColor);
            switch (fillStyle[ii]) {
                case -1: {
                    channel.glPolygonMode(5);
                    break;
                }
                case 1: {
                    channel.glPolygonMode(3);
                    break;
                }
                case 2: {
                    channel.glPolygonMode(4);
                    break;
                }
                case 0: {
                    channel.glColor(outlineColor);
                    channel.glPolygonMode(2);
                }
            }
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            int size = geometry[ii].length;
            for (int jj = 0; jj < size; ++jj) {
                Vec3d p = geometry[ii][jj];
                if (horizontal) {
                    channel.glVertex(p.x, p.y);
                    continue;
                }
                channel.glVertex(p.y, p.x);
            }
            channel.glEnd();
        }
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        GanttBox.drawElement(channel, this.earlyStart.getValue(index), this.earlyFinish.getValue(index), this.lateStart.getValue(index), this.lateFinish.getValue(index), this.boxStyle.getValue(index), this.boxConnectionStyle.getValue(index), this.orientation.getValue(index), this.boxThickness.getValue(index), this.fangThickness.getValue(index), this.fangWidthAdjust.getValue(index), this.fangThicknessAdjust.getValue(index), this.earlyColor.getValue(index), this.lateColor.getValue(index), this.criticalColor.getValue(index), this.outlineColor.getValue(index), this.criticalFillStyle.getValue(index), this.earlyFillStyle.getValue(index), this.lateFillStyle.getValue(index));
    }

    @Override
    protected void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }
}

