/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.jxd.Composite;
import com.sas.graphics.util.vtk.jxd.GanttBox;
import java.awt.Color;

public class ComplexGanttBox
extends Composite {
    public static final int BOX_STYLE_HALF_BOX = 0;
    public static final int BOX_STYLE_MILESTONE = 1;
    public static final int BOX_STYLE_SUMMARY = 2;
    public static final int BOX_STYLE_SUMMARY_ALL = 3;
    public static final int BOX_STYLE_FULL_BOX = 4;
    public static final int BOX_STYLE_FULL_MILESTONE = 5;
    public final NumericProperty earlyStart = new NumericProperty(this, true);
    public final NumericProperty earlyFinish = new NumericProperty(this, true);
    public final NumericProperty lateStart = new NumericProperty(this, true);
    public final NumericProperty lateFinish = new NumericProperty(this, true);
    public final NumericProperty actualStart = new NumericProperty(this, true);
    public final NumericProperty actualFinish = new NumericProperty(this, true);
    public final NumericProperty resourceStart = new NumericProperty(this, true);
    public final NumericProperty resourceFinish = new NumericProperty(this, true);
    public final NumericProperty baselineStart = new NumericProperty(this, true);
    public final NumericProperty baselineFinish = new NumericProperty(this, true);
    public final ColorProperty earlyColor = new ColorProperty(this, true);
    public final ColorProperty lateColor = new ColorProperty(this, true);
    public final ColorProperty actualColor = new ColorProperty(this, true);
    public final ColorProperty resourceColor = new ColorProperty(this, true);
    public final ColorProperty baselineColor = new ColorProperty(this, true);
    public final ColorProperty criticalColor = new ColorProperty(this, true);
    public final ColorProperty outlineColor = new ColorProperty(this, true);
    public final IntegerProperty earlyFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty lateFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty actualFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty resourceFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty baselineFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty criticalFillStyle = new IntegerProperty(this, true);
    public final IntegerProperty boxConnectionStyle = new IntegerProperty(this, true);
    public final IntegerProperty boxStyle = new IntegerProperty(this, true);
    public final NumericProperty orientation = new NumericProperty(this, true);
    public final NumericProperty boxThickness = new NumericProperty(this, true);
    public final BooleanProperty contained = new BooleanProperty(this, true);
    public final BooleanProperty fangWidthAdjust = new BooleanProperty(this, true);
    protected GanttBox ganttBox = new GanttBox();
    protected GanttBox actualBox = new GanttBox();
    protected GanttBox resourceBox = new GanttBox();
    protected GanttBox baselineBox = new GanttBox();
    protected GanttBox containBox = new GanttBox();
    protected int ganttSize = 0;
    protected int actualSize = 0;
    protected int resourceSize = 0;
    protected int baselineSize = 0;
    protected int totalBoxSize = 0;
    boolean ok = true;

    public ComplexGanttBox() {
        this.boxStyle.setValue(0);
        this.boxConnectionStyle.setValue(0);
        this.orientation.setValue(0.0);
        this.boxThickness.setValue(0.25);
        this.earlyColor.setValue(Color.green);
        this.lateColor.setValue(Color.white);
        this.actualColor.setValue(Color.blue);
        this.resourceColor.setValue(Color.gray);
        this.baselineColor.setValue(Color.cyan);
        this.criticalColor.setValue(Color.red);
        this.outlineColor.setValue(Color.black);
        this.earlyFillStyle.setValue(2);
        this.lateFillStyle.setValue(2);
        this.actualFillStyle.setValue(2);
        this.resourceFillStyle.setValue(2);
        this.baselineFillStyle.setValue(2);
        this.criticalFillStyle.setValue(2);
        this.ganttBox.boxStyle.setValue(0);
        this.ganttBox.boxConnectionStyle.connectFrom(this.boxConnectionStyle);
        this.ganttBox.orientation.connectFrom(this.orientation);
        this.ganttBox.earlyStart.connectFrom(this.earlyStart);
        this.ganttBox.earlyFinish.connectFrom(this.earlyFinish);
        this.ganttBox.lateStart.connectFrom(this.lateStart);
        this.ganttBox.lateFinish.connectFrom(this.lateFinish);
        this.ganttBox.earlyColor.connectFrom(this.earlyColor);
        this.ganttBox.lateColor.connectFrom(this.lateColor);
        this.ganttBox.criticalColor.connectFrom(this.criticalColor);
        this.ganttBox.earlyFillStyle.connectFrom(this.earlyFillStyle);
        this.ganttBox.lateFillStyle.connectFrom(this.lateFillStyle);
        this.ganttBox.criticalFillStyle.connectFrom(this.criticalFillStyle);
        this.ganttBox.outlineColor.connectFrom(this.outlineColor);
        this.ganttBox.fangWidthAdjust.connectFrom(this.fangWidthAdjust);
        this.actualBox.boxStyle.setValue(0);
        this.actualBox.orientation.connectFrom(this.orientation);
        this.actualBox.earlyStart.connectFrom(this.actualStart);
        this.actualBox.earlyFinish.connectFrom(this.actualFinish);
        this.actualBox.lateStart.connectFrom(this.actualStart);
        this.actualBox.lateFinish.connectFrom(this.actualFinish);
        this.actualBox.criticalColor.connectFrom(this.actualColor);
        this.actualBox.criticalFillStyle.connectFrom(this.actualFillStyle);
        this.actualBox.outlineColor.connectFrom(this.outlineColor);
        this.actualBox.fangWidthAdjust.connectFrom(this.fangWidthAdjust);
        this.resourceBox.boxStyle.setValue(0);
        this.resourceBox.orientation.connectFrom(this.orientation);
        this.resourceBox.earlyStart.connectFrom(this.resourceStart);
        this.resourceBox.earlyFinish.connectFrom(this.resourceFinish);
        this.resourceBox.lateStart.connectFrom(this.resourceStart);
        this.resourceBox.lateFinish.connectFrom(this.resourceFinish);
        this.resourceBox.criticalColor.connectFrom(this.resourceColor);
        this.resourceBox.criticalFillStyle.connectFrom(this.resourceFillStyle);
        this.resourceBox.outlineColor.connectFrom(this.outlineColor);
        this.resourceBox.fangWidthAdjust.connectFrom(this.fangWidthAdjust);
        this.baselineBox.boxStyle.setValue(0);
        this.baselineBox.orientation.connectFrom(this.orientation);
        this.baselineBox.earlyStart.connectFrom(this.baselineStart);
        this.baselineBox.earlyFinish.connectFrom(this.baselineFinish);
        this.baselineBox.lateStart.connectFrom(this.baselineStart);
        this.baselineBox.lateFinish.connectFrom(this.baselineFinish);
        this.baselineBox.criticalColor.connectFrom(this.baselineColor);
        this.baselineBox.criticalFillStyle.connectFrom(this.baselineFillStyle);
        this.baselineBox.outlineColor.connectFrom(this.outlineColor);
        this.baselineBox.fangWidthAdjust.connectFrom(this.fangWidthAdjust);
    }

    @Override
    public void init(AInitAction initAction) {
        this.removeAllElements();
        this.ganttSize = 0;
        if (this.earlyStart.isConnected()) {
            if (!this.lateStart.isConnected()) {
                this.ganttBox.lateStart.connectFrom(this.earlyStart);
                this.ganttBox.lateFinish.connectFrom(this.earlyFinish);
            } else {
                this.ganttBox.lateStart.connectFrom(this.lateStart);
                this.ganttBox.lateFinish.connectFrom(this.lateFinish);
            }
            this.ganttSize = 1;
            this.addElement(this.ganttBox);
        }
        this.actualSize = 0;
        if (this.actualStart.isConnected()) {
            this.actualSize = 1;
            this.addElement(this.actualBox);
        }
        this.resourceSize = 0;
        if (this.resourceStart.isConnected()) {
            this.resourceSize = 1;
            this.addElement(this.resourceBox);
        }
        this.baselineSize = 0;
        if (this.baselineStart.isConnected()) {
            this.baselineSize = 1;
            this.addElement(this.baselineBox);
        }
        this.addElement(this.containBox);
        this.totalBoxSize = this.ganttSize + this.actualSize + this.resourceSize + this.baselineSize;
        super.init(initAction);
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        int ganttBoxStyle;
        int otherBoxStyle;
        int index = buildAction.getValueIndex();
        double thickness = this.boxThickness.getValue(index);
        int boxStyleValue = this.boxStyle.getValue(index);
        boolean isContained = this.contained.getValue(index);
        boolean fullSize = boxStyleValue == 3 && !isContained || boxStyleValue == 4 || boxStyleValue == 5;
        double boxThicknessValue = thickness / (double)(this.totalBoxSize + (fullSize ? 0 : 1));
        boolean thickGanttBox = boxStyleValue == 2 && !isContained;
        double adjustedGanttSize = this.ganttSize + (thickGanttBox ? 1 : 0);
        double adjustedActualSize = this.actualSize + (thickGanttBox && this.ganttSize == 0 ? 1 : 0);
        double adjustedResourceSize = this.resourceSize + (thickGanttBox && this.ganttSize == 0 && this.actualSize == 0 ? 1 : 0);
        double adjustedBaselineSize = this.baselineSize + (thickGanttBox && this.ganttSize == 0 && this.actualSize == 0 && this.resourceSize == 0 ? 1 : 0);
        double ganttSpace = boxThicknessValue * adjustedGanttSize;
        double actualSpace = boxThicknessValue * adjustedActualSize;
        double resourceSpace = boxThicknessValue * adjustedResourceSize;
        double baselineSpace = boxThicknessValue * adjustedBaselineSize;
        double containSpace = 0.0;
        double containedFangThickness = 0.0;
        int containBoxStyle = 0;
        int containFillStyle = -1;
        if (isContained) {
            containFillStyle = 0;
            if (boxStyleValue == 2 || boxStyleValue == 3) {
                containedFangThickness = boxThicknessValue;
                containBoxStyle = 1;
                boxStyleValue = 0;
            }
            containSpace = thickness - (fullSize ? 0.0 : boxThicknessValue) + containedFangThickness;
        }
        this.ganttBox.boxThickness.setValue(ganttSpace);
        this.actualBox.boxThickness.setValue(actualSpace);
        this.resourceBox.boxThickness.setValue(resourceSpace);
        this.baselineBox.boxThickness.setValue(baselineSpace);
        this.containBox.boxThickness.setValue(containSpace);
        if (this.orientation.getValue(index) == 1.0) {
            this.actualBox.transform.translateX.setValue(ganttSpace);
            this.resourceBox.transform.translateX.setValue(ganttSpace + actualSpace);
            this.baselineBox.transform.translateX.setValue(ganttSpace + actualSpace + resourceSpace);
        } else {
            this.actualBox.transform.translateY.setValue(ganttSpace);
            this.resourceBox.transform.translateY.setValue(ganttSpace + actualSpace);
            this.baselineBox.transform.translateY.setValue(ganttSpace + actualSpace + resourceSpace);
        }
        switch (boxStyleValue) {
            default: {
                otherBoxStyle = 0;
                ganttBoxStyle = 0;
                break;
            }
            case 1: 
            case 5: {
                otherBoxStyle = 2;
                ganttBoxStyle = 2;
                break;
            }
            case 3: {
                otherBoxStyle = 1;
                ganttBoxStyle = 1;
                break;
            }
            case 2: {
                ganttBoxStyle = 1;
                otherBoxStyle = 0;
            }
        }
        this.ganttBox.boxStyle.setValue(ganttBoxStyle);
        this.actualBox.boxStyle.setValue(otherBoxStyle);
        this.resourceBox.boxStyle.setValue(otherBoxStyle);
        this.baselineBox.boxStyle.setValue(otherBoxStyle);
        this.containBox.boxStyle.setValue(containBoxStyle);
        this.containBox.criticalFillStyle.setValue(containFillStyle);
        this.containBox.fangThickness.setValue(containedFangThickness);
        this.containBox.fangThicknessAdjust.setValue(true);
        this.containBox.orientation.setValue(this.orientation.getValue(index));
        this.containBox.earlyStart.setValue(this.earlyStart.getValue(index));
        this.containBox.earlyFinish.setValue(this.lateFinish.getValue(index));
        this.containBox.lateStart.setValue(this.earlyStart.getValue(index));
        this.containBox.lateFinish.setValue(this.lateFinish.getValue(index));
        this.containBox.outlineColor.setValue(this.outlineColor.getValue(index));
        this.containBox.fangWidthAdjust.setValue(this.fangWidthAdjust.getValue(index));
        super.render(buildAction);
    }
}

