/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.ABox;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;

public class Box
extends ABox {
    public static void drawBox(Channel channel, double sizeX, double sizeY, double sizeZ, Color color, Color edgeColor, int origin, boolean edgeOn, boolean fillOn) {
        Vec3d size = new Vec3d();
        Vec3d center = new Vec3d();
        size.x = sizeX;
        size.y = sizeY;
        size.z = sizeZ;
        if (origin != 0) {
            ABox.computeCenter(size.x, size.y, size.z, origin, center);
            channel.glTranslate(center.x, center.y, center.z);
        }
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getJXDFillStyle(fillOn, edgeOn));
        int boxDataIndex = 0;
        Vec3d p = boxData[boxDataIndex];
        channel.glBegin(2);
        for (int face = 0; face < 6; ++face) {
            p = boxData[boxDataIndex];
            channel.glNormal(size.x < 0.0 ? -p.x : p.x, size.y < 0.0 ? -p.y : p.y, size.z < 0.0 ? -p.z : p.z);
            ++boxDataIndex;
            for (int vertex = 0; vertex < 4; ++vertex) {
                p = boxData[boxDataIndex];
                channel.glVertex(p.x * size.x, p.y * size.y, p.z * size.z);
                ++boxDataIndex;
            }
            channel.glBound();
        }
        channel.glEnd();
        channel.glPopAttrib();
    }

    public Box() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Box.drawBox(ba.getChannel(), this.sizeX.getValue(index), this.sizeY.getValue(index), this.sizeZ.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.origin.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index));
    }
}

