/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk.jxd;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.vtk.AAxis;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AxisDetail;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.SelectDetail;
import com.sas.graphics.util.vtk.TextStyle;
import com.sas.graphics.util.vtk.TickMarkStyle;
import com.sas.graphics.util.vtk.jxd.BuildAction;
import com.sas.graphics.util.vtk.jxd.ComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.jxd.InitAction;
import com.sas.graphics.util.vtk.jxd.LineSegment;
import com.sas.graphics.util.vtk.jxd.RasterLabel;
import com.sas.graphics.util.vtk.jxd.Transform;
import java.awt.Color;
import java.awt.Font;
import java.util.Stack;

public abstract class Axis
extends AAxis {
    protected Channel channel;
    protected int justifyLabelH;
    protected int justifyLabelV;

    @Override
    protected abstract void setJustificationStyles();

    protected abstract void move2Origin();

    protected abstract double getDistance(int var1);

    public Axis() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        this.channel = ba.getChannel();
        this.constructAxis(ba.getValueIndex(), null);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        ComputeBoundingBoxAction bba = ComputeBoundingBoxAction.castComputeBoundingBoxAction(bBoxAction);
        this.channel = bba.getChannel();
        this.constructAxis(bba.getValueIndex(), bba.getElementBoundingBox());
    }

    protected void move2Origin(BoundingBox bbox) {
        if (bbox != null) {
            this.channel.glPushMatrix();
            this.channel.glLoadIdentity();
            this.move2Origin();
            double[] matrix = new double[16];
            this.channel.glGetMatrix(matrix);
            bbox.transform(matrix);
            this.channel.glPopMatrix();
        }
    }

    private void constructAxis(int obs, BoundingBox bbox) {
        double firstRowDepth;
        boolean rendering = bbox == null;
        double primarySign = this.primary ? 1.0 : -1.0;
        double incr = 0.0;
        double labelSpace = 0.0;
        double titleSpace = 0.0;
        double labelStaggerSpace = 0.0;
        double maxDepth = 0.0;
        Vec3d start = new Vec3d();
        Vec3d end = new Vec3d();
        double[] majorT = new double[2];
        double[] minorT = new double[2];
        maxDepth = firstRowDepth = this.processLabels();
        if (rendering) {
            this.channel.glPushName(new Integer(-1));
        }
        double mySize = this.getDistance(obs);
        this.channel.glPushMatrix();
        this.move2Origin();
        if (this.style.isAxisLineOn()) {
            this.orient(end, mySize, 0.0, 0.0);
            this.drawAxisLine(0.0, 0.0, 0.0, end.x, end.y, end.z, this.style.getAxisLineColor(), this.style.getLineWidth(), bbox);
        }
        this.channel.glSelect2DFont(this.style.getLabelStyle().getFont());
        double labelHeight = this.channel.glGetTextHeight();
        if (this.style.isMajorTickMarksOn() || this.style.isLabelsOn() || this.style.isMinorTickMarksOn()) {
            int i;
            double majorTickLength = this.style.getMajorTickStyle().getLength() * labelHeight;
            double minorTickLength = this.style.getMinorTickStyle().getLength() * labelHeight;
            labelSpace = this.style.getLabelSpace() * labelHeight;
            labelStaggerSpace = this.style.getLabelStaggerSpace() * labelHeight;
            if (this.style.isMajorTickMarksOn()) {
                this.positionTicMark(this.style.getMajorTickStyle(), majorTickLength, majorT);
            }
            if (this.style.isMinorTickMarksOn()) {
                this.positionTicMark(this.style.getMinorTickStyle(), minorTickLength, minorT);
            }
            double longestLabelWidth = Double.MIN_VALUE;
            for (i = 0; i < this.processedLabels.size(); ++i) {
                longestLabelWidth = Math.max(longestLabelWidth, this.channel.glGetTextWidth(((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).theLabel));
            }
            for (i = 0; i < this.processedLabels.size(); ++i) {
                AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
                if (this.orientation == 1) {
                    la.space *= this.channel.glGetTextWidth(((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).theLabel) / longestLabelWidth;
                }
                if (rendering) {
                    this.channel.glPushName(new Integer(la.observation));
                }
                if (this.style.isMajorTickMarksOn()) {
                    this.orient(start, la.offset, majorT[0], 0.0);
                    this.orient(end, la.offset, majorT[1], 0.0);
                    this.drawMajorTickMark(start.x, start.y, start.z, end.x, end.y, end.z, this.style.getMajorTickStyle().getColor(), this.style.getMajorTickStyle().getLineWidth(), bbox);
                }
                if (this.style.isLabelsOn() && !la.drop) {
                    double labelTop;
                    double whiteSpace;
                    if (!la.adjacentToAxis) {
                        whiteSpace = labelSpace + firstRowDepth + labelStaggerSpace;
                        labelTop = majorT[1] - whiteSpace * primarySign;
                    } else {
                        whiteSpace = labelSpace;
                        labelTop = majorT[1] - whiteSpace * primarySign;
                    }
                    this.justify(la, this.style.getLabelStyle());
                    this.orient(start, la.offset, labelTop, 0.0);
                    this.drawLabel(la, start, this.style.getLabelStyle(), bbox);
                    labelTop = Math.abs(labelTop);
                    maxDepth = Math.max(maxDepth, labelTop += this.labelOrientation == 2 ? la.height : la.width);
                }
                if (rendering) {
                    this.channel.glPopName();
                }
                if (!this.style.isMinorTickMarksOn() || i <= 0) continue;
                double lastMajor = ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)(i - 1))).offset;
                int ticCount = this.style.getMinorTickStyle().getMinorTickCount();
                for (int t = 0; t < ticCount; ++t) {
                    double ratio = (double)(t + 1) / (double)(ticCount + 1);
                    double offset = lastMajor + (la.offset - lastMajor) * ratio;
                    this.orient(start, offset, minorT[0], 0.0);
                    this.orient(end, offset, minorT[1], 0.0);
                    this.drawMinorTickMark(start.x, start.y, start.z, end.x, end.y, end.z, this.style.getMinorTickStyle().getColor(), this.style.getMinorTickStyle().getLineWidth(), bbox);
                }
            }
        }
        if (this.style.isTitleOn()) {
            try {
                String theTitle = this.title.getValue(obs);
                titleSpace = this.style.getTitleSpace() * labelHeight;
                if (theTitle != null) {
                    end.set(this.getLineOffset(), -(maxDepth + titleSpace) * primarySign, 0.0);
                    this.positionTitle(end, mySize);
                    this.drawTitle(theTitle, end.x, end.y, end.z, this.style.getTitleStyle(), bbox);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.channel.glPopMatrix();
        this.move2Origin(bbox);
        if (rendering) {
            this.channel.glPopName();
        }
    }

    private double processLabels() {
        double firstRowDepth = 0.0;
        boolean needWordbreak = this.style.getLabelStyle().isSplit();
        Font font = this.style.getLabelStyle().getFont();
        this.channel.glSelect2DFont(font);
        this.sortLabelsByOffset();
        if (this.style.getLabelStyle().isStagger()) {
            this.findAvailableSpace(1, false);
        }
        for (int i = 0; i < this.processedLabels.size(); ++i) {
            AAxis.LabelAlignment la = (AAxis.LabelAlignment)this.processedLabels.elementAt(i);
            try {
                String thisLabel = this.labels.getValue(la.observation);
                la.theLabel = needWordbreak ? RasterLabel.wordBreak(this.channel, font, thisLabel, 1.0) : thisLabel;
            }
            catch (MissingValueException mve) {
                la.theLabel = "";
            }
            la.width = this.channel.glGetTextWidth(la.theLabel);
            la.height = this.channel.glGetTextHeight(la.theLabel);
            if (!la.adjacentToAxis) continue;
            double depth = this.orientation == 2 ? la.width : la.height;
            firstRowDepth = Math.max(firstRowDepth, depth);
        }
        int skip = this.dropOn ? this.dropModValue : 1;
        this.findAvailableSpace(skip, this.doLabelsOverlap());
        return firstRowDepth;
    }

    protected void positionTitle(Vec3d titleOrigin, double length) {
        double positionOffset = 0.0;
        switch (this.titlePosition) {
            case 0: {
                break;
            }
            default: {
                positionOffset = length / 2.0;
                break;
            }
            case 2: {
                positionOffset = length;
            }
        }
        this.orient(titleOrigin, titleOrigin.x + positionOffset, titleOrigin.y, titleOrigin.z);
    }

    protected void positionTicMark(TickMarkStyle tmStyle, double length, double[] pos) {
        double primarySign = this.primary ? 1.0 : -1.0;
        switch (tmStyle.getTickMarkJustification()) {
            default: {
                pos[0] = 0.0;
                break;
            }
            case 0: {
                pos[0] = primarySign * length;
                break;
            }
            case 2: {
                pos[0] = primarySign * length / 2.0;
            }
        }
        pos[1] = pos[0] - length * primarySign;
    }

    public int getLabelCount(Channel channel, double length) {
        new InitAction(channel).apply(this);
        this.processLabels();
        int i = 0;
        for (double maxWidth = 0.0; i < this.processedLabels.size() && maxWidth <= length; maxWidth += ((AAxis.LabelAlignment)this.processedLabels.elementAt((int)i)).width, ++i) {
        }
        return i;
    }

    protected void drawAxisLine(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, BoundingBox bbox) {
        this.drawLine(beginX, beginY, beginZ, endX, endY, endZ, color, width, bbox);
    }

    protected void drawLine(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, BoundingBox bbox) {
        if (bbox == null) {
            LineSegment.drawLineSegment(this.channel, beginX, beginY, beginZ, endX, endY, endZ, color, width, 0, 0);
        } else {
            Vec3d v = new Vec3d(beginX, beginY, beginZ);
            bbox.union(v);
            v.set(endX, endY, endZ);
            bbox.union(v);
        }
    }

    public double getLineOffset() {
        return 0.0;
    }

    @Override
    protected void setLabelStyle(TextStyle style) {
        this.channel.glSelect2DFont(style.getFont());
    }

    protected void justify(AAxis.LabelAlignment alignment, TextStyle style) {
        this.justifyLabelH = style.getHorizontalJustification();
        this.justifyLabelV = style.getVerticalJustification();
        if (!this.primary) {
            if (this.labelOrientation != 2 && this.justifyLabelH != 1) {
                this.justifyLabelH = this.justifyLabelH == 2 ? 0 : 2;
            }
            if (this.labelOrientation == 2 && this.justifyLabelV != 1) {
                this.justifyLabelV = this.justifyLabelV == 0 ? 3 : 0;
            }
        }
    }

    @Override
    protected void drawLabel(int obs, String aLabel, double atX, double atY, double atZ, TextStyle style, Color color, double maxWidth, double maxHeight, BoundingBox bbox) {
        double fit2Height;
        double fit2Width = maxWidth > 0.0 ? maxWidth : Double.POSITIVE_INFINITY;
        double d = fit2Height = maxHeight > 0.0 ? maxHeight : Double.POSITIVE_INFINITY;
        if (bbox == null) {
            this.channel.glLoadName(new Integer(obs));
            this.channel.glPushMatrix();
            this.channel.glTranslate(atX, atY, atZ);
            RasterLabel.drawRasterLabel(this.channel, aLabel, color, style.getAngle(), this.justifyLabelH, this.justifyLabelV, style.isFit(), style.isTruncate(), fit2Width, fit2Height, style.getFont(), null);
            this.channel.glPopMatrix();
        } else {
            int angle;
            switch ((int)style.getAngle()) {
                default: {
                    angle = 0;
                    break;
                }
                case 90: {
                    angle = 90;
                    break;
                }
                case 270: {
                    angle = 270;
                }
            }
            Bbox jxdBox = new Bbox();
            this.channel.glSelect2DFont(style.getFont());
            this.channel.glAlignment(this.justifyLabelH, this.justifyLabelV);
            this.channel.glGetText2DBbox(aLabel, atX, atY, atZ, angle, jxdBox);
            Vec3d corner = new Vec3d(jxdBox.xmin, jxdBox.ymin, jxdBox.zmin);
            bbox.union(corner);
            corner.set(jxdBox.xmax, jxdBox.ymax, jxdBox.zmax);
            bbox.union(corner);
        }
    }

    @Override
    protected void drawMajorTickMark(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, BoundingBox bbox) {
        this.drawLine(beginX, beginY, beginZ, endX, endY, endZ, color, width, bbox);
    }

    @Override
    protected void drawMinorTickMark(double beginX, double beginY, double beginZ, double endX, double endY, double endZ, Color color, int width, BoundingBox bbox) {
        this.drawLine(beginX, beginY, beginZ, endX, endY, endZ, color, width, bbox);
    }

    @Override
    public SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int detailIndex = startIndex + entryLength - 1;
        Integer labelIndex = (Integer)nameStack.elementAt(detailIndex);
        if (labelIndex < 0) {
            return null;
        }
        AxisDetail axisDetail = new AxisDetail();
        axisDetail.setLabelIndex(labelIndex);
        return axisDetail;
    }
}

