/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Expression;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import com.sas.graphics.util.vtk.VariableProcessor;
import java.util.StringTokenizer;
import java.util.Vector;

class WhereProcessor {
    protected int valueCount;
    private Vector variables;
    private Vector whereVariables = new Vector();
    private int whereVariableCount;
    private Vector skipTable = new Vector();
    private int skipCount;
    private int keepIndex = 0;
    private boolean lastIndexKept = false;
    private WhereExpressionEvaluator whereExpressionEvaluator = new WhereExpressionEvaluator();

    public void setExpression(String expression) {
        if (expression == null) {
            expression = "";
        }
        this.whereExpressionEvaluator.setExpression(expression);
    }

    public String getExpression() {
        return this.whereExpressionEvaluator.getExpression();
    }

    public int process(Vector allVariables, int aValueCount) {
        VariableProcessor.VEntry ve;
        int i;
        this.variables = allVariables;
        this.valueCount = aValueCount;
        this.whereVariableCount = this.whereVariables.size();
        this.skipCount = 0;
        this.keepIndex = 0;
        this.lastIndexKept = false;
        int variableCount = this.variables.size();
        this.skipTable.removeAllElements();
        if (this.whereExpressionEvaluator.isExpressionEmpty() || !this.whereExpressionEvaluator.parse(this.variables)) {
            return aValueCount;
        }
        for (i = 0; i < variableCount; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (!ve.isGroup) continue;
            ve.variable.uniqueValueAddBegin();
        }
        for (i = 0; i < this.valueCount; ++i) {
            if (!this.keepObservation(i)) continue;
            for (int j = 0; j < variableCount; ++j) {
                ve = (VariableProcessor.VEntry)this.variables.elementAt(j);
                if (!ve.isGroup) continue;
                ve.variable.addUniqueValue(i);
            }
        }
        for (i = 0; i < variableCount; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (!ve.isGroup) continue;
            ve.variable.uniqueValueAddEnd();
        }
        this.valueCount -= this.skipCount;
        for (i = 0; i < variableCount; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                NumericSkipPipe np = new NumericSkipPipe(nv.getProcessedValuePipe());
                nv.setProcessedValuePipe(np, this.valueCount);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            StringSkipPipe sp = new StringSkipPipe(sv.getProcessedValuePipe());
            sv.setProcessedValuePipe(sp, this.valueCount);
        }
        return this.valueCount;
    }

    public boolean keepObservation(int valueIndex) {
        boolean keep = this.whereExpressionEvaluator.evaluateExpression(valueIndex);
        if (keep) {
            ++this.keepIndex;
            this.lastIndexKept = true;
        } else {
            if (this.lastIndexKept) {
                this.skipTable.addElement(new SkipEntry(this.keepIndex - 1, this.skipCount));
            }
            ++this.skipCount;
            this.lastIndexKept = false;
        }
        if (this.lastIndexKept) {
            this.skipTable.addElement(new SkipEntry(this.keepIndex - 1, this.skipCount));
        }
        return keep;
    }

    public int getIndex(int index) {
        int lower = 0;
        int size = this.skipTable.size();
        int upper = size - 1;
        int middle = 0;
        int resultIndex = index;
        while (lower <= upper) {
            middle = (lower + upper) / 2;
            SkipEntry entry = (SkipEntry)this.skipTable.elementAt(middle);
            if (index == entry.index) {
                resultIndex += entry.offset;
                break;
            }
            if (index < entry.index) {
                if (middle - 1 < 0) {
                    resultIndex += entry.offset;
                    break;
                }
                SkipEntry entry2 = (SkipEntry)this.skipTable.elementAt(middle - 1);
                if (index > entry2.index) {
                    resultIndex += entry.offset;
                    break;
                }
                upper = middle - 1;
                continue;
            }
            lower = middle + 1;
        }
        return resultIndex;
    }

    public boolean isExpressionValid(Vector variables) {
        return this.whereExpressionEvaluator.parse(variables);
    }

    private static class WhereExpressionEvaluator
    extends Expression {
        private WhereExpressionEvaluator() {
        }

        public boolean isExpressionEmpty() {
            String e = super.getExpression();
            if (e == null) {
                return true;
            }
            StringTokenizer tokenizer = new StringTokenizer(e);
            return !tokenizer.hasMoreTokens();
        }

        public boolean parse(Vector variables) {
            if (this.isExpressionEmpty()) {
                return true;
            }
            this.removeOperands();
            int n = variables.size();
            for (int i = 0; i < n; ++i) {
                VariableProcessor.VEntry ve = (VariableProcessor.VEntry)variables.elementAt(i);
                if (ve.variable instanceof NumericVariable) {
                    this.addOperand(ve.variable.getName(), (NumericVariable)ve.variable, true);
                    continue;
                }
                this.addOperand(ve.variable.getName(), (StringVariable)ve.variable, true);
            }
            try {
                super.parse();
            }
            catch (VTKRuntimeException exception) {
                Debug.println((String)exception.getMessage());
                return false;
            }
            if (this.getEvaluationType() != 1) {
                Debug.println((String)"Where expression must yield boolean.");
                return false;
            }
            return true;
        }

        public boolean evaluateExpression(int index) {
            try {
                Expression.MultiTypedValue result = this.evaluate(index);
                return result.booleanValue;
            }
            catch (MissingValueException e) {
                Debug.println((String)"Internal error: where expression resolved to a missing value");
                return true;
            }
        }
    }

    private class StringSkipPipe
    extends SkipPipe
    implements StringPipe {
        private StringPipe rawValuePipe;

        public StringSkipPipe(StringPipe aRawValuePipe) {
            super(aRawValuePipe);
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            return this.rawValuePipe.getValue(this.getSkipIndex(i));
        }
    }

    private class NumericSkipPipe
    extends SkipPipe
    implements NumericPipe {
        private NumericPipe rawValuePipe;

        public NumericSkipPipe(NumericPipe aRawValuePipe) {
            super(aRawValuePipe);
            this.rawValuePipe = aRawValuePipe;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            return this.rawValuePipe.getValue(this.getSkipIndex(i));
        }
    }

    private class SkipPipe
    implements Pipe {
        private Pipe rawValue;

        public SkipPipe(Pipe aRawValue) {
            this.rawValue = aRawValue;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(WhereProcessor.this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        public int getSkipIndex(int i) {
            return WhereProcessor.this.getIndex(i);
        }
    }

    private class SkipEntry {
        public int offset;
        public int index;

        public SkipEntry(int anIndex, int anOffset) {
            this.index = anIndex;
            this.offset = anOffset;
        }
    }
}

