/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.GroupProcessor;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.OrderProcessor;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.Variable;
import com.sas.graphics.util.vtk.WhereProcessor;
import java.util.Vector;

public class VariableProcessor
implements Pipe {
    public static final int ORDER_FORWARD = 0;
    public static final int ORDER_REVERSE = 1;
    private Vector variables = new Vector();
    private int rawValueCount;
    private boolean modified;
    private boolean initInProgress;
    private OrderProcessor orderProcessor = new OrderProcessor();
    private WhereProcessor whereProcessor = new WhereProcessor();
    private GroupProcessor groupProcessor = new GroupProcessor();
    private Vector groupVariables = new Vector();
    public final IntegerPipe category;
    private StringBuffer dumpBuffer;

    public VariableProcessor() {
        this.category = this.groupProcessor.category;
        this.dumpBuffer = new StringBuffer(100);
        this.initInProgress = false;
        this.modified = false;
    }

    private boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean trueOrFalse) {
        this.modified = trueOrFalse;
        this.setVariablesModified(trueOrFalse);
    }

    @Override
    public Formatter getFormatter() {
        return null;
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    @Override
    public void init(AInitAction initAction) {
        if (this.initInProgress) {
            return;
        }
        this.initInProgress = true;
        if (!this.isModified() && !this.areVariablesModified()) {
            this.initInProgress = false;
            return;
        }
        this.unProcessVariables();
        this.initAllVariables(initAction);
        this.rawValueCount = this.orderProcessor.process(this.variables, this.rawValueCount);
        this.rawValueCount = this.whereProcessor.process(this.variables, this.rawValueCount);
        this.groupProcessor.process(this.variables, this.rawValueCount);
        this.initInProgress = false;
        this.setModified(false);
        this.setVariablesModified(false);
    }

    public boolean isWhereExpressionValid() {
        return this.whereProcessor.isExpressionValid(this.variables);
    }

    private boolean areVariablesModified() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (!ve.variable.isModified()) continue;
            return true;
        }
        return false;
    }

    private void setVariablesModified(boolean trueOrFalse) {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            ve.variable.setModified(trueOrFalse);
        }
    }

    private void unProcessVariables() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                nv.setProcessedValuePipe(null, 0);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            sv.setProcessedValuePipe(null, 0);
        }
    }

    public void addVariable(Variable variable) {
        this.addVariable(variable, 6);
    }

    public void addVariable(Variable variable, int statistic) {
        int index = this.findVariable(variable);
        if (index < 0) {
            this.addVariableEntry(variable, statistic);
        } else {
            VEntry ve = (VEntry)this.variables.elementAt(index);
            ve.statistic = statistic;
            this.groupVariables.removeElement(variable);
        }
    }

    public void removeAllVariables() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            this.removeVariableProcessor(ve.variable);
        }
        this.variables.removeAllElements();
        this.groupVariables.removeAllElements();
        this.setModified(true);
    }

    public void removeVariable(Variable variable) {
        int i = this.findVariable(variable);
        if (i >= 0) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.isGroup) {
                this.groupVariables.removeElement(ve.variable);
            }
            this.variables.removeElementAt(i);
            this.removeVariableProcessor(ve.variable);
        }
        this.setModified(true);
    }

    private void removeVariableProcessor(Variable variable) {
        variable.setVariableProcessor(null);
        variable.setModified(true);
        if (variable instanceof NumericVariable) {
            NumericVariable nv = (NumericVariable)variable;
            nv.setProcessedValuePipe(null, 0);
        } else {
            StringVariable sv = (StringVariable)variable;
            sv.setProcessedValuePipe(null, 0);
        }
    }

    public VariableEntry[] getVariables() {
        int n = this.variables.size();
        VariableEntry[] result = new VariableEntry[n];
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            result[i] = new VariableEntry();
            result[i].variable = ve.variable;
            result[i].statistic = ve.statistic;
            result[i].isGroup = ve.isGroup;
        }
        return result;
    }

    public int getVariableCount() {
        return this.variables.size();
    }

    private VEntry addVariableEntry(Variable variable, int statistic) {
        VEntry ve = new VEntry();
        ve.variable = variable;
        ve.statistic = statistic;
        if (ve.variable instanceof StringVariable && statistic != 0 && statistic != 12) {
            ve.statistic = 0;
        }
        this.variables.addElement(ve);
        ve.isGroup = false;
        variable.setModified(true);
        variable.setVariableProcessor(this);
        this.setModified(true);
        return ve;
    }

    private int findVariable(Variable variable) {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.variable != variable) continue;
            return i;
        }
        return -1;
    }

    public void setOrder(int order) {
        this.orderProcessor.setOrder(order);
        this.setModified(true);
    }

    public void setWhereExpression(String expression) {
        this.whereProcessor.setExpression(expression);
        this.setModified(true);
    }

    public String getWhereExpression() {
        return this.whereProcessor.getExpression();
    }

    public void addGroupVariable(Variable groupVariable) {
        int index = this.findVariable(groupVariable);
        VEntry ve = index >= 0 ? (VEntry)this.variables.elementAt(index) : this.addVariableEntry(groupVariable, 0);
        ve.isGroup = true;
        if (!this.groupVariables.contains(groupVariable)) {
            this.groupVariables.addElement(groupVariable);
        }
    }

    public int getGroupVariableCount() {
        return this.groupVariables.size();
    }

    private void initAllVariables(AInitAction initAction) {
        initAction.pushValueCount();
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VEntry ve = (VEntry)this.variables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                nv.value.init(initAction);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            sv.value.init(initAction);
        }
        this.rawValueCount = initAction.getValueCount();
        initAction.popValueCount();
    }

    public void cacheData() {
        int nVariables = this.variables.size();
        if (nVariables > 0) {
            int i;
            VEntry ve = (VEntry)this.variables.elementAt(0);
            int nObs = ve.variable.getRawValueCount();
            nVariables = this.variables.size();
            for (i = 0; i < nVariables; ++i) {
                ve = (VEntry)this.variables.elementAt(i);
                if (ve.variable.getRawValueCount() != nObs) {
                    throw new RuntimeException();
                }
                ve.variable.beginDataCache();
            }
            for (i = 0; i < nObs; ++i) {
                for (int j = 0; j < nVariables; ++j) {
                    ve = (VEntry)this.variables.elementAt(j);
                    ve.variable.cacheDataAt(i);
                }
            }
            for (i = 0; i < nVariables; ++i) {
                ve = (VEntry)this.variables.elementAt(i);
                ve.variable.endDataCache();
                ve.variable.setModified(true);
            }
        }
    }

    public int getIndexWithoutWhereProcessing(int index) {
        return this.whereProcessor.getIndex(index);
    }

    public void dump() {
        int numberOfVariables = this.variables.size();
        if (numberOfVariables > 0) {
            Variable v = ((VEntry)this.variables.elementAt((int)0)).variable;
            int n = v.getValueCount();
            for (int i = 0; i < n; ++i) {
                this.dumpBuffer.setLength(0);
                for (int j = 0; j < numberOfVariables; ++j) {
                    v = ((VEntry)this.variables.elementAt((int)j)).variable;
                    try {
                        if (v instanceof NumericVariable) {
                            NumericVariable nv = (NumericVariable)v;
                            this.dumpBuffer.append(nv.value.getValue(i) + " ");
                            continue;
                        }
                        StringVariable sv = (StringVariable)v;
                        this.dumpBuffer.append(sv.value.getValue(i) + " ");
                        continue;
                    }
                    catch (MissingValueException e) {
                        this.dumpBuffer.append(" . ");
                    }
                }
                Debug.println((String)this.dumpBuffer.toString());
            }
        }
    }

    public static class VariableEntry {
        public Variable variable;
        public int statistic;
        public boolean isGroup;
    }

    public static class VEntry {
        public Variable variable;
        public boolean isGroup;
        public int statistic;
        public int responseIndex;
        public int uniqueValueCount;
        public IntegerPipe category;
    }
}

