/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Action;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.PipedVector;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.VariableException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Variable {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    private static int nameCounter = 0;
    protected boolean calNumUniqueValues = true;
    private Formatter formatter = Formatter.defaultFormatter;
    private VTKFormat format = null;
    protected static String defaultName = new String("variable");
    private String name;
    private int rawValueCount;
    private int processedValueCount;
    private int uniqueValueCount;
    private boolean modified = false;
    private boolean connected = false;
    private int sortType;
    private Pipe variableProcessor = null;
    private long modifiedTime = Action.getTimeStamp();

    public Variable() {
        this.setName(defaultName + nameCounter++);
    }

    public static int sortStringToInt(String sortType) {
        int result = 2;
        String name = sortType.toUpperCase();
        if (name.equals("NONE")) {
            result = 0;
        } else if (name.equals("ASCENDING")) {
            result = 1;
        }
        return result;
    }

    protected abstract Hashtable getCategoryHashtable();

    public abstract boolean isMissing(int var1);

    void beginDataCache() {
    }

    void endDataCache() {
    }

    protected static void clearDataCache(PipedVector cache) {
        if (cache != null) {
            cache.removeAllValues();
        }
    }

    void cacheDataAt(int i) {
    }

    protected static boolean isDataCached(PipedVector cache) {
        return cache != null && cache.size() > 0;
    }

    public void setUniqueValueSort(int aSortType) {
        this.sortType = aSortType;
        this.setModified(true);
    }

    public int getUniqueValueSort() {
        return this.sortType;
    }

    public void setModified(boolean trueOrFalse) {
        this.modified = trueOrFalse;
        if (this.modified) {
            this.calNumUniqueValues = true;
            this.modifiedTime = Action.getTimeStamp();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    protected abstract void addUniqueValue(int var1);

    protected abstract IntegerPipe getCategory();

    public void setName(String aName) {
        if (aName == null) {
            throw new IllegalArgumentException("Variable names must be non-null.");
        }
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    protected void setRawValueCount(int valueCount) {
        this.rawValueCount = valueCount;
    }

    protected void setProcessedValueCount(int valueCount) {
        this.processedValueCount = valueCount;
    }

    protected abstract int getRawValueCount();

    public int getValueCount() {
        if (this.modified && this.variableProcessor != null) {
            this.variableProcessor.init(new AInitAction(null));
        }
        if (this.processedValueCount == -1) {
            return this.getRawValueCount();
        }
        return this.processedValueCount;
    }

    protected void connectFrom() {
        this.connected = true;
        this.setModified(true);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() {
        this.connected = false;
        this.rawValueCount = 0;
        this.processedValueCount = -1;
        this.uniqueValueCount = 0;
        this.setModified(true);
    }

    public int getUniqueValueCount() {
        this.uniqueValueCount = this.buildCategoryTable();
        this.buildUniqueValueVector();
        return this.uniqueValueCount;
    }

    protected void setUniqueValueCount(int valueCount) {
        this.uniqueValueCount = valueCount;
    }

    protected abstract int buildUniqueValueVector();

    protected int buildCategoryTable() {
        if (this.calNumUniqueValues) {
            this.uniqueValueAddBegin();
            int n = this.getValueCount();
            for (int i = 0; i < n; ++i) {
                this.addUniqueValue(i);
            }
            this.uniqueValueAddEnd();
        }
        return this.getCategoryHashtable().size();
    }

    protected void uniqueValueAddBegin() {
        Hashtable categoryTable = this.getCategoryHashtable();
        categoryTable.clear();
    }

    protected void uniqueValueAddEnd() {
        this.sortUniqueValues();
        this.calNumUniqueValues = false;
    }

    private void sortUniqueValues() {
        int i;
        int n;
        if (this.sortType == 0) {
            return;
        }
        Hashtable hashtable = this.getCategoryHashtable();
        Vector sorted = new Vector();
        Enumeration e = hashtable.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            boolean done = false;
            n = sorted.size();
            i = 0;
            while (!done && i < n) {
                Object o2 = sorted.elementAt(i);
                if (o instanceof MissingValues) {
                    MissingValues mv = (MissingValues)o;
                    if (o2 instanceof MissingValues) {
                        MissingValues mv2 = (MissingValues)o2;
                        done = mv.getIndex() < mv2.getIndex();
                    } else {
                        done = true;
                    }
                } else if (o instanceof ReusableDouble) {
                    ReusableDouble d = (ReusableDouble)o;
                    done = o2 instanceof MissingValues ? false : d.value < ((ReusableDouble)o2).value;
                } else if (o instanceof String) {
                    String s = (String)o;
                    done = o2 instanceof MissingValues ? false : s.compareTo((String)o2) < 0;
                } else {
                    throw new Error("Internal error: can't sort an unknown type");
                }
                if (this.sortType != 1) {
                    boolean bl = done = !done;
                }
                if (done) continue;
                ++i;
            }
            sorted.insertElementAt(o, i);
        }
        n = sorted.size();
        hashtable.clear();
        for (i = 0; i < n; ++i) {
            hashtable.put(sorted.elementAt(i), new Integer(i));
        }
    }

    public void reset(AResetAction resetAction) {
        if (!this.isConnected()) {
            throw new VariableException("Attempt to reset a variable that is not connected to data.");
        }
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public VTKFormat getFormat() {
        return this.format;
    }

    public void setFormat(VTKFormat format) {
        this.formatter = new Formatter(format);
        this.format = format;
        this.setModified(true);
    }

    protected void init(AInitAction initAction) {
        if (!this.isConnected()) {
            throw new VariableException("Attempt to initialize a variable that is not connected to data.");
        }
        if (this.variableProcessor != null) {
            this.variableProcessor.init(initAction);
        }
        this.setModified(false);
        initAction.setDataChangedTime(this.modifiedTime);
    }

    protected void setVariableProcessor(Pipe aVariableProcessor) {
        this.variableProcessor = aVariableProcessor;
        this.setModified(true);
    }
}

