/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.IntegerPipeSwitcher;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringProperty;
import com.sas.graphics.util.vtk.StringToNumericMap;
import com.sas.graphics.util.vtk.ValueMap;

public class StringToNumericMapper
extends NumericMapper {
    private StringToNumericMap map;
    public final StringProperty input = new StringProperty(this, true);
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher();
    public final IntegerPipe category = this.categorySwitcher;

    public StringToNumericMapper() {
        StringToNumericMap m = new StringToNumericMap();
        m.addStringPipe(this.input);
        this.setMap(m);
    }

    public void setMap(StringToNumericMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
        this.labelSwitcher.connectFrom(map.label);
        this.categorySwitcher.connectFrom(map.category);
    }

    public void shareMap(StringToNumericMapper mapper) {
        this.map = mapper.map;
    }

    @Override
    protected ValueMap getValueMap() {
        return this.map;
    }

    @Override
    public double getValue(int i) throws MissingValueException {
        String s;
        try {
            s = this.input.getValue(i);
        }
        catch (MissingValueException e) {
            if (this.map.isReplaceMissingValues()) {
                s = this.getMissingValueLabel(e.getMissingValue());
            }
            throw e;
        }
        double d = this.map.getValue(s);
        return d;
    }

    public String[] getInverseValues(double lowerBound, double upperBound) {
        return this.map.getInverseValues(lowerBound, upperBound);
    }

    public double getOutputMin() {
        return this.map.getOutputMin();
    }

    public double getOutputMax() {
        return this.map.getOutputMax();
    }

    public double getStrideValue() {
        return this.map.getStrideValue();
    }

    public double getStartValue() {
        return this.map.getStartValue();
    }

    public void setStrideValue(double value) {
        this.map.setStrideValue(value);
    }

    public void setStartValue(double value) {
        this.map.setStartValue(value);
    }

    public void addStringPipe(StringPipe pipe) {
        this.map.addStringPipe(pipe);
    }

    public void removeAllStringPipes() {
        this.map.removeAllStringPipes();
    }

    public void removeStringPipe(StringPipe pipe) {
        this.map.removeStringPipe(pipe);
    }

    public int getStringPipeCount() {
        return this.map.getStringPipeCount();
    }

    public StringPipe getStringPipe(int i) {
        return this.map.getStringPipe(i);
    }

    public void setSortType(int sortType) {
        this.map.setSortType(sortType);
    }

    public int getSortType() {
        return this.map.getSortType();
    }

    public int getUniqueValueCount() {
        return this.map.getUniqueValueCount();
    }

    public void setReplaceMissingValues(boolean trueOrFalse) {
        this.map.getUniqueValueCount();
    }

    public boolean isReplaceMissingValues() {
        return this.map.isReplaceMissingValues();
    }
}

