/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.ColorMapper;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringProperty;
import com.sas.graphics.util.vtk.StringToColorMap;
import com.sas.graphics.util.vtk.ValueMap;
import java.awt.Color;

public class StringToColorMapper
extends ColorMapper {
    private StringToColorMap map;
    public final StringProperty input = new StringProperty(this, true);

    public StringToColorMapper() {
        StringToColorMap defaultMap = new StringToColorMap();
        defaultMap.addStringPipe(this.input);
        this.setMap(defaultMap);
    }

    public void setMap(StringToColorMap map) {
        if (map == null) {
            throw new RuntimeException("null map");
        }
        this.map = map;
        map.setOwner(this);
        this.uniqueValueSwitcher.connectFrom(map.uniqueValue);
        this.labelSwitcher.connectFrom(map.label);
    }

    @Override
    public ValueMap getValueMap() {
        return this.map;
    }

    public void shareMap(StringToColorMapper mapper) {
        this.map = mapper.map;
    }

    @Override
    public Color getValue(int index) throws MissingValueException {
        return this.map.getValue(index, this.input);
    }

    public void add(String key, Color value) {
        this.map.add(key, value);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void removeAll() {
        this.map.removeAll();
    }

    @Override
    public void setMissingReplacement(Color c) {
        this.map.setMissingReplacement(c);
    }

    @Override
    public void setMissingReplacement(Color c, MissingValues mv) {
        this.map.setMissingReplacement(c, mv);
    }

    @Override
    public Color getMissingReplacement() {
        return this.map.getMissingReplacement();
    }

    @Override
    public Color getMissingReplacement(MissingValues mv) {
        return this.map.getMissingReplacement(mv);
    }

    public void setReplaceMissingValues(boolean b) {
        this.map.setReplaceMissingValues(b);
    }

    public void setReplaceMissingValues(boolean b, MissingValues mv) {
        this.map.setReplaceMissingValues(b, mv);
    }

    public boolean isReplaceMissingValues() {
        return this.map.isReplaceMissingValues();
    }

    public boolean isLabelMissingValues() {
        return this.map.isLabelMissingValues();
    }

    public void setLabelMissingValues(boolean b) {
        this.map.setLabelMissingValues(b);
    }

    public void setLabelMissingValues(boolean b, MissingValues mv) {
        this.map.setLabelMissingValues(b, mv);
    }
}

