/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ColorMap;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.IntegerPipeSwitcher;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.Sort;
import com.sas.graphics.util.vtk.StringHashtable;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVector;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

public class StringToColorMap
extends ColorMap {
    private Hashtable table;
    private Hashtable gtable;
    private Hashtable ttable;
    private Vector stringPipes = new Vector();
    private int sortType;
    private StringVector rawLabels;
    private StringVector combinedLabels = new StringVector();
    private StringHashtable combinedLabelsToCategory = new StringHashtable();
    private StringHashtable valueToCategoryTable;
    private IntegerPipeSwitcher categorySwitcher = new IntegerPipeSwitcher(this);
    public final IntegerPipe category = this.categorySwitcher;

    public StringToColorMap() {
        this.table = new Hashtable(101, 0.85f);
        this.gtable = new Hashtable(101, 0.85f);
        this.categorySwitcher.setOwner(this);
    }

    public StringToColorMap(String[] keys, Color[] values) {
        this.table = new Hashtable(101, 0.85f);
        this.gtable = new Hashtable(101, 0.85f);
        this.categorySwitcher.setOwner(this);
        for (int i = 0; i < keys.length; ++i) {
            if (values.length > i) {
                this.table.put(keys[i], values[i]);
                continue;
            }
            Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.table.put(keys[i], color);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        boolean beenInitialized = false;
        beenInitialized = this.stringPipes.size() == 1 ? this.singlePipeInit(initAction) : this.multiPipeInit(initAction);
        int labelCount = this.rawLabels.size();
        initAction.setValueCount(labelCount);
        if (beenInitialized) {
            return;
        }
        Formatter labelFormatter = this.getOwnerFormatter();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.removeAllValues();
        this.uniqueValueVector.setSize(labelCount);
        this.labelVector.setSize(labelCount);
        this.ttable = new Hashtable(101, 0.85f);
        for (int index = 0; index < labelCount; ++index) {
            try {
                String label = this.rawLabels.getValue(index);
                Color color = this.table.containsKey(label) ? (Color)this.table.get(label) : (this.gtable.containsKey(label) ? (Color)this.gtable.get(label) : new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
                String fLabel = labelFormatter.format(label);
                String tLabel = fLabel.trim();
                if (tLabel.length() == 0) {
                    tLabel = fLabel;
                }
                this.labelVector.setValueAt(tLabel, index);
                this.uniqueValueVector.setValueAt(color, index);
                this.ttable.put(label, color);
                continue;
            }
            catch (MissingValueException e) {
                MissingValues mv = e.getMissingValue();
                if (!this.isReplaceMissingValues(mv) || !this.isLabelMissingValues(mv)) continue;
                this.labelVector.setValueAt(this.getMissingValueLabel(mv), index);
                this.uniqueValueVector.setValueAt(this.getMissingReplacement(mv), index);
            }
        }
        this.gtable.clear();
        this.gtable = this.ttable;
    }

    public Color getValue(int index, StringPipe input) throws MissingValueException {
        Color result = null;
        try {
            if (this.gtable != null) {
                result = (Color)this.gtable.get(input.getValue(index));
            }
            if (result == null) {
                result = this.getMissingReplacement();
            }
        }
        catch (MissingValueException e) {
            MissingValues mv = e.getMissingValue();
            if (this.isReplaceMissingValues(mv)) {
                result = this.getMissingReplacement(mv);
            }
            throw e;
        }
        return result;
    }

    public void add(String key, Color value) {
        if (key != null && value != null) {
            this.table.put(key, value);
            this.setModified();
        }
    }

    public void remove(String key) {
        this.table.remove(key);
        this.setModified();
    }

    public void removeAll() {
        this.table.clear();
        this.setModified();
    }

    private boolean singlePipeInit(AInitAction ia) {
        StringPipe sp = (StringPipe)this.stringPipes.elementAt(0);
        ia.setCategoryRequest(true);
        ia.pushValueCount();
        sp.init(ia);
        ia.popValueCount();
        this.categorySwitcher.connectFrom(ia.getCategoryPipe());
        this.rawLabels = (StringVector)ia.getUniqueValueVector();
        this.valueToCategoryTable = (StringHashtable)ia.getValueToCategoryTable();
        if (this.rawLabels.containsMissing()) {
            return this.multiPipeInit(ia);
        }
        return ia.beenInitialized(this);
    }

    private boolean multiPipeInit(AInitAction ia) {
        int pipeIndex;
        boolean beenInitialized = true;
        String s = null;
        int pipeCount = this.stringPipes.size();
        StringVector[] uniqueValueVectors = new StringVector[pipeCount];
        for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
            StringPipe sp = (StringPipe)this.stringPipes.elementAt(pipeIndex);
            ia.setCategoryRequest(true);
            ia.pushValueCount();
            sp.init(ia);
            uniqueValueVectors[pipeIndex] = (StringVector)ia.getUniqueValueVector();
            ia.popValueCount();
            beenInitialized &= ia.beenInitialized(this);
        }
        if (!beenInitialized) {
            this.combinedLabels.removeAllValues();
            this.combinedLabelsToCategory.removeAllValues();
            MissingValues mv = null;
            int category = 0;
            for (pipeIndex = 0; pipeIndex < pipeCount; ++pipeIndex) {
                StringVector sv = uniqueValueVectors[pipeIndex];
                int valueCount = sv.size();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    boolean missing;
                    String key;
                    try {
                        key = s = sv.getValue(valueIndex);
                        missing = false;
                    }
                    catch (MissingValueException e) {
                        mv = e.getMissingValue();
                        key = mv;
                        missing = true;
                    }
                    if (missing && (!missing || !this.isLabelMissingValues(mv) || !this.isReplaceMissingValues(mv)) || this.combinedLabelsToCategory.containsKey(key)) continue;
                    if (this.sortType == 0) {
                        if (missing) {
                            this.combinedLabels.addValue(mv);
                        } else {
                            this.combinedLabels.addValue(s);
                        }
                    }
                    this.combinedLabelsToCategory.putIndex(key, category++);
                }
            }
            if (this.sortType != 0) {
                Sort.sortCategoryTable(this.combinedLabelsToCategory.table, this.sortType);
                Sort.makeOrderedVector(this.combinedLabels, this.combinedLabelsToCategory.table);
            }
        }
        this.rawLabels = this.combinedLabels;
        this.categorySwitcher.connectFrom(this.combinedLabelsToCategory);
        this.valueToCategoryTable = this.combinedLabelsToCategory;
        return beenInitialized;
    }

    public void addStringPipe(StringPipe pipe) {
        this.stringPipes.addElement(pipe);
    }

    public void removeAllStringPipes() {
        this.stringPipes.removeAllElements();
    }

    public void removeStringPipe(StringPipe pipe) {
        this.stringPipes.removeElement(pipe);
    }

    public int getStringPipeCount() {
        return this.stringPipes.size();
    }

    public StringPipe getStringPipe(int i) {
        return (StringPipe)this.stringPipes.elementAt(i);
    }

    public void setSortType(int sortType) {
        this.sortType = sortType;
        this.setModified();
    }

    public int getSortType() {
        return this.sortType;
    }

    @Override
    public void setLabelMissingValues(boolean b) {
        this.labelMissingValues = b;
        this.setModified();
    }
}

