/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.MissingValue;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.StringVector;
import com.sas.graphics.util.vtk.VTKFormat;
import java.text.ParseException;

public class StringInformatVariable
extends StringVariable {
    private StringVector values = new StringVector();
    private StringVariable stringVariable;
    private VTKFormat informat;
    private boolean messageFormatWorkaroundOn = false;

    public VTKFormat getInformat() {
        return this.informat;
    }

    public void setInformat(VTKFormat informat) {
        this.informat = informat;
    }

    public void setMessageFormatWorkaroundOn(boolean trueOrFalse) {
        this.messageFormatWorkaroundOn = trueOrFalse;
    }

    public boolean isMessageFormatWorkaroundOn() {
        return this.messageFormatWorkaroundOn;
    }

    @Override
    protected int getRawValueCount() {
        return this.stringVariable.getRawValueCount();
    }

    public void connectFrom(StringVariable stringVariable) {
        this.stringVariable = stringVariable;
        int n = stringVariable.getValueCount();
        this.values.removeAllValues();
        this.values.setSize(n);
        for (int i = 0; i < n; ++i) {
            try {
                Object[] os;
                Object o;
                String s = stringVariable.value.getValue(i);
                if (this.isMessageFormatWorkaroundOn()) {
                    s = s.concat("+");
                }
                if ((o = (os = (Object[])this.informat.informat(s))[0]) instanceof String) {
                    this.values.setValueAt((String)o, i);
                    continue;
                }
                this.values.setValueAt(MissingValue.value, i);
                continue;
            }
            catch (MissingValueException e) {
                this.values.setValueAt(MissingValue.value, i);
                continue;
            }
            catch (ParseException e) {
                this.values.setValueAt(MissingValue.value, i);
            }
        }
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(this.values, this.values.size());
        this.setName(this.stringVariable.getName());
        super.connectFrom();
    }

    @Override
    public boolean isMissing(int i) {
        return this.values.isMissing(i);
    }

    @Override
    public boolean isModified() {
        if (this.stringVariable.isModified()) {
            this.connectFrom(this.stringVariable);
            return true;
        }
        return super.isModified();
    }
}

