/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.SimpleStatisticInterface;
import com.sas.graphics.util.vtk.Statistic;
import java.util.Vector;

public class StatisticByCategory
extends PropertyContainer
implements NumericPipe,
SimpleStatisticInterface {
    private double mean;
    private double max;
    private double min;
    private double sum;
    private boolean isInited;
    public final NumericProperty input = new NumericProperty(this, true);
    public final IntegerProperty category = new IntegerProperty(this, true);
    public final NumericPipe value = this;
    protected double grandTotal;
    protected int statistic = 6;
    protected int observations;
    protected Vector totals = new Vector();

    public StatisticByCategory() {
        this.simpleStatisticInit();
    }

    private void init() {
        AInitAction initAction = new AInitAction(null);
        this.init(initAction);
    }

    @Override
    public void init(AInitAction ia) {
        Statistic.Bucket bucket;
        int i;
        super.init(ia);
        if (ia.beenInitialized(this)) {
            return;
        }
        this.totals.removeAllElements();
        this.grandTotal = 0.0;
        this.observations = ia.getValueCount();
        for (i = 0; i < this.observations; ++i) {
            int keyIndex;
            try {
                keyIndex = this.category.getValue(i);
            }
            catch (MissingValueException e) {
                throw new RuntimeException("Missing Value in category pipe.");
            }
            for (int fill = this.totals.size(); fill <= keyIndex; ++fill) {
                this.totals.addElement(new Statistic.Bucket());
            }
            bucket = (Statistic.Bucket)this.totals.elementAt(keyIndex);
            try {
                double value = this.input.getValue(i);
                bucket.accumulate(value);
                this.grandTotal += value;
                continue;
            }
            catch (MissingValueException mve) {
                bucket.accumulateMissing();
            }
        }
        Statistic.Bucket prevBucket = (Statistic.Bucket)this.totals.elementAt(0);
        prevBucket.runningCount = prevBucket.count;
        prevBucket.runningSum = prevBucket.sum;
        for (i = 1; i < this.totals.size(); ++i) {
            bucket = (Statistic.Bucket)this.totals.elementAt(i);
            bucket.runningCount = prevBucket.runningCount + bucket.count;
            bucket.runningSum = prevBucket.runningSum + bucket.sum;
            prevBucket = bucket;
        }
        this.calculateSimpleStatistics();
        this.isInited = true;
    }

    private void simpleStatisticInit() {
        this.min = 0.0;
        this.max = 0.0;
        this.mean = 0.0;
        this.sum = 0.0;
    }

    private void calculateSimpleStatistics() {
        this.simpleStatisticInit();
        int n = this.totals.size();
        for (int i = 0; i < n; ++i) {
            Statistic.Bucket bucket = (Statistic.Bucket)this.totals.elementAt(i);
            try {
                double d = Statistic.getValue(bucket, this.statistic, this.grandTotal, this.observations);
                this.min = i == 0 ? d : Math.min(this.min, d);
                this.max = i == 0 ? d : Math.max(this.max, d);
                this.sum += d;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.totals.size() > 0) {
            this.mean = this.sum / (double)this.totals.size();
        }
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        Statistic.Bucket bucket = (Statistic.Bucket)this.totals.elementAt(this.category.getValue(index));
        return Statistic.getValue(bucket, this.statistic, this.grandTotal, this.observations);
    }

    public void setStatistic(int aStat) {
        this.statistic = aStat >= 0 && aStat <= 13 ? aStat : 6;
        this.setModified();
    }

    public int getStatistic() {
        return this.statistic;
    }

    @Override
    public double getMin() {
        if (!this.isInited) {
            this.init();
        }
        return this.min;
    }

    @Override
    public double getMax() {
        if (!this.isInited) {
            this.init();
        }
        return this.max;
    }

    @Override
    public double getMean() {
        if (!this.isInited) {
            this.init();
        }
        return this.mean;
    }

    @Override
    public double getSum() {
        if (!this.isInited) {
            this.init();
        }
        return this.sum;
    }
}

