/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.MissingValueException;
import java.util.Hashtable;

public class Statistic {
    public static final int LAST = 0;
    public static final int MEAN = 1;
    public static final int FREQ = 2;
    public static final int PERCENTAGE_FREQ = 3;
    public static final int CUMULATIVE_FREQ = 4;
    public static final int CUMULATIVE_PERCENTAGE_FREQ = 5;
    public static final int SUM = 6;
    public static final int PERCENTAGE_SUM = 7;
    public static final int CUMULATIVE_SUM = 8;
    public static final int CUMULATIVE_PERCENTAGE_SUM = 9;
    public static final int MIN = 10;
    public static final int MAX = 11;
    public static final int FIRST = 12;
    public static final int MISSING_FREQ = 13;
    protected static final int GREATEST_STATISTIC = 13;
    private static final String[] names = new String[]{"LAST", "MEAN", "FREQ", "% FREQ", "CUMM FREQ", "CUMM % FREQ", "SUM", "% SUM", "CUMM SUM", "CUMM % SUM", "MIN", "MAX", "FIRST", "MISSING FREQ"};
    private static Hashtable statTable;

    public static String[] getNames() {
        return names;
    }

    public static int stringToInt(String statisticName) {
        Integer io;
        if (statTable == null) {
            statTable = new Hashtable(names.length);
            for (int i = 0; i < names.length; ++i) {
                statTable.put(names[i], new Integer(i));
            }
        }
        if ((io = (Integer)statTable.get(statisticName)) == null) {
            throw new IllegalArgumentException();
        }
        return io;
    }

    public static String getStringValue(Bucket bucket, int statistic, double grandTotal, int observationCount) throws MissingValueException {
        String result = null;
        switch (statistic) {
            case 12: {
                result = bucket.firstStringValue;
                break;
            }
            default: {
                result = bucket.lastStringValue;
            }
        }
        if (result == null) {
            throw MissingValueException.getDefaultMissingValueExeption();
        }
        return result;
    }

    public static double getValue(Bucket bucket, int statistic, double grandTotal, int observationCount) throws MissingValueException {
        double result;
        boolean statisticCanBeMissing = true;
        switch (statistic) {
            case 12: {
                result = bucket.firstDoubleValue;
                break;
            }
            case 0: {
                result = bucket.lastDoubleValue;
                break;
            }
            default: {
                Debug.println((String)"Invalid Statistic type, using SUM.");
            }
            case 6: {
                result = bucket.sum;
                break;
            }
            case 10: {
                result = bucket.min;
                break;
            }
            case 11: {
                result = bucket.max;
                break;
            }
            case 2: {
                result = bucket.count;
                statisticCanBeMissing = false;
                break;
            }
            case 13: {
                result = bucket.missingCount;
                statisticCanBeMissing = false;
                break;
            }
            case 1: {
                result = bucket.sum / (double)bucket.count;
                break;
            }
            case 7: {
                result = bucket.sum * 100.0 / grandTotal;
                break;
            }
            case 3: {
                result = (double)bucket.count * 100.0 / (double)observationCount;
                break;
            }
            case 4: {
                result = bucket.runningCount;
                break;
            }
            case 5: {
                result = (double)bucket.runningCount * 100.0 / (double)observationCount;
                break;
            }
            case 9: {
                result = bucket.runningSum * 100.0 / grandTotal;
                break;
            }
            case 8: {
                result = bucket.runningSum;
            }
        }
        if (statisticCanBeMissing && bucket.count == 0) {
            throw MissingValueException.getDefaultMissingValueExeption();
        }
        return result;
    }

    public static class Bucket {
        public String firstStringValue;
        public String lastStringValue;
        public double sum = 0.0;
        public double min = Double.MAX_VALUE;
        public double max = Double.MIN_VALUE;
        public double runningSum = 0.0;
        public double firstDoubleValue;
        public double lastDoubleValue;
        public int count = 0;
        public int missingCount = 0;
        public int runningCount = 0;

        public void accumulate(double value) {
            this.sum += value;
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            if (this.count == 0) {
                this.firstDoubleValue = value;
            }
            this.lastDoubleValue = value;
            ++this.count;
        }

        public void accumulate(String value) {
            if (this.count == 0) {
                this.firstStringValue = value;
            }
            this.lastStringValue = value;
            ++this.count;
        }

        public void accumulateMissing() {
            ++this.missingCount;
        }
    }
}

