/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.TableFormat;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import com.sas.graphics.util.vtk.VariableException;
import com.sas.table.FormatInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;

public abstract class StaticTableConnection
implements Pipe {
    protected StaticTableInterface data;
    protected int variableIndex;
    private int valueCount = 0;
    private String variableLabel = new String();
    private VTKFormat format;

    @Override
    public void init(AInitAction initAction) {
        initAction.setValueCount(this.valueCount);
    }

    @Override
    public void reset(AResetAction resetAction) {
    }

    @Override
    public Formatter getFormatter() {
        return null;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public String getVariableLabel() {
        return this.variableLabel;
    }

    public VTKFormat getFormat() {
        return this.format;
    }

    protected abstract boolean columnTypeMatches(Class var1, StringBuffer var2);

    public void connectFrom(StaticRowTemplateTableInterface aData, int aVariableIndex) {
        this.valueCount = 0;
        try {
            StaticColumnLabelInterface scli;
            Object o;
            Class columnType = aData.getColumnClass(aVariableIndex);
            StringBuffer correctType = new StringBuffer();
            if (!this.columnTypeMatches(columnType, correctType)) {
                throw new VariableException("The Column identified by index " + String.valueOf(aVariableIndex) + " is not of type " + correctType + ".");
            }
            this.data = aData;
            this.variableIndex = aVariableIndex;
            if (aData instanceof StaticColumnLabelInterface && (o = (scli = (StaticColumnLabelInterface)this.data).getColumnLabel(this.variableIndex)) instanceof String) {
                this.variableLabel = (String)o;
            }
            if (this.data instanceof FormatInterface) {
                this.format = new TableFormat();
                ((TableFormat)this.format).setFormat((FormatInterface)this.data);
                ((TableFormat)this.format).setIndex(this.variableIndex);
            } else {
                this.format = null;
            }
            this.saveValueCount();
        }
        catch (NullPointerException npe) {
            throw new VTKRuntimeException("Attempt to connect a null data source.");
        }
        catch (TableException te) {
            throw new VTKRuntimeException(" TableException thrown -- " + te.toString());
        }
    }

    public void connectFrom(StaticRowTemplateTableInterface aData, String aVariableLabel) {
        try {
            if (!(aData instanceof StaticColumnLabelInterface)) {
                throw new VariableException("The data source must be an instance of StaticColumnLabelInterface");
            }
            if (!((StaticColumnLabelInterface)aData).isColumnLabelsSupported()) {
                throw new VariableException("Column labels are not supported");
            }
            int indx = StaticTableConnection.labelToIndex(aData, aVariableLabel);
            if (indx < 0) {
                String error = " There is no variable by the name " + aVariableLabel + " in the data source. ";
                throw new VariableException(error);
            }
            this.variableLabel = aVariableLabel;
            this.connectFrom(aData, indx);
            this.saveValueCount();
        }
        catch (NullPointerException npe) {
            throw new VTKRuntimeException("Attempt to connect a null data source.");
        }
        catch (TableException te) {
            throw new VTKRuntimeException(" TableException thrown -- " + te.toString());
        }
    }

    public Object getTableValue(int index) {
        try {
            if (index >= 0 && index < this.valueCount) {
                Object value = null;
                value = this.data.getCell(index + 1, this.variableIndex);
                return value;
            }
            throw new VTKRuntimeException("Value index out of range: index=" + index);
        }
        catch (NullPointerException npe) {
            throw new VTKRuntimeException("No data connection.");
        }
        catch (TableException te) {
            throw new VTKRuntimeException(" TableException thrown -- " + te.toString());
        }
    }

    public void disconnect() {
        this.data = null;
        this.variableIndex = -1;
        this.valueCount = 0;
    }

    public boolean isMissing(int i) {
        Double d;
        Object o = this.getTableValue(i);
        boolean result = false;
        if (o == null || o instanceof MissingValues) {
            result = true;
        }
        if (o instanceof Double && (d = (Double)o).isNaN()) {
            result = true;
        }
        return result;
    }

    private void saveValueCount() throws TableException {
        if (this.data != null) {
            this.valueCount = this.data.getRowCount();
            if (this.valueCount < 0) {
                this.valueCount = this.data.countRows(Integer.MAX_VALUE);
            }
        }
    }

    public void setModified() {
        try {
            this.saveValueCount();
        }
        catch (TableException e) {
            this.valueCount = 0;
        }
    }

    public static int labelToIndex(StaticRowTemplateTableInterface data, String label) throws TableException {
        int result = -1;
        if (data instanceof StaticColumnLabelInterface) {
            int numOfColumns = data.getColumnCount();
            String lowcaseLabel = label.toLowerCase();
            for (int i = 1; i <= numOfColumns; ++i) {
                if (!lowcaseLabel.equals(((String)((StaticColumnLabelInterface)data).getColumnLabel(i)).toLowerCase())) continue;
                result = i;
                break;
            }
        }
        return result;
    }
}

