/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.PropertyContainer;

public abstract class Property
implements Pipe {
    private PropertyContainer container;

    public Property() {
        this.container = null;
    }

    public Property(PropertyContainer aContainer, boolean initByContainer) {
        this.container = aContainer;
        if (initByContainer) {
            this.container.addProperty(this);
        }
    }

    public boolean isConnected() {
        return this.getPipe() != null;
    }

    public abstract void disconnect();

    protected void setModified() {
        if (this.container != null) {
            this.container.setModified();
        }
    }

    protected abstract Pipe getPipe();

    @Override
    public void reset(AResetAction resetAction) {
        Pipe pipe = this.getPipe();
        if (pipe != null) {
            pipe.reset(resetAction);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        Pipe pipe = this.getPipe();
        if (pipe != null) {
            pipe.init(initAction);
        }
    }

    @Override
    public Formatter getFormatter() {
        Pipe pipe = this.getPipe();
        if (pipe != null) {
            return pipe.getFormatter();
        }
        return Formatter.defaultFormatter;
    }
}

