/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.vtk.BooleanPipe;
import com.sas.graphics.util.vtk.ColorPipe;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Probe
extends PropertyContainer {
    public final StringProperty title = new StringProperty(this, false);
    private Font font = FontManager.getDefaultFont();
    private Color backgroundColor = new Color(0.85f, 0.85f, 0.75f);
    private Color foregroundColor = Color.black;
    private Rectangle viewport;
    private String connectionString;
    private String leftPad;
    private String rightPad;
    private Insets insets;
    private Integer textBuffer;
    private static final String DEFAULT_CONNECTION_STRING = " = ";
    private static final String DEFAULT_LEFT_PAD = " ";
    private static final String DEFAULT_RIGHT_PAD = " ";
    private static Insets DEFAULT_INSETS = new Insets(2, 2, 2, 2);
    private static Integer DEFAULT_TEXT_BUFFER = new Integer(2);
    private static final char[] NEWLINE = new char[]{' ', '\n'};
    private static final String INVALID_PIPE = " Invalid pipe ";
    private static final int SEARCH_BY_NAME = 0;
    private static final int SEARCH_BY_STRING = 1;
    private static final int SEARCH_BY_PIPE = 2;
    private Vector entries = new Vector();
    private String missingReplacement = null;
    private Hashtable missingReplacementTable = null;
    private int pointerOffset = 30;
    private StringBuffer s = new StringBuffer(300);

    public void setPointerOffset(int pointerOffset) {
        this.pointerOffset = pointerOffset;
    }

    public int getPointerOffset() {
        return this.pointerOffset;
    }

    public void setFont(Font aFont) {
        this.font = aFont;
    }

    public Font getFont() {
        return this.font;
    }

    public void setMissingReplacement(String string) {
        this.missingReplacement = string;
    }

    public String getMissingReplacement() {
        return this.missingReplacement;
    }

    public void setMissingReplacement(String string, MissingValues missingValue) {
        if (this.missingReplacementTable == null) {
            this.missingReplacementTable = new Hashtable();
        }
        this.missingReplacementTable.put(missingValue, string);
    }

    public String getMissingReplacement(MissingValues missingValue) {
        Object value;
        String result = this.missingReplacement;
        if (this.missingReplacementTable != null && (value = this.missingReplacementTable.get(missingValue)) != null) {
            result = (String)value;
        }
        if (result == null) {
            result = this.missingReplacement;
        }
        if (result == null) {
            result = "." + missingValue.toString();
        }
        return result;
    }

    public void setViewport(int x, int y, Dimension dimension) {
        this.setViewport(x, y, dimension.width, dimension.height);
    }

    public void setViewport(int width, int height, Insets insets) {
        this.setViewport(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
    }

    public void setViewport(int x, int y, int width, int height) {
        if (this.viewport == null) {
            this.viewport = new Rectangle();
        }
        this.viewport.x = x;
        this.viewport.y = y;
        this.viewport.width = width;
        this.viewport.height = height;
    }

    public Rectangle getViewport() {
        return this.viewport;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setConnectionString(String s) {
        this.connectionString = s == null ? DEFAULT_CONNECTION_STRING : s;
    }

    public String getconnectionString() {
        return this.connectionString == null ? DEFAULT_CONNECTION_STRING : this.connectionString;
    }

    public void setLeftPad(String s) {
        this.leftPad = s == null ? " " : s;
    }

    public String getLeftPad() {
        return this.leftPad == null ? " " : this.leftPad;
    }

    public void setRightPad(String s) {
        this.rightPad = s == null ? " " : s;
    }

    public String getRightPad() {
        return this.rightPad == null ? " " : this.rightPad;
    }

    public void setInsets(Insets i) {
        this.insets = i == null ? DEFAULT_INSETS : i;
    }

    public Insets getInsets() {
        return this.insets == null ? DEFAULT_INSETS : this.insets;
    }

    public void setTextBuffer(int i) {
        this.textBuffer = i > 0 ? new Integer(i) : DEFAULT_TEXT_BUFFER;
    }

    public int getTextBuffer() {
        return this.textBuffer == null ? DEFAULT_TEXT_BUFFER.intValue() : this.textBuffer.intValue();
    }

    public void addPipe(String name, Pipe pipe) {
        this.entries.addElement(new ProbeEntry(name, pipe));
    }

    public void addString(String name, String string) {
        StringProperty sp = new StringProperty();
        sp.setValue(string);
        this.entries.addElement(new ProbeEntry(name, sp));
    }

    public ProbeEntry getProbeEntry(String aName) {
        Lookup lu = this.lookup(aName, null, null, 0);
        return lu.probeEntry;
    }

    public ProbeEntry getProbeEntry(Pipe aPipe) {
        Lookup lu = this.lookup(null, aPipe, null, 2);
        return lu.probeEntry;
    }

    public void removePipe(Pipe aPipe) {
        Lookup lu = this.lookup(null, aPipe, null, 2);
        if (lu.i >= 0) {
            this.entries.removeElementAt(lu.i);
        }
    }

    public void removeName(String aName) {
        Lookup lu = this.lookup(aName, null, null, 0);
        if (lu.i >= 0) {
            this.entries.removeElementAt(lu.i);
        }
    }

    public void removeString(String aString) {
        Lookup lu = this.lookup(null, null, aString, 1);
        if (lu.i >= 0) {
            this.entries.removeElementAt(lu.i);
        }
    }

    private Lookup lookup(String aName, Pipe aPipe, String aString, int searchType) {
        Lookup lu = new Lookup();
        int n = this.entries.size();
        block5: for (int i = 0; i < n; ++i) {
            ProbeEntry pe = (ProbeEntry)this.entries.elementAt(i);
            switch (searchType) {
                case 0: {
                    if (!pe.getName().equals(aName)) continue block5;
                    lu.i = i;
                    lu.probeEntry = pe;
                    return lu;
                }
                case 2: {
                    if (pe.getPipe() != aPipe) continue block5;
                    lu.i = i;
                    lu.probeEntry = pe;
                    return lu;
                }
                case 1: {
                    if (!pe.getString().equals(aString)) continue block5;
                    lu.i = i;
                    lu.probeEntry = pe;
                    return lu;
                }
            }
        }
        return lu;
    }

    public void removeAll() {
        this.entries.removeAllElements();
    }

    public String getString(int valueIndex) {
        if (this.leftPad == null) {
            this.leftPad = " ";
        }
        if (this.connectionString == null) {
            this.connectionString = DEFAULT_CONNECTION_STRING;
        }
        this.s.setLength(0);
        int n = this.entries.size();
        for (int i = 0; i < n; ++i) {
            ProbeEntry probeEntry = (ProbeEntry)this.entries.elementAt(i);
            this.s.append(this.leftPad + probeEntry.getName() + this.connectionString);
            Pipe p = probeEntry.getPipe();
            Formatter format = p.getFormatter();
            try {
                if (p instanceof StringPipe) {
                    StringPipe sp = (StringPipe)p;
                    this.s.append(format.format(sp.getValue(valueIndex)));
                } else if (p instanceof NumericPipe) {
                    NumericPipe np = (NumericPipe)p;
                    this.s.append(format.format(new Double(np.getValue(valueIndex))));
                } else if (p instanceof ColorPipe) {
                    ColorPipe cp = (ColorPipe)p;
                    Color color = cp.getValue(valueIndex);
                    this.s.append(color.toString());
                } else if (p instanceof BooleanPipe) {
                    BooleanPipe bp = (BooleanPipe)p;
                    this.s.append(bp.getValue(valueIndex));
                } else if (p instanceof IntegerPipe) {
                    IntegerPipe ip = (IntegerPipe)p;
                    this.s.append(ip.getValue(valueIndex));
                } else {
                    Debug.println((String)("ProbeEntry has a bad pipe: " + p));
                }
            }
            catch (MissingValueException mve) {
                this.s.append(this.getMissingReplacement(mve.getMissingValue()));
            }
            this.s.append(NEWLINE);
        }
        return this.s.toString();
    }

    public String[] getLabels() {
        int size = this.entries.size();
        String[] labels = new String[size];
        if (this.leftPad == null) {
            this.leftPad = " ";
        }
        for (int ii = 0; ii < size; ++ii) {
            labels[ii] = this.leftPad + ((ProbeEntry)this.entries.elementAt(ii)).getName();
        }
        return labels;
    }

    public String[] getValues(int valueIndex) {
        int size = this.entries.size();
        String[] values = new String[size];
        if (this.connectionString == null) {
            this.connectionString = DEFAULT_CONNECTION_STRING;
        }
        if (this.rightPad == null) {
            this.rightPad = " ";
        }
        this.s.setLength(0);
        this.s.append(this.connectionString);
        for (int ii = 0; ii < size; ++ii) {
            ProbeEntry probeEntry = (ProbeEntry)this.entries.elementAt(ii);
            Pipe p = probeEntry.getPipe();
            Formatter format = p.getFormatter();
            try {
                if (p instanceof StringPipe) {
                    StringPipe sp = (StringPipe)p;
                    this.s.append(format.format(sp.getValue(valueIndex)));
                } else if (p instanceof NumericPipe) {
                    NumericPipe np = (NumericPipe)p;
                    this.s.append(format.format(new Double(np.getValue(valueIndex))));
                } else if (p instanceof ColorPipe) {
                    ColorPipe cp = (ColorPipe)p;
                    Color color = cp.getValue(valueIndex);
                    this.s.append(color.toString());
                } else if (p instanceof BooleanPipe) {
                    BooleanPipe bp = (BooleanPipe)p;
                    this.s.append(bp.getValue(valueIndex));
                } else if (p instanceof IntegerPipe) {
                    IntegerPipe ip = (IntegerPipe)p;
                    this.s.append(ip.getValue(valueIndex));
                } else {
                    Debug.println((String)("ProbeEntry has a bad pipe: " + p));
                    this.s.append(INVALID_PIPE);
                }
            }
            catch (MissingValueException mve) {
                this.s.append(this.getMissingReplacement(mve.getMissingValue()));
            }
            values[ii] = this.s.append(this.rightPad).toString();
            this.s.setLength(this.connectionString.length());
        }
        return values;
    }

    public Dimension getPreferredSize(Graphics gc, int valueIndex) {
        Info info = this.calcPreferredSize(gc, valueIndex);
        return new Dimension(info.width + 3, info.height + 1);
    }

    public Info calcPreferredSize(Graphics gc, int valueIndex) {
        Info info = new Info();
        Info.access$402(info, this.getLabels());
        Info.access$502(info, this.getValues(valueIndex));
        info.size = Math.min(info.labels.length, info.values.length);
        info.maxLabelWidth = 0;
        info.maxValueWidth = 0;
        if (this.insets == null) {
            this.insets = DEFAULT_INSETS;
        }
        gc.setFont(this.font);
        FontMetrics fontMetrics = this.font == null ? gc.getFontMetrics() : gc.getFontMetrics(this.font);
        info.textHeight = fontMetrics.getHeight();
        info.ascent = fontMetrics.getAscent();
        int textBuff = this.getTextBuffer();
        info.height = this.insets.top + (info.textHeight + textBuff) * info.size - textBuff + this.insets.bottom;
        for (int ii = 0; ii < info.size; ++ii) {
            info.width = fontMetrics.stringWidth(info.labels[ii]);
            if (info.width > info.maxLabelWidth) {
                info.maxLabelWidth = info.width;
            }
            info.width = fontMetrics.stringWidth(info.values[ii]);
            if (info.width <= info.maxValueWidth) continue;
            info.maxValueWidth = info.width;
        }
        info.width = this.insets.left + info.maxLabelWidth + info.maxValueWidth + this.insets.right;
        return info;
    }

    public void draw(Graphics gc, int x, int y, int valueIndex) {
        Info info = this.calcPreferredSize(gc, valueIndex);
        int ulx = x - info.width / 2;
        int uly = y - this.pointerOffset - info.height;
        if (this.viewport != null) {
            if (x < info.width / 2) {
                ulx = 2;
            } else if (this.viewport.x + this.viewport.width - x < info.width / 2 - 2) {
                ulx = this.viewport.x + this.viewport.width - info.width - 2;
            }
            if (y < this.pointerOffset + info.height) {
                if (info.height <= y) {
                    uly = y - this.pointerOffset - info.height;
                    if (uly <= 0) {
                        uly = 1;
                    }
                } else {
                    uly = y + this.pointerOffset;
                    if (uly + info.height > this.viewport.height && (uly = this.viewport.height - info.height - 1) < y) {
                        uly = y;
                    }
                }
            }
        }
        gc.setColor(this.backgroundColor);
        gc.fillRect(ulx, uly, info.width, info.height);
        gc.setColor(this.foregroundColor);
        gc.drawRect(ulx, uly, info.width, info.height);
        int yy = uly + info.ascent + this.insets.top;
        for (int ii = 0; ii < info.size; ++ii) {
            gc.drawString(info.labels[ii], ulx + this.insets.left, yy);
            gc.drawString(info.values[ii], ulx + this.insets.left + info.maxLabelWidth, yy);
            yy += info.textHeight;
        }
    }

    public int getProbeEntryCount() {
        return this.entries.size();
    }

    public ProbeEntry getProbeEntry(int i) {
        return (ProbeEntry)this.entries.elementAt(i);
    }

    public ProbeEntryEnumerator enumerate() {
        return new ProbeEntryEnumerator();
    }

    public class ProbeEntryEnumerator
    implements Enumeration {
        private int i = 0;

        @Override
        public boolean hasMoreElements() {
            return this.i < Probe.this.entries.size();
        }

        public Object nextElement() {
            ProbeEntry pe = (ProbeEntry)Probe.this.entries.elementAt(this.i);
            ++this.i;
            return pe;
        }
    }

    private class Lookup {
        public int i = -1;
        public ProbeEntry probeEntry = null;

        private Lookup() {
        }
    }

    public class ProbeEntry {
        private String name;
        private Pipe pipe = null;

        ProbeEntry(String aName, Pipe aPipe) {
            this.name = aName;
            this.pipe = aPipe;
        }

        public void setName(String aName) {
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }

        public void setPipe(ColorPipe aPipe) {
            this.pipe = aPipe;
        }

        public void setPipe(StringPipe aPipe) {
            this.pipe = aPipe;
        }

        public void setPipe(NumericPipe aPipe) {
            this.pipe = aPipe;
        }

        public Pipe getPipe() {
            return this.pipe;
        }

        public String getString() {
            String result = null;
            if (this.pipe instanceof StringProperty) {
                result = ((StringProperty)this.pipe).getValue();
            }
            return result;
        }
    }

    private static class Info {
        private int height;
        private int width;
        private String[] labels;
        private String[] values;
        private int size;
        private int textHeight;
        private int ascent;
        private int maxLabelWidth;
        private int maxValueWidth;

        private Info() {
        }

        static /* synthetic */ String[] access$402(Info x0, String[] x1) {
            x0.labels = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(Info x0, String[] x1) {
            x0.values = x1;
            return x1;
        }
    }
}

