/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValue;
import com.sas.graphics.util.vtk.Pipe;

public abstract class PipedVector {
    protected Pipe owner = null;

    protected PipedVector() {
    }

    public Formatter getFormatter() {
        Formatter result = Formatter.defaultFormatter;
        if (this.owner != null) {
            result = this.owner.getFormatter();
        }
        return result;
    }

    public void setOwner(Pipe owner) {
        this.owner = owner;
    }

    public Pipe getOwner() {
        return this.owner;
    }

    public void reset(AResetAction resetAction) {
        if (this.owner != null) {
            this.owner.reset(resetAction);
        }
    }

    public void init(AInitAction initAction) {
        if (this.owner != null) {
            initAction.pushValueCount();
            this.owner.init(initAction);
            initAction.popValueCount();
        }
        initAction.setValueCount(this.getValueCount());
    }

    public abstract int getValueCount();

    public abstract void removeAllValues();

    public abstract int size();

    public abstract void removeValueAt(int var1);

    public abstract void setSize(int var1);

    public void insertValueAt(MissingValue value, int index) {
        this.insertValueAt(MissingValues.Dot, index);
    }

    public abstract void insertValueAt(MissingValues var1, int var2);

    public void addValue(MissingValue value) {
        this.addValue(MissingValues.Dot);
    }

    public abstract void addValue(MissingValues var1);

    public void setValueAt(MissingValue value, int index) {
        this.setValueAt(MissingValues.Dot, index);
    }

    public abstract void setValueAt(MissingValues var1, int var2);

    public abstract int capacity();

    public abstract boolean isEmpty();

    public abstract void trimToSize();

    public abstract boolean isMissing(int var1);

    public abstract boolean containsMissing();
}

