/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVariable;
import java.util.Arrays;

public class PieOtherCollector
extends PropertyContainer {
    private StringVariable categoryVariable;
    private NumericVariable responseVariable;
    private int[] indexMap;
    private double otherThresholdPct = 0.04;
    private int otherThresholdNum = 0;
    private double otherAngle = 0.0;
    private double otherValue = 0.0;
    private String[] otherContents;
    private int otherCount = 0;
    private int nonOtherCount = 0;
    public final NumericPipe responseMap = new ResponseMap(this);
    public final StringPipe categoryMap = new CategoryMap(this);

    public PieOtherCollector(StringVariable category, NumericVariable response) {
        this.categoryVariable = category;
        this.responseVariable = response;
        ((ResponseMap)this.responseMap).setResponse(response);
        ((CategoryMap)this.categoryMap).setCategory(category);
    }

    @Override
    public void init(AInitAction initAction) {
        int i;
        initAction.pushValueCount();
        super.init(initAction);
        int vc = initAction.getValueCount();
        initAction.popValueCount();
        int respvc = this.responseVariable.getValueCount();
        double total = this.responseVariable.getSum();
        if (initAction.beenInitialized(this)) {
            int totalSlices = this.nonOtherCount + (this.otherCount > 0 ? 1 : 0);
            initAction.setValueCount(totalSlices);
            return;
        }
        this.indexMap = new int[respvc];
        int[] otherList = new int[respvc];
        double otherSum = 0.0;
        int curIndex = 0;
        if (this.otherThresholdNum >= respvc) {
            this.otherThresholdPct = 0.0;
        } else if (this.otherThresholdNum > 0) {
            this.otherThresholdPct = -1.0;
        }
        if (this.otherThresholdNum > 0 && this.otherThresholdPct < 0.0) {
            double[] slices = new double[respvc];
            for (int i2 = 0; i2 < respvc; ++i2) {
                try {
                    slices[i2] = this.responseVariable.value.getValue(i2);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            Arrays.sort(slices);
            this.otherThresholdPct = slices[respvc - this.otherThresholdNum] / total;
        }
        for (i = 0; i < respvc; ++i) {
            try {
                double r = this.responseVariable.value.getValue(i);
                if (r > total * this.otherThresholdPct) {
                    this.indexMap[curIndex++] = i;
                    ++this.nonOtherCount;
                    continue;
                }
                otherList[this.otherCount++] = i;
                otherSum += r;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.otherValue = otherSum;
        if (this.otherCount == 1) {
            this.otherCount = 0;
            this.otherValue = 0.0;
            this.nonOtherCount = respvc;
            for (i = 0; i < respvc; ++i) {
                this.indexMap[i] = i;
            }
        }
        if (this.otherCount > 0) {
            this.indexMap[curIndex] = respvc;
        }
        ((ResponseMap)this.responseMap).setIndexMap(this.indexMap);
        ((CategoryMap)this.categoryMap).setIndexMap(this.indexMap);
        int totalSlices = this.nonOtherCount + (this.otherCount > 0 ? 1 : 0);
        initAction.setValueCount(totalSlices);
    }

    public double getNonOtherCount() {
        return this.nonOtherCount;
    }

    public double getOtherValue() {
        return this.otherValue;
    }

    private static class CategoryMap
    extends Map
    implements StringPipe {
        private StringVariable category;

        public CategoryMap(PieOtherCollector collector) {
            super(collector);
        }

        public void setCategory(StringVariable category) {
            this.category = category;
        }

        @Override
        public String getValue(int index) throws MissingValueException {
            if ((double)index >= this.collector.getNonOtherCount()) {
                return "Other";
            }
            return this.category.value.getValue(this.indexMap[index]);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.category.value.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return this.category.value.getFormatter();
        }
    }

    private static class ResponseMap
    extends Map
    implements NumericPipe {
        private NumericVariable response;

        public ResponseMap(PieOtherCollector collector) {
            super(collector);
        }

        public void setResponse(NumericVariable response) {
            this.response = response;
        }

        @Override
        public double getValue(int index) throws MissingValueException {
            if ((double)index >= this.collector.getNonOtherCount()) {
                return this.collector.getOtherValue();
            }
            return this.response.value.getValue(this.indexMap[index]);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.response.value.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return this.response.value.getFormatter();
        }
    }

    private static class Map {
        protected PieOtherCollector collector;
        protected int[] indexMap;

        public Map(PieOtherCollector collector) {
            this.collector = collector;
        }

        public void setIndexMap(int[] indexMap) {
            this.indexMap = indexMap;
        }

        public void init(AInitAction ia) {
            this.collector.init(ia);
        }
    }
}

