/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.TableModelConnection;
import com.sas.graphics.util.vtk.Variable;

class NumericTableModelConnection
extends TableModelConnection
implements NumericPipe {
    public NumericTableModelConnection(Variable variable) {
        super(variable);
    }

    @Override
    protected boolean columnTypeMatches(Class columnType, StringBuffer correctType) {
        if (columnType == Object.class) {
            return true;
        }
        correctType.append("Number");
        return columnType.getSuperclass() == Number.class;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        Double d;
        boolean isMissing = false;
        Object o = this.getTableValue(index);
        if (o == null) {
            isMissing = true;
            o = MissingValues.Dot;
        } else if (o instanceof MissingValues) {
            isMissing = true;
        } else if (o instanceof Double && (d = (Double)o).isNaN()) {
            isMissing = true;
            o = MissingValues.Dot;
        }
        if (isMissing) {
            MissingValueException e = MissingValueException.getDefaultMissingValueExeption();
            e.setMissingValue((MissingValues)o);
            throw e;
        }
        return ((Number)o).doubleValue();
    }
}

