/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.SocketConnection;
import com.sas.graphics.util.vtk.Variable;
import java.io.IOException;

class NumericSocketConnection
extends SocketConnection
implements NumericPipe {
    private double[] ringBuffer;

    public NumericSocketConnection(Variable aVariable, int aBufferSize) {
        super(aVariable, aBufferSize);
        this.ringBuffer = new double[aBufferSize];
    }

    @Override
    protected void readIntoBuffer(int ringIndex) throws IOException {
        this.ringBuffer[ringIndex] = this.inputStream.readDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValue(int index) throws MissingValueException {
        double data;
        NumericSocketConnection numericSocketConnection = this;
        synchronized (numericSocketConnection) {
            data = this.ringBuffer[(this.origin + index) % this.bufferSize];
        }
        if (Double.isNaN(data)) {
            throw MissingValueException.getDefaultMissingValueExeption();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMissing(int index) {
        NumericSocketConnection numericSocketConnection = this;
        synchronized (numericSocketConnection) {
            return Double.isNaN(this.ringBuffer[(this.origin + index) % this.bufferSize]);
        }
    }
}

