/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.graphics.util.vtk.PipedFormat;
import com.sas.graphics.util.vtk.StringHashtable;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVector;

public class NumericPipedFormat
extends PipedFormat {
    public StringVector uniqueValueVector = new StringVector();
    public final NumericProperty input = new NumericProperty(this, true);
    public final StringPipe uniqueValue = this.uniqueValueVector;

    public NumericPipedFormat() {
        this.uniqueValueVector.setOwner(this);
    }

    @Override
    public String getValue(int index) throws MissingValueException {
        return this.getInternalFormatter().format(new Double(this.input.getValue(index)));
    }

    @Override
    public void init(AInitAction initAction) {
        boolean icr = initAction.isCategoryRequest();
        super.init(initAction);
        if (icr) {
            if (!initAction.beenInitialized(this)) {
                Formatter formatter = this.getInternalFormatter();
                NumericVector uv = (NumericVector)initAction.getUniqueValueVector();
                int n = uv.size();
                this.uniqueValueVector.setSize(n);
                for (int i = 0; i < n; ++i) {
                    try {
                        String s = formatter.format(new Double(uv.getValue(i)));
                        this.uniqueValueVector.setValueAt(s, i);
                        continue;
                    }
                    catch (MissingValueException e) {
                        this.uniqueValueVector.setValueAt(".", i);
                    }
                }
            }
            if (this.categoryTable == null) {
                this.categoryTable = new StringHashtable();
            } else {
                this.categoryTable.removeAllValues();
            }
            this.categoryTable.input.connectFrom(this.uniqueValueVector);
            initAction.pushValueCount();
            this.categoryTable.init(initAction);
            initAction.popValueCount();
            initAction.setUniqueValueVector(this.uniqueValueVector);
            initAction.setCategoryPipe(this.categoryTable);
            initAction.setValueToCategoryTable(this.categoryTable);
        }
    }
}

