/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringPipeSwitcher;
import com.sas.graphics.util.vtk.VTKFormat;
import com.sas.graphics.util.vtk.ValueMap;

public abstract class Mapper
extends PropertyContainer
implements Pipe {
    protected StringPipeSwitcher labelSwitcher = new StringPipeSwitcher();
    public final StringPipe label = this.labelSwitcher;

    public static double[] adjustMinMax(double valueCount, double vMin, double vMax) {
        double step;
        double intervals = valueCount - 1.0;
        double logTen = Math.log(10.0);
        if (vMin == vMax) {
            vMax = vMin == 0.0 ? 0.125 / intervals : (vMax *= vMin < 0.0 ? 0.99 : 1.01);
        }
        double[] newValues = new double[]{vMin, vMax};
        double rawInterval = (vMax - vMin) / intervals;
        double logInterval = Math.floor(Math.log(rawInterval) / logTen);
        if (logInterval == 0.0) {
            step = 0.25;
            newValues[0] = Math.floor(vMin);
        } else {
            step = Math.pow(10.0, logInterval);
            newValues[0] = step * Math.floor(vMin / step);
        }
        double cleanInterval = step * Math.ceil(rawInterval / step);
        newValues[1] = newValues[0] + cleanInterval * intervals;
        return newValues;
    }

    protected abstract ValueMap getValueMap();

    public void setFormat(VTKFormat format) {
        this.getValueMap().setFormat(format);
    }

    public VTKFormat getFormat() {
        return this.getValueMap().getFormat();
    }

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        ia.pushValueCount();
        this.getValueMap().init(ia);
        ia.popValueCount();
    }

    @Override
    public Formatter getFormatter() {
        ValueMap map = this.getValueMap();
        Formatter f = map.isUserSetFormat() ? map.getFormatter() : super.getFormatter();
        return f;
    }

    public void setMissingValueLabel(String s) {
        this.getValueMap().setMissingValueLabel(s);
        this.setModified();
    }

    public String getMissingValueLabel() {
        return this.getValueMap().getMissingValueLabel();
    }

    public void setMissingValueLabel(String s, MissingValues mv) {
        this.getValueMap().setMissingValueLabel(s, mv);
        this.setModified();
    }

    public String getMissingValueLabel(MissingValues mv) {
        return this.getValueMap().getMissingValueLabel(mv);
    }
}

