/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.Style;
import com.sas.graphics.util.vtk.TextStyle;
import java.awt.Color;

public class LegendStyle
extends Style {
    private static final Color defaultBackgroundColor = new Color(0.9f, 0.9f, 0.9f);
    public static final int LINE = 0;
    public static final int BLOCK = 1;
    public static final int SHADOW = 2;
    protected boolean borderOn;
    protected boolean titleOn;
    protected boolean labelsOn;
    protected boolean backgroundOn;
    protected Color backgroundColor;
    protected int titlePosition;
    protected int borderStyle;
    protected double borderOffset;
    protected int borderVerticalJustification;
    protected int borderHorizontalJustification;
    protected TextStyle labelStyle;
    protected TextStyle titleStyle;

    public LegendStyle() {
        this.borderOn = true;
        this.titleOn = true;
        this.labelsOn = true;
        this.backgroundOn = false;
        this.backgroundColor = defaultBackgroundColor;
        this.titlePosition = 0;
        this.borderStyle = 0;
        this.borderOffset = 0.0;
        this.borderVerticalJustification = 3;
        this.borderHorizontalJustification = 2;
        this.labelStyle = new TextStyle();
        this.titleStyle = new TextStyle();
    }

    public LegendStyle(LegendStyle ls) {
        this.borderOn = ls.borderOn;
        this.titleOn = ls.titleOn;
        this.labelsOn = ls.labelsOn;
        this.backgroundOn = ls.backgroundOn;
        this.backgroundColor = ls.backgroundColor;
        this.labelStyle = new TextStyle(ls.labelStyle);
        this.titleStyle = new TextStyle(ls.titleStyle);
        this.borderStyle = ls.borderStyle;
        this.borderOffset = ls.borderOffset;
        this.borderVerticalJustification = ls.borderVerticalJustification;
        this.borderHorizontalJustification = ls.borderHorizontalJustification;
    }

    public void setBorderOn(boolean trueOrFalse) {
        this.borderOn = trueOrFalse;
    }

    public void setTitleOn(boolean trueOrFalse) {
        this.titleOn = trueOrFalse;
    }

    public void setLabelsOn(boolean trueOrFalse) {
        this.labelsOn = trueOrFalse;
    }

    public void setBackgroundOn(boolean trueOrFalse) {
        this.backgroundOn = trueOrFalse;
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.backgroundColor = color;
        }
    }

    public void setTitlePosition(int position) {
        if (position >= 0 && position <= 2) {
            this.titlePosition = position;
        }
    }

    public void setLabelStyle(TextStyle style) {
        if (style != null) {
            this.labelStyle = style;
        }
    }

    public void setTitleStyle(TextStyle style) {
        if (style != null) {
            this.titleStyle = style;
        }
    }

    public void setBorderStyle(int bStyle) {
        if (bStyle >= 0 && bStyle <= 2) {
            this.borderStyle = bStyle;
        }
    }

    public void setBorderOffset(double offset) {
        if (offset > 0.0) {
            this.borderOffset = offset;
        }
    }

    public void setBorderVerticalJustification(int justification) {
        if (justification >= 0 && justification <= 3) {
            this.borderVerticalJustification = justification;
        }
    }

    public void setBorderHorizontalJustification(int justification) {
        if (justification >= 0 && justification <= 3) {
            this.borderHorizontalJustification = justification;
        }
    }

    public boolean isBorderOn() {
        return this.borderOn;
    }

    public boolean isTitleOn() {
        return this.titleOn;
    }

    public boolean isLabelsOn() {
        return this.labelsOn;
    }

    public boolean isBackgroundOn() {
        return this.backgroundOn;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public double getBorderOffset() {
        return this.borderOffset;
    }

    public int getBorderVerticalJustification() {
        return this.borderVerticalJustification;
    }

    public int getBorderHorizontalJustification() {
        return this.borderHorizontalJustification;
    }
}

