/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.SelectDetail;
import java.util.Enumeration;

public abstract class IndexedDetail
extends SelectDetail {
    private int index;
    PointInfo[] pointInfoArray;

    public IndexedDetail(int anIndex) {
        this.index = anIndex;
    }

    protected void setPointInfo(PointInfo[] aPointInfoArray) {
        this.pointInfoArray = aPointInfoArray;
    }

    public int getIndex() {
        return this.index;
    }

    public Enumeration enumerate() {
        return new PointInfoEnumerator(this);
    }

    private static class PointInfoEnumerator
    implements Enumeration {
        private int i;
        private IndexedDetail id;

        public PointInfoEnumerator(IndexedDetail id) {
            this.id = id;
            this.i = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.id.pointInfoArray.length;
        }

        public Object nextElement() {
            PointInfo pi = this.id.pointInfoArray[this.i];
            ++this.i;
            return pi;
        }
    }

    public static class PointInfo {
        private int colorIndex = 0;
        private int coordIndex = 0;
        private int normalIndex = 0;
        private int texCoordIndex = 0;

        public int getColorIndex() {
            return this.colorIndex;
        }

        public void setColorIndex(int i) {
            this.colorIndex = i;
        }

        public int getCoordIndex() {
            return this.coordIndex;
        }

        public void setCoordIndex(int i) {
            this.coordIndex = i;
        }

        public int getNormalIndex() {
            return this.normalIndex;
        }

        public void setNormalIndex(int i) {
            this.normalIndex = i;
        }
    }
}

