/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.NumericMap;
import java.util.Vector;

public class GroupToNumericMap
extends NumericMap {
    private int levels = 0;
    private Vector groupStarts = new Vector();
    private Vector groupLeaves = new Vector();
    private Vector groups = new Vector();
    private double stride = 1.0;
    private double firstStart = 0.0;
    private double lastStart = 0.0;
    private int lastNum = 0;

    public GroupToNumericMap(int l) {
        this.levels = l;
    }

    public int getLevels() {
        return this.levels;
    }

    public void addGroup(Vector path, Vector leaves, double start) {
        if (path.size() != this.levels - 1) {
            return;
        }
        int lnum = leaves.size();
        if (this.groups.size() == 0) {
            this.firstStart = start;
            this.lastStart = start;
            this.lastNum = lnum;
        } else {
            if (start < this.firstStart) {
                this.firstStart = start;
            }
            if (start > this.lastStart) {
                this.lastStart = start;
                this.lastNum = lnum;
            }
        }
        this.groups.addElement(path);
        this.groupLeaves.addElement(leaves);
        this.groupStarts.addElement(new Double(start));
    }

    public double getValue(Vector path) {
        if (path.size() != this.levels) {
            return this.firstStart;
        }
        Object leafVal = path.elementAt(this.levels - 1);
        path.removeElementAt(this.levels - 1);
        int gnum = this.groups.indexOf(path);
        if (gnum < 0) {
            return this.firstStart;
        }
        double start = (Double)this.groupStarts.elementAt(gnum);
        Vector leaves = (Vector)this.groupLeaves.elementAt(gnum);
        int lpos = leaves.indexOf(leafVal);
        return start + (double)lpos * this.stride;
    }

    public double getStrideValue() {
        return this.stride;
    }

    public void setStrideValue(double s) {
        this.stride = s;
    }

    public Vector getGroupPaths() {
        return this.groups;
    }

    public Vector getLeafList(int group) {
        return (Vector)this.groupLeaves.elementAt(group);
    }

    public double getGroupStart(int group) {
        return (Double)this.groupStarts.elementAt(group);
    }

    @Override
    public double getOutputMin() {
        return this.firstStart;
    }

    @Override
    public double getOutputMax() {
        return this.lastStart + (double)this.lastNum * this.stride;
    }
}

