/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.IntegerPipe;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.Pipe;
import com.sas.graphics.util.vtk.Statistic;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.VariableProcessor;
import java.util.Vector;

class GroupProcessor {
    private static final String emptyString = new String();
    public final CategoryPipe category = new CategoryPipe();
    Statistic.Bucket[][] matrix;
    int matrixLength;
    Statistic.Bucket[] totals;
    private Vector variables;
    private Vector groupPipes = new Vector();
    private int[] groupVariableIndices;
    private int groupVariableCount;
    private int[] responseVariableIndices;
    private int responseVariableCount;
    private int[] variableCategories;
    int[] valueIndexToOccupiedBucket;
    int valueCount;

    public void process(Vector allVariables, int aValueCount) {
        VariableProcessor.VEntry ve;
        int i;
        this.variables = allVariables;
        this.valueCount = aValueCount;
        this.groupVariableIndices = this.createGroupVariableIndices();
        this.groupVariableCount = this.groupVariableIndices.length;
        if (this.groupVariableCount == 0) {
            return;
        }
        this.matrixLength = 1;
        for (i = 0; i < this.groupVariableIndices.length; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(this.groupVariableIndices[i]);
            ve.uniqueValueCount = ve.variable.buildUniqueValueVector();
            this.matrixLength *= ve.uniqueValueCount;
        }
        this.responseVariableCount = this.variables.size() - this.groupVariableIndices.length;
        this.responseVariableIndices = new int[this.responseVariableCount];
        int resp = 0;
        for (i = 0; i < allVariables.size(); ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.isGroup) continue;
            this.responseVariableIndices[resp] = i;
            ve.responseIndex = resp++;
        }
        this.matrix = new Statistic.Bucket[this.matrixLength][];
        this.totals = new Statistic.Bucket[this.responseVariableCount];
        this.variableCategories = new int[this.groupVariableCount];
        for (i = 0; i < this.responseVariableCount; ++i) {
            this.totals[i] = new Statistic.Bucket();
        }
        this.createAndFillBuckets();
        this.redirect();
    }

    private int[] createGroupVariableIndices() {
        VariableProcessor.VEntry ve;
        int i;
        int[] indices = new int[]{};
        int n = this.variables.size();
        int gvCount = 0;
        for (i = 0; i < n; ++i) {
            ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (!ve.isGroup) continue;
            ++gvCount;
        }
        if (gvCount > 0) {
            indices = new int[gvCount];
            int j = 0;
            for (i = 0; i < n; ++i) {
                ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
                if (!ve.isGroup) continue;
                indices[j] = i;
                ++j;
                ve.category = ve.variable.getCategory();
            }
        }
        return indices;
    }

    private void createAndFillBuckets() {
        int valueIndex;
        int newValueCount = 0;
        for (valueIndex = 0; valueIndex < this.valueCount; ++valueIndex) {
            int resp;
            int category = this.getCategory(valueIndex);
            if (this.matrix[category] == null) {
                this.matrix[category] = new Statistic.Bucket[this.responseVariableCount];
                for (resp = 0; resp < this.responseVariableCount; ++resp) {
                    this.matrix[category][resp] = new Statistic.Bucket();
                }
                ++newValueCount;
            }
            for (resp = 0; resp < this.responseVariableCount; ++resp) {
                boolean isNumeric;
                VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(this.responseVariableIndices[resp]);
                NumericVariable nv = null;
                StringVariable sv = null;
                if (ve.variable instanceof NumericVariable) {
                    isNumeric = true;
                    nv = (NumericVariable)ve.variable;
                } else {
                    isNumeric = false;
                    sv = (StringVariable)ve.variable;
                }
                Statistic.Bucket bucket = this.matrix[category][resp];
                try {
                    if (isNumeric) {
                        double value = nv.value.getValue(valueIndex);
                        this.totals[resp].accumulate(value);
                        bucket.accumulate(value);
                        continue;
                    }
                    String stringValue = sv.value.getValue(valueIndex);
                    this.totals[resp].accumulate(stringValue);
                    bucket.accumulate(stringValue);
                    continue;
                }
                catch (MissingValueException e) {
                    this.totals[resp].accumulateMissing();
                    bucket.accumulateMissing();
                }
            }
        }
        this.valueCount = newValueCount;
        this.valueIndexToOccupiedBucket = new int[this.valueCount];
        valueIndex = 0;
        for (int i = 0; i < this.matrixLength; ++i) {
            if (this.matrix[i] == null) continue;
            this.valueIndexToOccupiedBucket[valueIndex] = i;
            ++valueIndex;
        }
    }

    private void redirect() {
        int n = this.variables.size();
        for (int i = 0; i < n; ++i) {
            VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(i);
            if (ve.variable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)ve.variable;
                NumericGroupPipe ngp = new NumericGroupPipe(this, ve);
                nv.setProcessedValuePipe(ngp, this.valueCount);
                this.groupPipes.addElement(ngp);
                continue;
            }
            StringVariable sv = (StringVariable)ve.variable;
            StringGroupPipe sgp = new StringGroupPipe(this, ve);
            sv.setProcessedValuePipe(sgp, this.valueCount);
            this.groupPipes.addElement(sgp);
        }
    }

    private int getCategory(int rawValueIndex) {
        int category;
        try {
            category = 0;
            for (int i = 0; i < this.groupVariableCount; ++i) {
                VariableProcessor.VEntry ve = (VariableProcessor.VEntry)this.variables.elementAt(this.groupVariableIndices[i]);
                int variableCategory = ve.category.getValue(rawValueIndex);
                int multiplier = 1;
                for (int j = i + 1; j < this.groupVariableCount; ++j) {
                    ve = (VariableProcessor.VEntry)this.variables.elementAt(this.groupVariableIndices[j]);
                    multiplier *= ve.uniqueValueCount;
                }
                category += variableCategory * multiplier;
            }
        }
        catch (MissingValueException e) {
            throw new Error("Missing value in category: " + rawValueIndex);
        }
        return category;
    }

    protected int MatrixIndexToVariableCategory(int matrixIndex, VariableProcessor.VEntry ve) {
        int i;
        int gi = -1;
        for (i = 0; i < this.groupVariableCount; ++i) {
            if (ve != (VariableProcessor.VEntry)this.variables.elementAt(this.groupVariableIndices[i])) continue;
            gi = i;
            break;
        }
        if (gi == -1) {
            throw new Error("Internal error. Group variable not found.");
        }
        int entriesPerCategory = this.matrixLength;
        int variableCategory = matrixIndex;
        for (i = 0; i <= gi; ++i) {
            VariableProcessor.VEntry veTemp = (VariableProcessor.VEntry)this.variables.elementAt(this.groupVariableIndices[i]);
            variableCategory %= entriesPerCategory;
            entriesPerCategory /= veTemp.uniqueValueCount;
        }
        if (gi != this.groupVariableCount - 1) {
            variableCategory /= entriesPerCategory;
        }
        return variableCategory;
    }

    private class CategoryPipe
    implements IntegerPipe {
        private CategoryPipe() {
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(GroupProcessor.this.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public int getValue(int i) {
            return GroupProcessor.this.valueIndexToOccupiedBucket[i];
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }
    }

    private static class StringGroupPipe
    extends GroupPipe
    implements StringPipe {
        public StringGroupPipe(GroupProcessor gp, VariableProcessor.VEntry ve) {
            super(gp, ve);
        }

        @Override
        public String getValue(int i) throws MissingValueException {
            String result;
            if (this.variableEntry.isGroup) {
                int uniqueValueIndex = this.getUniqueValueIndex(i);
                result = ((StringVariable)this.variableEntry.variable).uniqueValue.getValue(uniqueValueIndex);
            } else {
                int occupied = this.container.valueIndexToOccupiedBucket[i];
                Statistic.Bucket bucket = this.container.matrix[occupied][this.variableEntry.responseIndex];
                result = Statistic.getStringValue(bucket, this.variableEntry.statistic, this.container.totals[this.variableEntry.responseIndex].sum, this.container.totals[this.variableEntry.responseIndex].count);
            }
            return result;
        }
    }

    private static class NumericGroupPipe
    extends GroupPipe
    implements NumericPipe {
        public NumericGroupPipe(GroupProcessor gp, VariableProcessor.VEntry ve) {
            super(gp, ve);
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            double result;
            if (this.variableEntry.isGroup) {
                int uniqueValueIndex = this.getUniqueValueIndex(i);
                result = ((NumericVariable)this.variableEntry.variable).uniqueValue.getValue(uniqueValueIndex);
            } else {
                int occupied = this.container.valueIndexToOccupiedBucket[i];
                Statistic.Bucket bucket = this.container.matrix[occupied][this.variableEntry.responseIndex];
                result = Statistic.getValue(bucket, this.variableEntry.statistic, this.container.totals[this.variableEntry.responseIndex].sum, this.container.totals[this.variableEntry.responseIndex].count);
            }
            return result;
        }
    }

    private static class GroupPipe
    implements Pipe {
        protected GroupProcessor container;
        protected VariableProcessor.VEntry variableEntry;

        public GroupPipe(GroupProcessor gp, VariableProcessor.VEntry ve) {
            this.container = gp;
            this.variableEntry = ve;
        }

        @Override
        public void init(AInitAction initAction) {
            initAction.setValueCount(this.container.valueCount);
        }

        @Override
        public void reset(AResetAction resetAction) {
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }

        protected int getUniqueValueIndex(int i) {
            int matrixIndex = this.container.valueIndexToOccupiedBucket[i];
            int uniqueValueIndex = this.container.MatrixIndexToVariableCategory(matrixIndex, this.variableEntry);
            return uniqueValueIndex;
        }
    }
}

