/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.Style;
import java.awt.Color;

public class GridStyle
extends Style {
    private boolean verticalMinorLinesOn;
    private boolean horizontalMinorLinesOn;
    private boolean backgroundOn;
    private boolean borderOn;
    private Color majorLineColor;
    private Color minorLineColor;
    private Color backgroundColor;
    private int minorGridLineCount;
    private int lineWidth;
    private int stipplePattern;
    private int stippleFactor;
    private int minorLineWidth;
    private int minorStipplePattern;
    private int minorStippleFactor;

    public GridStyle() {
        this.verticalMinorLinesOn = false;
        this.horizontalMinorLinesOn = false;
        this.backgroundOn = true;
        this.borderOn = true;
        this.majorLineColor = Color.black;
        this.minorLineColor = Color.black;
        this.backgroundColor = Color.lightGray;
        this.minorGridLineCount = 1;
        this.minorLineWidth = 1;
        this.lineWidth = 1;
        this.minorStippleFactor = 0;
        this.stippleFactor = 0;
        this.minorStippleFactor = -1;
        this.stipplePattern = -1;
    }

    public GridStyle(GridStyle style) {
        this.verticalMinorLinesOn = style.verticalMinorLinesOn;
        this.horizontalMinorLinesOn = style.horizontalMinorLinesOn;
        this.backgroundOn = style.backgroundOn;
        this.borderOn = style.borderOn;
        this.majorLineColor = style.majorLineColor;
        this.minorLineColor = style.minorLineColor;
        this.backgroundColor = style.backgroundColor;
        this.minorGridLineCount = style.minorGridLineCount;
        this.lineWidth = style.lineWidth;
        this.minorLineWidth = style.minorLineWidth;
        this.stipplePattern = style.stipplePattern;
        this.stippleFactor = style.stippleFactor;
        this.minorStipplePattern = style.minorStipplePattern;
        this.minorStippleFactor = style.minorStippleFactor;
    }

    public void setVerticalMinorLinesOn(boolean trueOrFalse) {
        this.verticalMinorLinesOn = trueOrFalse;
    }

    public void setHorizontalMinorLinesOn(boolean trueOrFalse) {
        this.horizontalMinorLinesOn = trueOrFalse;
    }

    public void setBackgroundOn(boolean trueOrFalse) {
        this.backgroundOn = trueOrFalse;
    }

    public void setBorderOn(boolean trueOrFalse) {
        this.borderOn = trueOrFalse;
    }

    public void setMajorLineColor(Color color) {
        if (color != null) {
            this.majorLineColor = color;
        }
    }

    public void setMinorLineColor(Color color) {
        if (color != null) {
            this.minorLineColor = color;
        }
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.backgroundColor = color;
        }
    }

    public void setMinorGridLineCount(int count) {
        this.minorGridLineCount = count >= 0 ? count : 0;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public void setMinorLineWidth(int width) {
        this.minorLineWidth = width;
    }

    public void setMinorStipple(int pattern, int factor) {
        this.minorStipplePattern = pattern;
        this.minorStippleFactor = factor;
    }

    public boolean isVerticalMinorLinesOn() {
        return this.verticalMinorLinesOn;
    }

    public boolean isHorizontalMinorLinesOn() {
        return this.horizontalMinorLinesOn;
    }

    public boolean isBackgroundOn() {
        return this.backgroundOn;
    }

    public boolean isBorderOn() {
        return this.borderOn;
    }

    public Color getMajorLineColor() {
        return this.majorLineColor;
    }

    public Color getMinorLineColor() {
        return this.minorLineColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getMinorGridLineCount() {
        return this.minorGridLineCount;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public int getMinorLineWidth() {
        return this.minorLineWidth;
    }

    public int getMinorStipplePattern() {
        return this.minorStipplePattern;
    }

    public int getMinorStippleFactor() {
        return this.minorStippleFactor;
    }
}

