/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Plane;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.Action;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Connector;
import com.sas.graphics.util.vtk.NumericProperty;
import java.awt.Color;
import java.util.Vector;

public abstract class FilledLineConnector
extends Connector {
    public final ColorProperty fillColor = new ColorProperty(this, true);
    public final NumericProperty lineWidth = new NumericProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    protected double beginPointX;
    protected double beginPointY;
    protected double beginPointZ;
    protected double endPointX;
    protected double endPointY;
    protected double endPointZ;
    protected boolean skipMissing;
    protected BoundingBox fillBoundingBox;
    protected Plane fillToPlane;
    protected Vec3d depth;
    protected int stipplePattern;
    protected int stippleFactor;
    protected Vec3d minBBox;
    protected Vec3d maxBBox;
    protected boolean makeNewv1;
    protected boolean makeNewv2;
    protected boolean reverseAreaNormal = false;
    private Vec3d v1;
    private Vec3d v2;
    private Vec3d v3;
    private Vec3d v4;
    private Vec3d point;
    private Vec3d newv1;
    private Vec3d newv2;
    private Vec3d newv3;
    private Vec3d newv4;

    public FilledLineConnector(ATransform transform) {
        super(transform);
        this.fillOn.setValue(false);
        this.fillBoundingBox = new BoundingBox();
        this.fillToPlane = Plane.ZX;
        this.lineWidth.setValue(1.0);
        this.color.setValue(Color.blue);
        this.fillColor.setValue(Color.blue);
        this.depth = new Vec3d(0.0, 0.0, 0.0);
        this.stippleFactor = 0;
        this.stipplePattern = -1;
        this.point = new Vec3d();
        this.v1 = new Vec3d();
        this.v2 = new Vec3d();
        this.v3 = new Vec3d();
        this.v4 = new Vec3d();
        this.newv1 = new Vec3d();
        this.newv2 = new Vec3d();
        this.newv3 = new Vec3d();
        this.newv4 = new Vec3d();
        this.skipMissing = true;
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
    }

    public void setReverseAreaNormalOn(boolean flag) {
        this.reverseAreaNormal = flag;
    }

    public boolean getReverseAreaNormalOn() {
        return this.reverseAreaNormal;
    }

    public void setSkipMissingOn(boolean flag) {
        this.skipMissing = flag;
    }

    public boolean getSkipMissingOn() {
        return this.skipMissing;
    }

    public void setFillBoundingBox(BoundingBox boundingBox) {
        this.fillBoundingBox = boundingBox;
    }

    public BoundingBox getFillBoundingBox() {
        return this.fillBoundingBox;
    }

    public void setFillToPlane(Plane plane) {
        if (plane.isParallelTo(Plane.XY) || plane.isParallelTo(Plane.YZ) || plane.isParallelTo(Plane.ZX)) {
            this.fillToPlane = new Plane(plane);
        }
    }

    public Plane getFillToPlane() {
        return this.fillToPlane;
    }

    public void setDepth(Vec3d depth) {
        this.depth.set(depth);
    }

    public Vec3d getDepth() {
        return this.depth;
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    protected void drawFillUnder(Action action) {
        if (Double.isNaN(this.beginPointX) || Double.isNaN(this.beginPointY) || Double.isNaN(this.beginPointZ) || Double.isNaN(this.endPointX) || Double.isNaN(this.endPointY) || Double.isNaN(this.endPointZ)) {
            return;
        }
        this.minBBox = this.fillBoundingBox.getMinimum();
        this.maxBBox = this.fillBoundingBox.getMaximum();
        this.v1.set(this.beginPointX, this.beginPointY, this.beginPointZ);
        this.v2.set(this.endPointX, this.endPointY, this.endPointZ);
        this.v3.set(0.0, 0.0, 0.0);
        this.v4.set(0.0, 0.0, 0.0);
        this.newv1.set(0.0, 0.0, 0.0);
        this.newv2.set(0.0, 0.0, 0.0);
        this.newv3.set(0.0, 0.0, 0.0);
        this.newv4.set(0.0, 0.0, 0.0);
        if (this.fillBoundingBox.isEmpty()) {
            this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
        } else {
            this.makeNewv1 = false;
            this.makeNewv2 = false;
            if (this.fillBoundingBox.isPointContained(this.v1)) {
                if (!this.fillBoundingBox.isPointContained(this.v2)) {
                    Vector points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, this.v1, this.v2);
                    for (int i = 0; i < points.size(); ++i) {
                        this.point = (Vec3d)points.elementAt(i);
                        if (!this.isPointContainedInLine(this.v1, this.v2, this.point)) continue;
                        if (this.fillBoundingBox.isPointContained(this.point)) {
                            this.newv2 = this.point;
                            continue;
                        }
                        this.v2 = this.point;
                    }
                    this.makeNewv2 = true;
                    this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                } else {
                    this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                }
            } else if (this.fillBoundingBox.isPointContained(this.v2)) {
                Vector points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, this.v1, this.v2);
                for (int i = 0; i < points.size(); ++i) {
                    this.point = (Vec3d)points.elementAt(i);
                    if (!this.isPointContainedInLine(this.v1, this.v2, this.point)) continue;
                    if (this.fillBoundingBox.isPointContained(this.point)) {
                        this.newv1 = this.point;
                        continue;
                    }
                    this.v1 = this.point;
                }
                this.makeNewv1 = true;
                this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
            } else {
                Vec3d internalPoint = FilledLineConnector.getInternalPoint(this.fillBoundingBox, this.v1, this.v2);
                if (internalPoint != null) {
                    Vec3d v1Keep = new Vec3d(this.v1);
                    Vec3d v2Keep = new Vec3d(this.v2);
                    Vector points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, this.v1, internalPoint);
                    Vec3d[] values = this.modifyIntersectingValues(points, this.v1, this.newv1);
                    this.newv1.set(values[0]);
                    this.v1.set(values[1]);
                    this.v2.set(internalPoint);
                    this.makeNewv1 = true;
                    this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                    this.v1.set(v1Keep);
                    this.v2.set(v2Keep);
                    points = FilledLineConnector.getPointsOfIntersection(this.fillBoundingBox, internalPoint, this.v2);
                    values = this.modifyIntersectingValues(points, this.v2, this.newv2);
                    this.newv2.set(values[0]);
                    this.v2.set(values[1]);
                    this.v1.set(internalPoint);
                    this.makeNewv1 = false;
                    this.makeNewv2 = true;
                    this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                } else {
                    int i;
                    Vector<Plane> boundingPlanes = new Vector<Plane>(2, 2);
                    Vector<Vec3d> points = new Vector<Vec3d>(2, 2);
                    Vec3d min = this.fillBoundingBox.getMinimum();
                    Vec3d max = this.fillBoundingBox.getMaximum();
                    Plane[] planes = FilledLineConnector.getPlanesOfBoundingBox(this.fillBoundingBox);
                    for (i = 0; i < planes.length; ++i) {
                        if (planes[i].isParallelTo(this.fillToPlane)) continue;
                        boundingPlanes.addElement(planes[i]);
                    }
                    for (i = 0; i < boundingPlanes.size(); ++i) {
                        this.point = ((Plane)boundingPlanes.elementAt(i)).getPointOfIntersection(this.v1, this.v2);
                        if (this.point == null || !this.isPointContainedInLine(this.v1, this.v2, this.point) || !this.isPointContainedWithinPlanes(min, max, this.point)) continue;
                        points.addElement(new Vec3d(this.point.x, this.point.y, this.point.z));
                    }
                    if (!points.isEmpty()) {
                        if (this.isPointContainedWithinPlanes(min, max, this.v1)) {
                            if (!this.isPointContainedWithinPlanes(min, max, this.v2)) {
                                this.v2 = (Vec3d)points.elementAt(0);
                            }
                        } else if (this.isPointContainedWithinPlanes(min, max, this.v2)) {
                            this.v1 = (Vec3d)points.elementAt(0);
                        } else {
                            this.v1 = (Vec3d)points.elementAt(0);
                            this.v2 = (Vec3d)points.elementAt(1);
                        }
                        this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                    } else if (this.isPointContainedWithinPlanes(min, max, this.v1) && this.isPointContainedWithinPlanes(min, max, this.v2)) {
                        this.projectToPlaneAndDraw(action, this.v1, this.v2, this.v3, this.v4, this.newv1, this.newv2, this.newv3, this.newv4);
                    }
                }
            }
        }
    }

    protected boolean isPointContainedInLine(Vec3d lineMin, Vec3d lineMax, Vec3d point) {
        double SMALL_VALUE = 1.0E-6;
        boolean contained = false;
        Vec3d t = new Vec3d();
        double denom = lineMax.x - lineMin.x;
        if (denom > 0.0) {
            t.x = (point.x - lineMin.x) / denom;
        }
        if ((denom = lineMax.y - lineMin.y) > 0.0) {
            t.y = (point.y - lineMin.y) / denom;
        }
        if ((denom = lineMax.z - lineMin.z) > 0.0) {
            t.z = (point.z - lineMin.z) / denom;
        }
        if (t.x >= 0.0 - SMALL_VALUE && t.x <= 1.0 + SMALL_VALUE && t.y >= 0.0 - SMALL_VALUE && t.y <= 1.0 + SMALL_VALUE && t.z >= 0.0 - SMALL_VALUE && t.z <= 1.0 + SMALL_VALUE) {
            contained = true;
        }
        return contained;
    }

    protected boolean isPointContainedWithinPlanes(Vec3d min, Vec3d max, Vec3d point) {
        boolean contained = false;
        double SMALL_VALUE = 1.0E-6;
        if (this.fillToPlane.isParallelTo(Plane.XY)) {
            if (point.x >= min.x - SMALL_VALUE && point.x <= max.x + SMALL_VALUE && point.y >= min.y - SMALL_VALUE && point.y <= max.y + SMALL_VALUE) {
                contained = true;
            }
        } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
            if (point.y >= min.y - SMALL_VALUE && point.y <= max.y + SMALL_VALUE && point.z >= min.z - SMALL_VALUE && point.z <= max.z + SMALL_VALUE) {
                contained = true;
            }
        } else if (this.fillToPlane.isParallelTo(Plane.ZX) && point.x >= min.x - SMALL_VALUE && point.x <= max.x + SMALL_VALUE && point.z >= min.z - SMALL_VALUE && point.z <= max.z + SMALL_VALUE) {
            contained = true;
        }
        return contained;
    }

    protected Vec3d[] modifyIntersectingValues(Vector points, Vec3d v, Vec3d newv) {
        Vec3d[] pt = new Vec3d[2];
        int count = points.size();
        if (count == 1) {
            newv = (Vec3d)points.elementAt(0);
        } else if (count == 2) {
            double d1 = v.getDistance((Vec3d)points.elementAt(0));
            double d2 = v.getDistance((Vec3d)points.elementAt(1));
            if (d2 >= d1) {
                newv = (Vec3d)points.elementAt(1);
                v = (Vec3d)points.elementAt(0);
            } else {
                newv = (Vec3d)points.elementAt(0);
                v = (Vec3d)points.elementAt(1);
            }
        } else if (count == 3) {
            double d1 = v.getDistance((Vec3d)points.elementAt(0));
            double d2 = v.getDistance((Vec3d)points.elementAt(1));
            double d3 = v.getDistance((Vec3d)points.elementAt(2));
            if (d1 >= d2) {
                if (d1 >= d3) {
                    if (d2 >= d3) {
                        newv = (Vec3d)points.elementAt(0);
                        v = (Vec3d)points.elementAt(1);
                    } else {
                        newv = (Vec3d)points.elementAt(0);
                        v = (Vec3d)points.elementAt(2);
                    }
                } else {
                    newv = (Vec3d)points.elementAt(2);
                    v = (Vec3d)points.elementAt(0);
                }
            } else if (d2 >= d3) {
                if (d1 >= d3) {
                    newv = (Vec3d)points.elementAt(1);
                    v = (Vec3d)points.elementAt(0);
                } else {
                    newv = (Vec3d)points.elementAt(1);
                    v = (Vec3d)points.elementAt(2);
                }
            } else {
                newv = (Vec3d)points.elementAt(2);
                v = (Vec3d)points.elementAt(1);
            }
        }
        pt[0] = newv;
        pt[1] = v;
        return pt;
    }

    protected double modifyV(double v, double min, double max) {
        if (!this.fillBoundingBox.isEmpty()) {
            if (v > max && this.fillToPlane.distance < max) {
                return max;
            }
            if (v < min && this.fillToPlane.distance > min) {
                return min;
            }
        }
        return v;
    }

    protected void projectToPlaneAndDraw(Action action, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, Vec3d newv1, Vec3d newv2, Vec3d newv3, Vec3d newv4) {
        if (this.fillToPlane.isParallelTo(Plane.XY)) {
            v1.z = this.modifyV(v1.z, this.minBBox.z, this.maxBBox.z);
            v2.z = this.modifyV(v2.z, this.minBBox.z, this.maxBBox.z);
            v3.x = v2.x;
            v3.y = v2.y;
            v3.z = !this.fillBoundingBox.isEmpty() ? Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.z), this.minBBox.z) : this.fillToPlane.distance;
            v4.x = v1.x;
            v4.y = v1.y;
            v4.z = v3.z;
            if (this.makeNewv2) {
                newv2.z = this.modifyV(newv2.z, this.minBBox.z, this.maxBBox.z);
                newv3.x = newv2.x;
                newv3.y = newv2.y;
                newv3.z = v3.z;
            }
            if (this.makeNewv1) {
                newv1.z = this.modifyV(newv1.z, this.minBBox.z, this.maxBBox.z);
                newv4.x = newv1.x;
                newv4.y = newv1.y;
                newv4.z = v4.z;
            }
        } else if (this.fillToPlane.isParallelTo(Plane.YZ)) {
            v1.x = this.modifyV(v1.x, this.minBBox.x, this.maxBBox.x);
            v2.x = this.modifyV(v2.x, this.minBBox.x, this.maxBBox.x);
            v3.x = !this.fillBoundingBox.isEmpty() ? Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.x), this.minBBox.x) : this.fillToPlane.distance;
            v3.y = v2.y;
            v3.z = v2.z;
            v4.x = v3.x;
            v4.y = v1.y;
            v4.z = v1.z;
            if (this.makeNewv2) {
                newv2.x = this.modifyV(newv2.x, this.minBBox.x, this.maxBBox.x);
                newv3.x = v3.x;
                newv3.y = newv2.y;
                newv3.z = newv2.z;
            }
            if (this.makeNewv1) {
                newv1.x = this.modifyV(newv1.x, this.minBBox.x, this.maxBBox.x);
                newv4.x = v4.x;
                newv4.y = newv1.y;
                newv4.z = newv1.z;
            }
        } else if (this.fillToPlane.isParallelTo(Plane.ZX)) {
            v1.y = this.modifyV(v1.y, this.minBBox.y, this.maxBBox.y);
            v2.y = this.modifyV(v2.y, this.minBBox.y, this.maxBBox.y);
            v3.x = v2.x;
            v3.y = !this.fillBoundingBox.isEmpty() ? Math.max(Math.min(this.fillToPlane.distance, this.maxBBox.y), this.minBBox.y) : this.fillToPlane.distance;
            v3.z = v2.z;
            v4.x = v1.x;
            v4.y = v3.y;
            v4.z = v1.z;
            if (this.makeNewv2) {
                newv2.y = this.modifyV(newv2.y, this.minBBox.y, this.maxBBox.y);
                newv3.x = newv2.x;
                newv3.y = v3.y;
                newv3.z = newv2.z;
            }
            if (this.makeNewv1) {
                newv1.y = this.modifyV(newv1.y, this.minBBox.y, this.maxBBox.y);
                newv4.x = newv1.x;
                newv4.y = v4.y;
                newv4.z = newv1.z;
            }
        }
        if (this.makeNewv1 || this.makeNewv2) {
            if (this.makeNewv1) {
                this.drawArea(action, v1, newv1, newv4, v4);
                this.drawArea(action, newv1, v2, v3, newv4);
            } else if (this.makeNewv2) {
                this.drawArea(action, v1, newv2, newv3, v4);
                this.drawArea(action, newv2, v2, v3, newv3);
            }
        } else {
            this.drawArea(action, v1, v2, v3, v4);
        }
    }

    protected void drawArea(Action action, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4) {
        if (this.fillBoundingBox.isEmpty() || this.fillBoundingBox.isPointContained(v1) && this.fillBoundingBox.isPointContained(v2) && this.fillBoundingBox.isPointContained(v3) && this.fillBoundingBox.isPointContained(v4)) {
            Vec3d edge1 = new Vec3d(v2.x - v1.x, v2.y - v1.y, v2.z - v1.z);
            Vec3d edge2 = new Vec3d(v4.x - v1.x, v4.y - v1.y, v4.z - v1.z);
            boolean positiveBegin = this.fillToPlane.isOnPositiveSide(v1);
            boolean positiveEnd = this.fillToPlane.isOnPositiveSide(v2);
            int drawMode = 2;
            if (this.depth.length() > 0.0) {
                drawMode = 3;
            }
            if (positiveBegin && positiveEnd) {
                if (!this.reverseAreaNormal) {
                    edge2.cross(edge1);
                    this.drawTrapezoid(action, drawMode, edge2, v1, v2, v3, v4);
                } else {
                    edge1.cross(edge2);
                    this.drawTrapezoid(action, drawMode, edge1, v4, v3, v2, v1);
                }
            } else if (!positiveBegin && !positiveEnd) {
                if (!this.reverseAreaNormal) {
                    edge1.cross(edge2);
                    this.drawTrapezoid(action, drawMode, edge1, v1, v2, v3, v4);
                } else {
                    edge2.cross(edge1);
                    this.drawTrapezoid(action, drawMode, edge2, v4, v3, v2, v1);
                }
            } else {
                Vec3d intersectionPoint = new Vec3d();
                intersectionPoint = this.fillToPlane.getPointOfIntersection(v1, v2);
                if (!this.reverseAreaNormal) {
                    if (positiveBegin) {
                        edge2.cross(edge1);
                        this.drawTrapezoid(action, drawMode, edge2, v1, intersectionPoint, intersectionPoint, v4);
                        this.drawTrapezoid(action, drawMode, edge2, intersectionPoint, v2, v3, intersectionPoint);
                    } else {
                        edge1.cross(edge2);
                        this.drawTrapezoid(action, drawMode, edge1, v4, intersectionPoint, intersectionPoint, v1);
                        this.drawTrapezoid(action, drawMode, edge1, intersectionPoint, v3, v2, intersectionPoint);
                    }
                } else if (positiveBegin) {
                    edge1.cross(edge2);
                    this.drawTrapezoid(action, drawMode, edge1, v4, intersectionPoint, intersectionPoint, v1);
                    this.drawTrapezoid(action, drawMode, edge1, intersectionPoint, v3, v2, intersectionPoint);
                } else {
                    edge2.cross(edge1);
                    this.drawTrapezoid(action, drawMode, edge2, v1, intersectionPoint, intersectionPoint, v4);
                    this.drawTrapezoid(action, drawMode, edge2, intersectionPoint, v2, v3, intersectionPoint);
                }
            }
        }
    }

    protected abstract void drawTrapezoid(Action var1, int var2, Vec3d var3, Vec3d var4, Vec3d var5, Vec3d var6, Vec3d var7);

    public static Plane[] getPlanesOfBoundingBox(BoundingBox bbox) {
        Plane[] planes = new Plane[6];
        Vec3d min = bbox.getMinimum();
        Vec3d max = bbox.getMaximum();
        planes[0] = new Plane(1.0, 0.0, 0.0, min.x);
        planes[1] = new Plane(0.0, 0.0, 1.0, max.z);
        planes[2] = new Plane(1.0, 0.0, 0.0, max.x);
        planes[3] = new Plane(0.0, 0.0, 1.0, min.z);
        planes[4] = new Plane(0.0, 1.0, 0.0, max.y);
        planes[5] = new Plane(0.0, 1.0, 0.0, min.y);
        return planes;
    }

    public static Vector getPointsOfIntersection(BoundingBox bbox, Vec3d beginLine, Vec3d endLine) {
        Vector<Vec3d> points = new Vector<Vec3d>(2, 2);
        Plane[] planes = FilledLineConnector.getPlanesOfBoundingBox(bbox);
        Vec3d point = new Vec3d();
        for (int i = 0; i < planes.length; ++i) {
            boolean positiveBegin = planes[i].isOnPositiveSide(beginLine);
            boolean positiveEnd = planes[i].isOnPositiveSide(endLine);
            if ((!positiveBegin || positiveEnd) && (positiveBegin || !positiveEnd)) continue;
            point = planes[i].getPointOfIntersection(beginLine, endLine);
            points.addElement(new Vec3d(point.x, point.y, point.z));
        }
        return points;
    }

    public static Vec3d getInternalPoint(BoundingBox bbox, Vec3d beginLine, Vec3d endLine) {
        int count = 0;
        Vec3d point = new Vec3d();
        Vector allPoints = new Vector(2, 2);
        Vec3d[] twoPoints = new Vec3d[2];
        allPoints = FilledLineConnector.getPointsOfIntersection(bbox, beginLine, endLine);
        for (int i = 0; i < allPoints.size(); ++i) {
            point = (Vec3d)allPoints.elementAt(i);
            if (!bbox.isPointContained(point)) continue;
            twoPoints[count] = point;
            ++count;
        }
        if (twoPoints[0] != null && twoPoints[1] != null) {
            point.x = (twoPoints[0].x + twoPoints[1].x) / 2.0;
            point.y = (twoPoints[0].y + twoPoints[1].y) / 2.0;
            point.z = (twoPoints[0].z + twoPoints[1].z) / 2.0;
        } else {
            point = null;
        }
        return point;
    }
}

