/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.VTKRuntimeException;
import com.sas.graphics.util.vtk.Variable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Expression
extends PropertyContainer {
    public static final int NUMERIC = 0;
    public static final int BOOLEAN = 1;
    public static final int STRING = 2;
    public static final int NUMERICVARIABLE = 3;
    public static final int STRINGVARIABLE = 4;
    public static final int RELATIONAL = 5;
    public static final int IDENTITY = 6;
    protected static final int UNARYMINUS = 1;
    protected static final int LN = 2;
    protected static final int TAN = 3;
    protected static final int COS = 4;
    protected static final int SIN = 5;
    protected static final int EXP = 6;
    protected static final int OPEN = 7;
    protected static final int MULT = 8;
    protected static final int DIV = 9;
    protected static final int PLUS = 10;
    protected static final int MINUS = 11;
    protected static final int CLOSE = 12;
    protected static final int LT = 13;
    protected static final int LE = 14;
    protected static final int GT = 15;
    protected static final int GE = 16;
    protected static final int EQ = 17;
    protected static final int NE = 18;
    protected static final int NOT = 19;
    protected static final int AND = 20;
    protected static final int OR = 21;
    protected static final int MOD = 22;
    protected static final int MISSING = 23;
    protected static final int IF = 24;
    protected static final int ELSE = 25;
    protected static final int LIKE = 26;
    protected static final int SQRT = 27;
    private static final Operator UNARYMINUSop = new Operator("-", 1, 1, 0, true);
    private static final Operator NOTop = new Operator("^", 19, 1, 1, true);
    private static final Operator LNop = new Operator("ln", 2, 2, 0, true);
    private static final Operator TANop = new Operator("tan", 3, 2, 0, true);
    private static final Operator COSop = new Operator("cos", 4, 2, 0, true);
    private static final Operator SINop = new Operator("sin", 5, 2, 0, true);
    private static final Operator SQRTop = new Operator("sqrt", 27, 2, 0, true);
    private static final Operator EXPop = new Operator("exp", 6, 2, 0, false);
    private static final Operator MULTop = new Operator("*", 8, 3, 0, false);
    private static final Operator DIVop = new Operator("/", 9, 3, 0, false);
    private static final Operator MODop = new Operator("%", 22, 3, 0, false);
    private static final Operator PLUSop = new Operator("+", 10, 4, 0, false);
    private static final Operator MINUSop = new Operator("-", 11, 4, 0, false);
    private static final Operator ANDop = new Operator("&", 20, 7, 1, false);
    private static final Operator ORop = new Operator("|", 21, 8, 1, false);
    private static final Operator OPENop = new Operator("(", 7, 21, 0, true);
    private static final Operator CLOSEop = new Operator(")", 12, 20, 0, false);
    private static final Operator IFop = new Operator("?", 24, 10, 0, false);
    private static final Operator ELSEop = new Operator(":", 25, 9, 0, false);
    private String expression;
    private final String delimiters = " +-/*%()^><=|&?:\"";
    private Vector operandList = new Vector();
    private Vector userOperandList = new Vector();
    private Op[] postfix;
    private int postfixTop = 0;
    private ValueStack valueStack;

    public Expression(String anExpression) {
        this();
        this.setExpression(anExpression);
    }

    public Expression() {
        this.operandList.addElement(new Operand("pi", 0, Math.PI, true));
        this.operandList.addElement(new Operand("obs", 6, 0.0, true));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() {
        String token = " ";
        int depth = 0;
        boolean lastTokenWasOperand = false;
        boolean lookedAhead = false;
        StringTokenizer parser = new StringTokenizer(this.expression, " +-/*%()^><=|&?:\"", true);
        int tokenCount = parser.countTokens();
        this.postfix = new Op[tokenCount];
        Operator[] operatorStack = new Operator[tokenCount];
        this.postfixTop = 0;
        while (parser.hasMoreTokens() || lookedAhead) {
            void var4_8;
            void var4_33;
            void var4_31;
            if (lookedAhead) {
                lookedAhead = false;
            } else {
                token = parser.nextToken();
            }
            if (token.equals(" ")) continue;
            Object var4_9 = null;
            if (token.length() == 1) {
                if (token.equals("\"")) {
                    StringBuffer aLiteral = new StringBuffer();
                    token = parser.nextToken();
                    while (!token.equals("\"")) {
                        aLiteral.append(token);
                        token = parser.nextToken();
                    }
                    Operand operand = new Operand(aLiteral, false);
                    this.operandList.addElement(operand);
                } else if (token.equals("-")) {
                    if (lastTokenWasOperand) {
                        Operator operator = MINUSop;
                    } else {
                        Operator operator = UNARYMINUSop;
                    }
                } else if (token.equals(")")) {
                    Operator operator = CLOSEop;
                } else if (token.equals("+")) {
                    Operator operator = PLUSop;
                } else if (token.equals("/")) {
                    Operator operator = DIVop;
                } else if (token.equals("*")) {
                    token = parser.nextToken();
                    if (token.equals("*")) {
                        Operator operator = EXPop;
                    } else {
                        lookedAhead = true;
                        Operator operator = MULTop;
                    }
                } else if (token.equals("(")) {
                    Operator operator = OPENop;
                } else if (token.equals("=")) {
                    Operator operator = new Operator("=", 17, 6, 5, false);
                    token = parser.nextToken();
                    if (!token.equals("=")) {
                        lookedAhead = true;
                    }
                } else if (token.equals("<")) {
                    token = parser.nextToken();
                    if (token.equals("=")) {
                        Operator operator = new Operator("<=", 14, 5, 5, false);
                    } else {
                        lookedAhead = true;
                        Operator operator = new Operator("<", 13, 5, 5, false);
                    }
                } else if (token.equals(">")) {
                    token = parser.nextToken();
                    if (token.equals("=")) {
                        Operator operator = new Operator(">=", 16, 5, 5, false);
                    } else {
                        lookedAhead = true;
                        Operator operator = new Operator(">", 15, 5, 5, false);
                    }
                } else if (token.equals("&")) {
                    Operator operator = ANDop;
                    token = parser.nextToken();
                    if (!token.equals("&")) {
                        lookedAhead = true;
                    }
                } else if (token.equals("|")) {
                    Operator operator = ORop;
                    token = parser.nextToken();
                    if (!token.equals("|")) {
                        lookedAhead = true;
                    }
                } else if (token.equals("%")) {
                    Operator operator = MODop;
                } else if (token.equals("^")) {
                    token = parser.nextToken();
                    if (token.equals("=")) {
                        Operator operator = new Operator("^=", 18, 6, 5, false);
                    } else {
                        lookedAhead = true;
                        Operator operator = NOTop;
                    }
                } else if (token.equals("?")) {
                    Operator operator = IFop;
                } else if (token.equals(":")) {
                    Operator operator = ELSEop;
                }
            }
            if (var4_31 == null) {
                int count = this.operandList.size();
                for (int i = 0; i < count; ++i) {
                    if (!((Operand)this.operandList.elementAt(i)).isNamed(token)) continue;
                    Operand operand = (Operand)this.operandList.elementAt(i);
                    break;
                }
            }
            if (var4_33 == null) {
                String uc = token.toUpperCase();
                if (uc.equals("LT")) {
                    Operator operator = new Operator("<", 13, 5, 5, false);
                } else if (uc.equals("LE")) {
                    Operator operator = new Operator("<=", 14, 5, 5, false);
                } else if (uc.equals("GT")) {
                    Operator operator = new Operator(">", 15, 5, 5, false);
                } else if (uc.equals("GE")) {
                    Operator operator = new Operator(">=", 16, 5, 5, false);
                } else if (uc.equals("EQ")) {
                    Operator operator = new Operator("=", 17, 6, 5, false);
                } else if (uc.equals("NE")) {
                    Operator operator = new Operator("^=", 18, 6, 5, false);
                } else if (uc.equals("LIKE")) {
                    Operator operator = new Operator("like", 26, 5, 5, false);
                } else if (uc.equals("NOT")) {
                    Operator operator = NOTop;
                } else if (uc.equals("OR")) {
                    Operator operator = ORop;
                } else if (uc.equals("AND")) {
                    Operator operator = ANDop;
                } else if (uc.equals("IS")) {
                    token = parser.nextToken();
                    while (token.equals(" ")) {
                        token = parser.nextToken();
                    }
                    if (!token.equalsIgnoreCase("MISSING")) throw new VTKRuntimeException("(Expression) MISSING expected at: " + token);
                    Operator operator = new Operator("missing", 23, 0, 1, true);
                } else if (uc.equals("TAN")) {
                    Operator operator = TANop;
                } else if (uc.equals("COS")) {
                    Operator operator = COSop;
                } else if (uc.equals("SIN")) {
                    Operator operator = SINop;
                } else if (uc.equals("LN")) {
                    Operator operator = LNop;
                } else if (uc.equals("SQRT")) {
                    Operator operator = SQRTop;
                } else {
                    Operand operand = new Operand(token, false);
                    this.operandList.addElement(operand);
                }
            }
            if (var4_8 instanceof Operand) {
                if (lastTokenWasOperand) {
                    throw new VTKRuntimeException("(Expression) Operator expected at: " + token);
                }
                lastTokenWasOperand = true;
                this.addToPostfix((Operand)var4_8);
                continue;
            }
            Operator function = (Operator)var4_8;
            if (function.opcode == 23) {
                if (!lastTokenWasOperand) {
                    throw new VTKRuntimeException("(Expression) Variable expected for MISSING operator.");
                }
            } else if (function.isUnary) {
                if (lastTokenWasOperand) {
                    throw new VTKRuntimeException("(Expression) Operator expected before: " + function.symbol);
                }
            } else if (!lastTokenWasOperand) {
                throw new VTKRuntimeException("(Expression) Operand expected before: " + function.symbol);
            }
            if (function != OPENop) {
                while (depth > 0 && operatorStack[depth - 1].precedence <= function.precedence) {
                    this.addToPostfix(operatorStack[--depth]);
                }
            }
            if (function == CLOSEop) {
                if (depth == 0 || operatorStack[--depth] != OPENop) {
                    throw new VTKRuntimeException("(Expression) Unbalanced parentheses.");
                }
                lastTokenWasOperand = true;
                continue;
            }
            operatorStack[depth++] = function;
            lastTokenWasOperand = function.opcode == 23;
        }
        while (depth > 0) {
            this.addToPostfix(operatorStack[--depth]);
        }
        this.valueStack = new ValueStack(this.postfixTop > 0 ? this.postfixTop : 1);
    }

    public void dumpPostfix() {
        Debug.setDebug((boolean)true);
        Debug.println((String)" ");
        for (int i = this.postfixTop - 1; i >= 0; --i) {
            Op o = this.postfix[i];
            Debug.println((String)o.symbol);
        }
        Debug.setDebug((boolean)false);
    }

    private void addToPostfix(Operator theOperator) {
        Op rightOperand = this.postfix[this.postfixTop - 1];
        if (theOperator.opcode == 23) {
            if (rightOperand.type != 3 && rightOperand.type != 4) {
                throw new VTKRuntimeException("(Expression) MISSING operand type incorrect.");
            }
            theOperator.MissingTarget = ((Operand)rightOperand).variable;
            this.postfix[this.postfixTop - 1] = theOperator;
            return;
        }
        if (!theOperator.isUnary) {
            int i = this.postfixTop - 1;
            for (int leftOperandOffset = -1; leftOperandOffset < 0; ++leftOperandOffset) {
                if (this.postfix[i] instanceof Operator && ((Operator)this.postfix[i]).opcode != 23) {
                    leftOperandOffset -= ((Operator)this.postfix[i]).isUnary ? 1 : 2;
                }
                --i;
            }
            Op leftOperand = this.postfix[i];
            if (theOperator.opcode == 24) {
                if (leftOperand.resultsInType != 1 || rightOperand.resultsInType != 0) {
                    throw new VTKRuntimeException("(Expression) IF-ELSE operands type mismatch.");
                }
            } else if (leftOperand.resultsInType != rightOperand.resultsInType) {
                throw new VTKRuntimeException("(Expression) Operands type mismatch for '" + theOperator.symbol + "' operator.");
            }
        }
        block0 : switch (theOperator.type) {
            case 0: 
            case 1: 
            case 2: {
                if (theOperator.resultsInType == rightOperand.resultsInType) break;
                throw new VTKRuntimeException("(Expression) Operand type incorrect for '" + theOperator.symbol + "' operator.");
            }
            case 5: {
                if (theOperator.opcode == 26) {
                    theOperator.type = 2;
                    break;
                }
                switch (rightOperand.resultsInType) {
                    case 0: {
                        theOperator.type = 0;
                        break block0;
                    }
                    case 2: {
                        theOperator.type = 2;
                        break block0;
                    }
                    case 1: {
                        if (theOperator.opcode != 17) {
                            throw new VTKRuntimeException("(Expression) Operand type incorrect for '" + theOperator.symbol + "' operator.");
                        }
                        theOperator.type = 1;
                    }
                }
            }
        }
        this.postfix[this.postfixTop++] = theOperator;
    }

    private void addToPostfix(Operand entry) {
        this.postfix[this.postfixTop++] = entry;
    }

    public void addOperand(String name, NumericPipe aPipe, boolean anyCase) {
        Operand operand = new Operand(name, aPipe, anyCase);
        this.operandList.addElement(operand);
        this.userOperandList.addElement(operand);
    }

    public void addOperand(String name, StringPipe aPipe, boolean anyCase) {
        Operand operand = new Operand(name, aPipe, anyCase);
        this.operandList.addElement(operand);
        this.userOperandList.addElement(operand);
    }

    public void addOperand(String name, NumericVariable aVar, boolean anyCase) {
        Operand operand = new Operand(name, aVar, anyCase);
        this.operandList.addElement(operand);
        this.userOperandList.addElement(operand);
    }

    public void addOperand(String name, StringVariable aVar, boolean anyCase) {
        Operand operand = new Operand(name, aVar, anyCase);
        this.operandList.addElement(operand);
        this.userOperandList.addElement(operand);
    }

    public void removeOperands() {
        for (int i = 0; i < this.userOperandList.size(); ++i) {
            this.operandList.removeElement(this.userOperandList.elementAt(i));
        }
        this.userOperandList.removeAllElements();
    }

    public int getEvaluationType() {
        if (this.postfixTop == 0) {
            return 1;
        }
        return this.postfix[this.postfixTop - 1].resultsInType;
    }

    public void setExpression(String anExpression) {
        this.expression = anExpression;
        this.setModified();
    }

    public String getExpression() {
        return this.expression;
    }

    public MultiTypedValue evaluate(int index) throws MissingValueException {
        if (this.postfixTop == 0) {
            this.valueStack.push(true);
        }
        this.valueStack.top = 0;
        for (int i = 0; i < this.postfixTop; ++i) {
            Op op = this.postfix[i];
            op.evaluate(this.valueStack, index);
        }
        return this.valueStack.pop();
    }

    private static class Operand
    extends Op {
        double literalValue;
        boolean caseless;
        Variable variable;
        NumericPipe numericData;
        StringPipe stringData;

        Operand(String name, NumericPipe aPipe, boolean anyCase) {
            super(name, 0, 0);
            this.caseless = anyCase;
            this.numericData = aPipe;
        }

        Operand(String name, StringPipe aPipe, boolean anyCase) {
            super(name, 2, 2);
            this.caseless = anyCase;
            this.stringData = aPipe;
        }

        Operand(String name, NumericVariable aVar, boolean anyCase) {
            super(name, 3, 0);
            this.caseless = anyCase;
            this.variable = aVar;
            this.numericData = aVar.value;
        }

        Operand(String name, StringVariable aVar, boolean anyCase) {
            super(name, 4, 2);
            this.caseless = anyCase;
            this.variable = aVar;
            this.stringData = aVar.value;
        }

        Operand(String aLiteral, int aType, double value, boolean anyCase) {
            super(aLiteral, aType, 0);
            this.caseless = anyCase;
            this.literalValue = value;
        }

        Operand(String aLiteral, boolean anyCase) {
            super(aLiteral, 0, 0);
            this.caseless = anyCase;
            try {
                this.literalValue = Double.valueOf(aLiteral);
            }
            catch (NumberFormatException except) {
                throw new VTKRuntimeException("(Expression) Unrecognized operand: " + aLiteral);
            }
        }

        Operand(StringBuffer aLiteral, boolean anyCase) {
            super(aLiteral.toString(), 0, 2);
            this.caseless = anyCase;
        }

        @Override
        void evaluate(ValueStack stack, int index) {
            if (this.type == 6) {
                stack.push(index);
            } else {
                switch (this.resultsInType) {
                    case 0: {
                        if (this.numericData != null) {
                            double d;
                            try {
                                d = this.numericData.getValue(index);
                            }
                            catch (MissingValueException e) {
                                d = Double.NaN;
                            }
                            stack.push(d);
                            break;
                        }
                        stack.push(this.literalValue);
                        break;
                    }
                    case 2: {
                        if (this.stringData != null) {
                            String str;
                            try {
                                str = this.stringData.getValue(index);
                            }
                            catch (MissingValueException e) {
                                str = null;
                            }
                            stack.push(str);
                            break;
                        }
                        stack.push(this.symbol);
                    }
                }
            }
        }

        boolean isNamed(String name) {
            return this.caseless ? this.symbol.equalsIgnoreCase(name) : this.symbol.equals(name);
        }
    }

    private static class Operator
    extends Op {
        int opcode;
        int precedence;
        boolean isUnary;
        Variable MissingTarget;

        Operator(String sym, int oc, int aPrecedence, int aType, boolean unary) {
            super(sym, aType, aType == 5 ? 1 : aType);
            this.opcode = oc;
            this.precedence = aPrecedence;
            this.isUnary = unary;
        }

        private boolean wildcardMatch(String pattern, String str) {
            char[] s = str.toCharArray();
            int si = 0;
            boolean skip = false;
            StringTokenizer parser = new StringTokenizer(pattern, "%", true);
            int tokenCount = parser.countTokens();
            while (tokenCount-- > 0) {
                String token = parser.nextToken();
                if (token.equals("%")) {
                    skip = true;
                    continue;
                }
                char[] p = token.toCharArray();
                int pi = 0;
                int starti = si;
                while (pi < p.length) {
                    if (si == s.length) {
                        return false;
                    }
                    switch (p[pi]) {
                        case '_': {
                            ++pi;
                            ++si;
                            break;
                        }
                        default: {
                            if (s[si] == p[pi]) {
                                ++pi;
                                ++si;
                                break;
                            }
                            if (skip) {
                                pi = 0;
                                si = ++starti;
                                break;
                            }
                            return false;
                        }
                    }
                    if (pi != p.length || !skip || tokenCount != 0 || si >= s.length) continue;
                    pi = 0;
                    si = ++starti;
                }
                skip = false;
            }
            return si == s.length || skip;
        }

        @Override
        void evaluate(ValueStack s, int index) throws MissingValueException {
            switch (this.opcode) {
                case 1: {
                    s.push(-s.popDouble());
                    break;
                }
                case 10: {
                    s.push(s.popDouble() + s.popDouble());
                    break;
                }
                case 11: {
                    s.push(-s.popDouble() + s.popDouble());
                    break;
                }
                case 8: {
                    s.push(s.popDouble() * s.popDouble());
                    break;
                }
                case 22: {
                    double d = s.popDouble();
                    s.push(s.popDouble() % d);
                    break;
                }
                case 9: {
                    double d = s.popDouble();
                    s.push(s.popDouble() / d);
                    break;
                }
                case 3: {
                    s.push(Math.tan(s.popDouble()));
                    break;
                }
                case 4: {
                    s.push(Math.cos(s.popDouble()));
                    break;
                }
                case 5: {
                    s.push(Math.sin(s.popDouble()));
                    break;
                }
                case 2: {
                    s.push(Math.log(s.popDouble()));
                    break;
                }
                case 27: {
                    s.push(Math.sqrt(s.popDouble()));
                    break;
                }
                case 6: {
                    double d = s.popDouble();
                    s.push(Math.pow(s.popDouble(), d));
                    break;
                }
                case 23: {
                    s.push(this.MissingTarget.isMissing(index));
                    break;
                }
                case 19: {
                    s.push(!s.popBoolean());
                    break;
                }
                case 20: {
                    boolean r = s.popBoolean();
                    boolean l = s.popBoolean();
                    s.push(l && r);
                    break;
                }
                case 21: {
                    boolean r = s.popBoolean();
                    boolean l = s.popBoolean();
                    s.push(l || r);
                    break;
                }
                case 26: {
                    boolean l = this.wildcardMatch(s.popString(), s.popString());
                    s.push(l);
                    break;
                }
                case 24: {
                    double dl;
                    double d;
                    try {
                        d = s.popDouble();
                    }
                    catch (MissingValueException e) {
                        d = Double.NaN;
                    }
                    try {
                        dl = s.popDouble();
                    }
                    catch (MissingValueException e) {
                        dl = Double.NaN;
                    }
                    if (s.popBoolean()) {
                        if (Double.isNaN(dl)) {
                            throw MissingValueException.getDefaultMissingValueExeption();
                        }
                        s.push(dl);
                        break;
                    }
                    if (Double.isNaN(d)) {
                        throw MissingValueException.getDefaultMissingValueExeption();
                    }
                    s.push(d);
                    break;
                }
                case 15: {
                    switch (this.type) {
                        case 0: {
                            boolean r;
                            try {
                                r = s.popDouble() < s.popDouble();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 2: {
                            boolean r;
                            try {
                                r = s.popString().compareTo(s.popString()) < 0;
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                        }
                    }
                    break;
                }
                case 16: {
                    switch (this.type) {
                        case 0: {
                            boolean r;
                            try {
                                r = s.popDouble() <= s.popDouble();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 2: {
                            boolean r;
                            try {
                                r = s.popString().compareTo(s.popString()) <= 0;
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                        }
                    }
                    break;
                }
                case 13: {
                    switch (this.type) {
                        case 0: {
                            boolean r;
                            try {
                                r = s.popDouble() > s.popDouble();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 2: {
                            boolean r;
                            try {
                                r = s.popString().compareTo(s.popString()) > 0;
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                        }
                    }
                    break;
                }
                case 14: {
                    switch (this.type) {
                        case 0: {
                            boolean r;
                            try {
                                r = s.popDouble() >= s.popDouble();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 2: {
                            boolean r;
                            try {
                                r = s.popString().compareTo(s.popString()) >= 0;
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                        }
                    }
                    break;
                }
                case 17: {
                    switch (this.type) {
                        case 0: {
                            boolean r;
                            try {
                                r = s.popDouble() == s.popDouble();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 2: {
                            boolean r;
                            try {
                                r = s.popString().compareTo(s.popString()) == 0;
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 1: {
                            boolean r;
                            try {
                                r = s.popBoolean() == s.popBoolean();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                        }
                    }
                    break;
                }
                case 18: {
                    switch (this.type) {
                        case 0: {
                            boolean r;
                            try {
                                r = s.popDouble() != s.popDouble();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 2: {
                            boolean r;
                            try {
                                r = s.popString().compareTo(s.popString()) != 0;
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                            break;
                        }
                        case 1: {
                            boolean r;
                            try {
                                r = s.popBoolean() != s.popBoolean();
                            }
                            catch (MissingValueException e) {
                                r = false;
                            }
                            s.push(r);
                        }
                    }
                    break;
                }
            }
        }
    }

    private static abstract class Op {
        String symbol;
        int type;
        int resultsInType;

        abstract void evaluate(ValueStack var1, int var2) throws MissingValueException;

        protected Op(String aSymbol, int aType, int aResultType) {
            this.symbol = aSymbol;
            this.type = aType;
            this.resultsInType = aResultType;
        }
    }

    private static class ValueStack {
        MultiTypedValue[] vs;
        int top = 0;

        ValueStack(int capacity) {
            this.vs = new MultiTypedValue[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.vs[i] = new MultiTypedValue();
            }
        }

        void push(String value) {
            ++this.top;
            this.vs[this.top].stringValue = value;
        }

        String popString() throws MissingValueException {
            if (this.vs[--this.top].stringValue == null) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return this.vs[this.top].stringValue;
        }

        void push(double value) {
            ++this.top;
            this.vs[this.top].doubleValue = value;
        }

        double popDouble() throws MissingValueException {
            if (Double.isNaN(this.vs[--this.top].doubleValue)) {
                throw MissingValueException.getDefaultMissingValueExeption();
            }
            return this.vs[this.top].doubleValue;
        }

        void push(boolean value) {
            ++this.top;
            this.vs[this.top].booleanValue = value;
        }

        boolean popBoolean() throws MissingValueException {
            return this.vs[--this.top].booleanValue;
        }

        MultiTypedValue pop() {
            return this.vs[--this.top];
        }
    }

    public static class MultiTypedValue {
        String stringValue;
        double doubleValue;
        boolean booleanValue;
    }
}

