/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.PropertyContainer;

public class EndpointsToTransform
extends PropertyContainer {
    public final NumericProperty beginX = new NumericProperty(this, true);
    public final NumericProperty beginY = new NumericProperty(this, true);
    public final NumericProperty beginZ = new NumericProperty(this, true);
    public final NumericProperty endX = new NumericProperty(this, true);
    public final NumericProperty endY = new NumericProperty(this, true);
    public final NumericProperty endZ = new NumericProperty(this, true);
    private CalculatedProperty translateXProperty = new CalculatedProperty(this);
    public final NumericPipe translateX = this.translateXProperty;
    private CalculatedProperty translateYProperty = new CalculatedProperty(this);
    public final NumericPipe translateY = this.translateYProperty;
    private CalculatedProperty translateZProperty = new CalculatedProperty(this);
    public final NumericPipe translateZ = this.translateZProperty;
    private CalculatedProperty rotationAxisXProperty = new CalculatedProperty(this);
    public final NumericPipe rotationAxisX = this.rotationAxisXProperty;
    private CalculatedProperty rotationAxisYProperty = new CalculatedProperty(this);
    public final NumericPipe rotationAxisY = this.rotationAxisYProperty;
    private CalculatedProperty rotationAxisZProperty = new CalculatedProperty(this);
    public final NumericPipe rotationAxisZ = this.rotationAxisZProperty;
    private CalculatedProperty rotationAngleProperty = new CalculatedProperty(this);
    public final NumericPipe rotationAngle = this.rotationAngleProperty;
    private CalculatedProperty lengthProperty = new CalculatedProperty(this);
    public final NumericPipe length = this.lengthProperty;
    protected int previousIndex;
    private Vec3d begin = new Vec3d();
    private Vec3d v = new Vec3d();
    private Vec3d yAxis;
    private Vec3d rAxis = new Vec3d();

    public EndpointsToTransform() {
        this.yAxis = Vec3d.getYAxis();
    }

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        this.previousIndex = -1;
    }

    void calculate(int index) {
        this.previousIndex = index;
        try {
            this.begin.set(this.beginX.getValue(index), this.beginY.getValue(index), this.beginZ.getValue(index));
            this.v.set(this.endX.getValue(index), this.endY.getValue(index), this.endZ.getValue(index));
            this.v.subtract(this.begin);
            this.rAxis.set(this.yAxis);
            this.rAxis.cross(this.v);
            this.translateXProperty.setValue(this.begin.x + this.v.x * 0.5);
            this.translateYProperty.setValue(this.begin.y + this.v.y * 0.5);
            this.translateZProperty.setValue(this.begin.z + this.v.z * 0.5);
            this.rotationAxisXProperty.setValue(this.rAxis.x);
            this.rotationAxisYProperty.setValue(this.rAxis.y);
            this.rotationAxisZProperty.setValue(this.rAxis.z);
            this.rotationAngleProperty.setValue(this.yAxis.angle(this.v));
            this.lengthProperty.setValue(this.v.length());
        }
        catch (MissingValueException e) {
            this.translateXProperty.setValue(Double.NaN);
            this.translateYProperty.setValue(Double.NaN);
            this.translateZProperty.setValue(Double.NaN);
            this.rotationAxisXProperty.setValue(Double.NaN);
            this.rotationAxisYProperty.setValue(Double.NaN);
            this.rotationAxisZProperty.setValue(Double.NaN);
            this.rotationAngleProperty.setValue(Double.NaN);
            this.lengthProperty.setValue(Double.NaN);
        }
    }

    private class CalculatedProperty
    extends NumericProperty {
        PropertyContainer owner;

        public CalculatedProperty(PropertyContainer aContainer) {
            this.owner = aContainer;
        }

        @Override
        public void init(AInitAction initAction) {
            this.owner.init(initAction);
        }

        @Override
        public double getValue(int index) throws MissingValueException {
            if (index != EndpointsToTransform.this.previousIndex) {
                EndpointsToTransform.this.calculate(index);
            }
            return this.getValue();
        }
    }
}

