/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.vtk.ABuildAction;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.Action;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.PropertyContainer;
import com.sas.graphics.util.vtk.SelectDetail;
import com.sas.graphics.util.vtk.SelectEntry;

public abstract class Element
extends PropertyContainer {
    private Object userData;
    private int valueCount;
    public final BooleanProperty selectEnabled = new BooleanProperty(this, true);
    public final BooleanProperty selectDetailEnabled = new BooleanProperty(this, true);
    public final ATransform transform;

    protected Element(ATransform aTransform) {
        this.selectEnabled.setValue(true);
        this.selectDetailEnabled.setValue(false);
        this.valueCount = -1;
        this.transform = aTransform;
        this.transform.setOwner(this);
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.setConstantValueCount();
        super.init(initAction);
        this.setValueCount(initAction.getValueCount());
    }

    protected void setValueCount(int aValueCount) {
        this.valueCount = aValueCount;
    }

    protected int getValueCount() {
        return this.valueCount;
    }

    public void build(ABuildAction buildAction) {
        int n = this.getValueCount();
        if (n == -1) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            buildAction.setValueIndex(i);
            this.buildOne(buildAction);
        }
        buildAction.getResetAction().apply(this);
    }

    protected void resetNetwork(Action action) {
        try {
            action.pushName(this);
            this.transform.push(action);
            this.transform.apply(action);
            AResetAction resetAction = action.getResetAction();
            resetAction.apply(this);
        }
        catch (MissingValueException missingValueException) {
        }
        finally {
            this.transform.pop(action);
            action.popName(this);
        }
    }

    protected void buildOne(ABuildAction buildAction) {
        try {
            buildAction.pushName(this);
            this.transform.push(buildAction);
            this.transform.apply(buildAction);
            this.render(buildAction);
        }
        catch (MissingValueException missingValueException) {
        }
        finally {
            this.transform.pop(buildAction);
            buildAction.popName(this);
        }
    }

    protected abstract void render(ABuildAction var1) throws MissingValueException;

    public void computeBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        int n = this.getValueCount();
        if (n == -1) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            bBoxAction.setValueIndex(i);
            this.computeBoundingBoxOne(bBoxAction);
        }
        bBoxAction.getResetAction().apply(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeBoundingBoxOne(AComputeBoundingBoxAction bBoxAction) {
        try {
            this.transform.push(bBoxAction);
            this.transform.apply(bBoxAction);
            this.transform.getMatrix(bBoxAction, bBoxAction.matrix);
            this.getBoundingBox(bBoxAction);
            BoundingBox ebox = bBoxAction.getElementBoundingBox();
            BoundingBox nbox = bBoxAction.getNetworkBoundingBox();
            ebox.transform(bBoxAction.matrix);
            nbox.union(ebox);
            ebox.makeEmpty();
        }
        catch (MissingValueException missingValueException) {
        }
        finally {
            this.transform.pop(bBoxAction);
        }
    }

    protected abstract void getBoundingBox(AComputeBoundingBoxAction var1) throws MissingValueException;

    public void setUserData(Object o) {
        this.userData = o;
    }

    public Object getUserData() {
        return this.userData;
    }

    public SelectEntry buildSelectEntry(int valueIndex) {
        SelectEntry se = new SelectEntry();
        se.setElement(this);
        se.setValueIndex(valueIndex);
        return se;
    }

    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        return null;
    }

    protected boolean canHaveSelectDetails() {
        return true;
    }
}

