/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericMap;
import com.sas.graphics.util.vtk.RangeTable;
import com.sas.graphics.util.vtk.VTKError;

public class DiscreteRangeToNumericMap
extends NumericMap {
    protected double[] numericValues;
    protected RangeTable rangeTable = new RangeTable();

    @Override
    public void init(AInitAction ia) {
        block12: {
            Formatter labelFormat;
            int i;
            double[] rangeValues;
            block13: {
                block11: {
                    String str;
                    if (ia.beenInitialized(this)) {
                        return;
                    }
                    if (this.rangeTable.size() == 0) {
                        throw new VTKError("No range values specified in the RangeToNumMapper.");
                    }
                    rangeValues = this.rangeTable.getRanges();
                    if (this.numericValues == null) {
                        this.numericValues = new double[this.rangeTable.size() - 1];
                        this.numericValues[0] = 0.0;
                        double increment = 1.0;
                        for (i = 1; i < this.rangeTable.size() - 1; ++i) {
                            this.numericValues[i] = this.numericValues[i - 1] + increment;
                        }
                    }
                    labelFormat = this.getOwnerFormatter();
                    this.uniqueValueVector.setSize(this.numericValues.length);
                    this.labelVector.setSize(this.numericValues.length);
                    if (this.numericValues.length >= this.rangeTable.size()) break block11;
                    if (this.numericValues.length > 0) {
                        str = labelFormat.format(new Double(rangeValues[0])).trim() + " - " + labelFormat.format(new Double(rangeValues[1])).trim();
                        this.labelVector.setValueAt(str, 0);
                    }
                    for (i = 1; i < this.numericValues.length; ++i) {
                        str = labelFormat.format(new Double(rangeValues[i])).trim() + " - " + labelFormat.format(new Double(rangeValues[i + 1])).trim();
                        this.labelVector.setValueAt(str, i);
                    }
                    for (i = 0; i < this.numericValues.length; ++i) {
                        this.uniqueValueVector.setValueAt(this.numericValues[i], i);
                    }
                    break block12;
                }
                if (this.numericValues.length != this.rangeTable.size()) break block13;
                for (i = 0; i < this.rangeTable.size(); ++i) {
                    String str = i == 0 ? "   <= " + labelFormat.format(new Double(rangeValues[i])).trim() : labelFormat.format(new Double(rangeValues[i - 1])).trim() + " - " + labelFormat.format(new Double(rangeValues[i])).trim();
                    this.labelVector.setValueAt(str, i);
                }
                for (i = 0; i < this.numericValues.length; ++i) {
                    this.uniqueValueVector.setValueAt(this.numericValues[i], i);
                }
                break block12;
            }
            if (this.numericValues.length <= this.rangeTable.size()) break block12;
            for (i = 0; i < this.rangeTable.size() + 1; ++i) {
                String str = i == 0 ? "   <= " + labelFormat.format(new Double(rangeValues[i])).trim() : (i == this.rangeTable.size() ? "    > " + labelFormat.format(new Double(rangeValues[i - 1])).trim() : labelFormat.format(new Double(rangeValues[i - 1])).trim() + " - " + labelFormat.format(new Double(rangeValues[i])).trim());
                this.labelVector.setValueAt(str, i);
            }
            for (i = 0; i < this.rangeTable.size() + 1; ++i) {
                this.uniqueValueVector.setValueAt(this.numericValues[i], i);
            }
        }
    }

    public double getValue(double d) throws MissingValueException {
        int range = this.rangeTable.getValue(d);
        if (this.numericValues.length < this.rangeTable.size()) {
            if (range > this.numericValues.length) {
                Debug.println((String)("Value " + d + " is higher than the specified ranges. Using HIGHEST range numeric value."));
                range = this.numericValues.length - 1;
            } else if (range != 0) {
                --range;
            }
        } else if (this.numericValues.length == this.rangeTable.size() && range >= this.numericValues.length) {
            Debug.println((String)("Value " + d + " is higher than the specified ranges. Using HIGHEST range numeric value."));
            range = this.uniqueValueVector.size() - 1;
        }
        return this.uniqueValueVector.getValue(range);
    }

    @Override
    public double getOutputMin() {
        if (this.uniqueValueVector.size() != 0) {
            double min = Double.MAX_VALUE;
            for (int i = 0; i < this.uniqueValueVector.size(); ++i) {
                try {
                    min = Math.min(min, this.uniqueValueVector.getValue(i));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            return min;
        }
        throw new VTKError("No values exist in the uniqueValueVector of the RangeToNumMapper, hence cannot give Output Min value");
    }

    @Override
    public double getOutputMax() {
        if (this.uniqueValueVector.size() != 0) {
            double max = Double.MIN_VALUE;
            for (int i = 0; i < this.uniqueValueVector.size(); ++i) {
                try {
                    max = Math.max(max, this.uniqueValueVector.getValue(i));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            return max;
        }
        throw new VTKError("No values exist in the uniqueValueVector of the RangeToNumMapper, hence cannot give Output Min value");
    }

    public double[] getRangeValue() {
        return this.rangeTable.getRanges();
    }

    public double[] getNumericValue() {
        return this.numericValues;
    }

    public void setRangeValue(double[] value) {
        this.rangeTable.setRanges(value);
        this.setModified();
    }

    public void setNumericValue(double[] value) {
        if (value.length == 0) {
            throw new VTKError("No numeric values specified for the Numeric array in the RangeToNumMapper.");
        }
        this.numericValues = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            this.numericValues[i] = value[i];
        }
        this.setModified();
    }

    public void setLowerExclude(boolean trueOrFalse) {
        this.rangeTable.setLowerExclude(trueOrFalse);
    }

    public boolean isLowerExclude() {
        return this.rangeTable.isLowerExclude();
    }
}

